/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.confluence;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageSummary;

public class ConfluenceUtils {
    public static String decode(String value) {
        if (null == value) {
            return value;
        }
        return value.replace("{", "\\{").replace("}", "\\}");
    }

    public static String encodeAnchor(String value) {
        if (null == value) {
            return null;
        }
        String v = ConfluenceUtils.decode(value);
        try {
            new URL(v);
            return v;
        }
        catch (MalformedURLException e) {
            return v.replace(':', '_');
        }
    }

    public static PageSummary findPageByTitle(Confluence confluence, String parentPageId, String title) throws Exception {
        if (null == confluence) {
            throw new IllegalArgumentException("confluence instance is null");
        }
        List children = confluence.getChildren(parentPageId);
        for (PageSummary pageSummary : children) {
            if (!title.equals(pageSummary.getTitle())) continue;
            return pageSummary;
        }
        return null;
    }

    public static Page getOrCreatePage(Confluence confluence, String spaceKey, String parentPageTitle, String title) throws Exception {
        Page result;
        if (null == confluence) {
            throw new IllegalArgumentException("confluence instance is null");
        }
        Page parentPage = confluence.getPage(spaceKey, parentPageTitle);
        PageSummary pageSummary = ConfluenceUtils.findPageByTitle(confluence, parentPage.getId(), title);
        if (null != pageSummary) {
            result = confluence.getPage(pageSummary.getId());
        } else {
            result = new Page(Collections.EMPTY_MAP);
            result.setSpace(parentPage.getSpace());
            result.setParentId(parentPage.getId());
            result.setTitle(title);
        }
        return result;
    }

    public static Page getOrCreatePage(Confluence confluence, Page parentPage, String title) throws Exception {
        Page result;
        if (null == confluence) {
            throw new IllegalArgumentException("confluence instance is null");
        }
        PageSummary pageSummary = ConfluenceUtils.findPageByTitle(confluence, parentPage.getId(), title);
        if (null != pageSummary) {
            result = confluence.getPage(pageSummary.getId());
        } else {
            result = new Page(Collections.EMPTY_MAP);
            result.setSpace(parentPage.getSpace());
            result.setParentId(parentPage.getId());
            result.setTitle(title);
        }
        return result;
    }

    public static void addAttchment(Confluence confluence, Page page, Attachment attachment, File source) {
    }
}

