/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.miniTemplator;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;

class MiniTemplatorParser {
    private static final int maxNestingLevel = 20;
    private static final int maxInclTemplateSize = 1000000;
    public String template;
    public String[] varTab;
    public int varTabCnt;
    private HashMap<String, Integer> varNameToNoMap;
    public VarRefTabRec[] varRefTab;
    public int varRefTabCnt;
    public BlockTabRec[] blockTab;
    public int blockTabCnt;
    private HashMap<String, Integer> blockNameToNoMap;
    private int currentNestingLevel;
    private int[] openBlocksTab;
    private MiniTemplator miniTemplator;
    private boolean resumeCmdParsingFromStart;

    public MiniTemplatorParser(String string, MiniTemplator miniTemplator) throws MiniTemplator.TemplateSyntaxException {
        this.template = string;
        this.miniTemplator = miniTemplator;
        this.parseTemplate();
        this.miniTemplator = null;
    }

    private void parseTemplate() throws MiniTemplator.TemplateSyntaxException {
        this.initParsing();
        this.beginMainBlock();
        this.parseTemplateCommands();
        this.endMainBlock();
        this.checkBlockDefinitionsComplete();
        this.parseTemplateVariables();
        this.associateVariablesWithBlocks();
        this.terminateParsing();
    }

    private void initParsing() {
        this.varTab = new String[64];
        this.varTabCnt = 0;
        this.varNameToNoMap = new HashMap();
        this.varRefTab = new VarRefTabRec[64];
        this.varRefTabCnt = 0;
        this.blockTab = new BlockTabRec[16];
        this.blockTabCnt = 0;
        this.blockNameToNoMap = new HashMap();
        this.openBlocksTab = new int[21];
    }

    private void terminateParsing() {
        this.openBlocksTab = null;
    }

    private void beginMainBlock() {
        int n = this.registerBlock("$InternalMainBlock$");
        BlockTabRec blockTabRec = this.blockTab[n];
        blockTabRec.tPosBegin = 0;
        blockTabRec.tPosContentsBegin = 0;
        blockTabRec.nestingLevel = 0;
        blockTabRec.parentBlockNo = -1;
        blockTabRec.definitionIsOpen = true;
        this.openBlocksTab[0] = n;
        this.currentNestingLevel = 1;
    }

    private void endMainBlock() {
        BlockTabRec blockTabRec = this.blockTab[0];
        blockTabRec.tPosContentsEnd = this.template.length();
        blockTabRec.tPosEnd = this.template.length();
        blockTabRec.definitionIsOpen = false;
        --this.currentNestingLevel;
    }

    private void parseTemplateCommands() throws MiniTemplator.TemplateSyntaxException {
        int n;
        int n2 = 0;
        while ((n = this.template.indexOf("<!--", n2)) != -1) {
            n2 = this.template.indexOf("-->", n);
            if (n2 == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Invalid HTML comment in template at offset " + n + ".");
            }
            String string = this.template.substring(n + 4, (n2 += 3) - 3);
            this.resumeCmdParsingFromStart = false;
            this.processTemplateCommand(string, n, n2);
            if (!this.resumeCmdParsingFromStart) continue;
            n2 = n;
        }
    }

    private void processTemplateCommand(String string, int n, int n2) throws MiniTemplator.TemplateSyntaxException {
        int n3 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n3 >= string.length()) {
            return;
        }
        int n4 = MiniTemplatorParser.skipNonBlanks(string, n3);
        String string2 = string.substring(n3, n4);
        String string3 = string.substring(n4);
        if (string2.equalsIgnoreCase("$BeginBlock")) {
            this.processBeginBlockCmd(string3, n, n2);
        } else if (string2.equalsIgnoreCase("$EndBlock")) {
            this.processEndBlockCmd(string3, n, n2);
        } else if (string2.equalsIgnoreCase("$Include")) {
            this.processIncludeCmd(string3, n, n2);
        } else if (string2.startsWith("$") && !string2.startsWith("${")) {
            throw new MiniTemplator.TemplateSyntaxException("Unknown command \"" + string2 + "\" in template at offset " + n + ".");
        }
    }

    private void processBeginBlockCmd(String string, int n, int n2) throws MiniTemplator.TemplateSyntaxException {
        int n3 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n3 >= string.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing block name in $BeginBlock command in template at offset " + n + ".");
        }
        int n4 = MiniTemplatorParser.skipNonBlanks(string, n3);
        String string2 = string.substring(n3, n4);
        if (!MiniTemplatorParser.isRestOfStringBlank(string, n4)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $BeginBlock command in template at offset " + n + ".");
        }
        int n5 = this.registerBlock(string2);
        BlockTabRec blockTabRec = this.blockTab[n5];
        blockTabRec.tPosBegin = n;
        blockTabRec.tPosContentsBegin = n2;
        blockTabRec.nestingLevel = this.currentNestingLevel;
        blockTabRec.parentBlockNo = this.openBlocksTab[this.currentNestingLevel - 1];
        this.openBlocksTab[this.currentNestingLevel] = n5;
        ++this.currentNestingLevel;
        if (this.currentNestingLevel > 20) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting overflow for block \"" + string2 + "\" in template at offset " + n + ".");
        }
    }

    private void processEndBlockCmd(String string, int n, int n2) throws MiniTemplator.TemplateSyntaxException {
        int n3 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n3 >= string.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing block name in $EndBlock command in template at offset " + n + ".");
        }
        int n4 = MiniTemplatorParser.skipNonBlanks(string, n3);
        String string2 = string.substring(n3, n4);
        if (!MiniTemplatorParser.isRestOfStringBlank(string, n4)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $EndBlock command in template at offset " + n + ".");
        }
        int n5 = this.lookupBlockName(string2);
        if (n5 == -1) {
            throw new MiniTemplator.TemplateSyntaxException("Undefined block name \"" + string2 + "\" in $EndBlock command in template at offset " + n + ".");
        }
        --this.currentNestingLevel;
        BlockTabRec blockTabRec = this.blockTab[n5];
        if (!blockTabRec.definitionIsOpen) {
            throw new MiniTemplator.TemplateSyntaxException("Multiple $EndBlock command for block \"" + string2 + "\" in template at offset " + n + ".");
        }
        if (blockTabRec.nestingLevel != this.currentNestingLevel) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting level mismatch at $EndBlock command for block \"" + string2 + "\" in template at offset " + n + ".");
        }
        blockTabRec.tPosContentsEnd = n;
        blockTabRec.tPosEnd = n2;
        blockTabRec.definitionIsOpen = false;
    }

    private int registerBlock(String string) {
        BlockTabRec blockTabRec;
        int n = this.blockTabCnt++;
        if (this.blockTabCnt > this.blockTab.length) {
            this.blockTab = (BlockTabRec[])MiniTemplatorParser.resizeArray(this.blockTab, 2 * this.blockTabCnt);
        }
        this.blockTab[n] = blockTabRec = new BlockTabRec();
        blockTabRec.blockName = string;
        blockTabRec.nextWithSameName = this.lookupBlockName(string);
        blockTabRec.definitionIsOpen = true;
        blockTabRec.blockVarCnt = 0;
        blockTabRec.firstVarRefNo = -1;
        blockTabRec.blockVarNoToVarNoMap = new int[32];
        this.blockNameToNoMap.put(string.toUpperCase(), new Integer(n));
        return n;
    }

    private void checkBlockDefinitionsComplete() throws MiniTemplator.TemplateSyntaxException {
        for (int i = 0; i < this.blockTabCnt; ++i) {
            BlockTabRec blockTabRec = this.blockTab[i];
            if (!blockTabRec.definitionIsOpen) continue;
            throw new MiniTemplator.TemplateSyntaxException("Missing $EndBlock command in template for block \"" + blockTabRec.blockName + "\".");
        }
        if (this.currentNestingLevel != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting level error at end of template.");
        }
    }

    private void processIncludeCmd(String string, int n, int n2) throws MiniTemplator.TemplateSyntaxException {
        int n3;
        int n4 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n4 >= string.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing subtemplate name in $Include command in template at offset " + n + ".");
        }
        if (string.charAt(n4) == '\"') {
            if ((n3 = string.indexOf(34, ++n4)) == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Missing closing quote for subtemplate name in $Include command in template at offset " + n + ".");
            }
        } else {
            n3 = MiniTemplatorParser.skipNonBlanks(string, n4);
        }
        String string2 = string.substring(n4, n3);
        if (!MiniTemplatorParser.isRestOfStringBlank(string, ++n3)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $Include command in template at offset " + n + ".");
        }
        this.insertSubtemplate(string2, n, n2);
    }

    private void insertSubtemplate(String string, int n, int n2) {
        String string2;
        if (this.template.length() > 1000000) {
            throw new RuntimeException("Subtemplate include aborted because the internal template string is longer than 1000000 characters.");
        }
        try {
            string2 = this.miniTemplator.loadSubtemplate(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error while loading subtemplate \"" + string + "\"", iOException);
        }
        StringBuilder stringBuilder = new StringBuilder(this.template.length() + string2.length());
        stringBuilder.append(this.template, 0, n);
        stringBuilder.append(string2);
        stringBuilder.append(this.template, n2, this.template.length());
        this.template = stringBuilder.toString();
        this.resumeCmdParsingFromStart = true;
    }

    private void associateVariablesWithBlocks() {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n < this.varRefTabCnt) {
            int n4;
            VarRefTabRec varRefTabRec = this.varRefTab[n];
            int n5 = varRefTabRec.tPosBegin;
            int n6 = varRefTabRec.varNo;
            if (n5 >= this.blockTab[n2].tPosEnd) {
                n2 = this.blockTab[n2].parentBlockNo;
                continue;
            }
            if (n3 < this.blockTabCnt && n5 >= this.blockTab[n3].tPosBegin) {
                n2 = n3++;
                continue;
            }
            BlockTabRec blockTabRec = this.blockTab[n2];
            if (n5 < blockTabRec.tPosBegin) {
                throw new Error();
            }
            ++blockTabRec.blockVarCnt;
            if (blockTabRec.blockVarCnt > blockTabRec.blockVarNoToVarNoMap.length) {
                blockTabRec.blockVarNoToVarNoMap = (int[])MiniTemplatorParser.resizeArray(blockTabRec.blockVarNoToVarNoMap, 2 * blockTabRec.blockVarCnt);
            }
            blockTabRec.blockVarNoToVarNoMap[n4] = n6;
            if (blockTabRec.firstVarRefNo == -1) {
                blockTabRec.firstVarRefNo = n;
            }
            varRefTabRec.blockNo = n2;
            varRefTabRec.blockVarNo = n4;
            ++n;
        }
    }

    private void parseTemplateVariables() throws MiniTemplator.TemplateSyntaxException {
        int n = 0;
        while ((n = this.template.indexOf("${", n)) != -1) {
            String string;
            int n2 = n;
            if ((n = this.template.indexOf("}", n)) == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Invalid variable reference in template at offset " + n2 + ".");
            }
            if ((string = this.template.substring(n2 + 2, ++n - 1).trim()).length() == 0) {
                throw new MiniTemplator.TemplateSyntaxException("Empty variable name in template at offset " + n2 + ".");
            }
            this.registerVariableReference(string, n2, n);
        }
    }

    private void registerVariableReference(String string, int n, int n2) {
        VarRefTabRec varRefTabRec;
        int n3 = this.lookupVariableName(string);
        if (n3 == -1) {
            n3 = this.registerVariable(string);
        }
        int n4 = this.varRefTabCnt++;
        if (this.varRefTabCnt > this.varRefTab.length) {
            this.varRefTab = (VarRefTabRec[])MiniTemplatorParser.resizeArray(this.varRefTab, 2 * this.varRefTabCnt);
        }
        this.varRefTab[n4] = varRefTabRec = new VarRefTabRec();
        varRefTabRec.tPosBegin = n;
        varRefTabRec.tPosEnd = n2;
        varRefTabRec.varNo = n3;
    }

    private int registerVariable(String string) {
        int n = this.varTabCnt++;
        if (this.varTabCnt > this.varTab.length) {
            this.varTab = (String[])MiniTemplatorParser.resizeArray(this.varTab, 2 * this.varTabCnt);
        }
        this.varTab[n] = string;
        this.varNameToNoMap.put(string.toUpperCase(), new Integer(n));
        return n;
    }

    public int lookupVariableName(String string) {
        Integer n = this.varNameToNoMap.get(string.toUpperCase());
        if (n == null) {
            return -1;
        }
        int n2 = n;
        return n2;
    }

    public int lookupBlockName(String string) {
        Integer n = this.blockNameToNoMap.get(string.toUpperCase());
        if (n == null) {
            return -1;
        }
        int n2 = n;
        return n2;
    }

    public static Object resizeArray(Object object, int n) {
        int n2 = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        int n3 = Math.min(n2, n);
        if (n3 > 0) {
            System.arraycopy(object, 0, object2, 0, n3);
        }
        return object2;
    }

    private static int skipBlanks(String string, int n) {
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static int skipNonBlanks(String string, int n) {
        while (n < string.length() && !Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public static boolean isRestOfStringBlank(String string, int n) {
        return MiniTemplatorParser.skipBlanks(string, n) >= string.length();
    }

    public static class BlockTabRec {
        String blockName;
        int nextWithSameName;
        int tPosBegin;
        int tPosContentsBegin;
        int tPosContentsEnd;
        int tPosEnd;
        int nestingLevel;
        int parentBlockNo;
        boolean definitionIsOpen;
        int blockVarCnt;
        int[] blockVarNoToVarNoMap;
        int firstVarRefNo;
    }

    public static class VarRefTabRec {
        int varNo;
        int tPosBegin;
        int tPosEnd;
        int blockNo;
        int blockVarNo;
    }
}

