/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.miniTemplator;

import biz.source_code.miniTemplator.MiniTemplatorParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class MiniTemplator {
    private MiniTemplatorParser mtp;
    private Charset charset;
    private String subtemplateBasePath;
    private String[] varValuesTab;
    private BlockDynTabRec[] blockDynTab;
    private BlockInstTabRec[] blockInstTab;
    private int blockInstTabCnt;

    public MiniTemplator(File file) throws IOException, TemplateSyntaxException {
        this(file, file.getParent());
    }

    public MiniTemplator(File file, String string) throws IOException, TemplateSyntaxException {
        this(file, string, Charset.defaultCharset());
    }

    public MiniTemplator(File file, String string, Charset charset) throws IOException, TemplateSyntaxException {
        this.subtemplateBasePath = string;
        this.charset = charset;
        this.init(this.readFileIntoString(file));
    }

    public MiniTemplator(Reader reader) throws IOException, TemplateSyntaxException {
        this.init(MiniTemplator.readStreamIntoString(reader));
    }

    public MiniTemplator(String string) throws TemplateSyntaxException {
        this.init(string);
    }

    private MiniTemplator() {
    }

    private void init(String string) throws TemplateSyntaxException {
        if (this.charset == null) {
            this.charset = Charset.defaultCharset();
        }
        this.mtp = new MiniTemplatorParser(string, this);
        this.reset();
    }

    protected String loadSubtemplate(String string) throws IOException {
        File file = new File(this.subtemplateBasePath, string);
        return this.readFileIntoString(file);
    }

    public void reset() {
        int n;
        if (this.varValuesTab == null) {
            this.varValuesTab = new String[this.mtp.varTabCnt];
        } else {
            for (n = 0; n < this.mtp.varTabCnt; ++n) {
                this.varValuesTab[n] = null;
            }
        }
        if (this.blockDynTab == null) {
            this.blockDynTab = new BlockDynTabRec[this.mtp.blockTabCnt];
        }
        for (n = 0; n < this.mtp.blockTabCnt; ++n) {
            BlockDynTabRec blockDynTabRec = this.blockDynTab[n];
            if (blockDynTabRec == null) {
                this.blockDynTab[n] = blockDynTabRec = new BlockDynTabRec();
            }
            blockDynTabRec.instances = 0;
            blockDynTabRec.firstBlockInstNo = -1;
            blockDynTabRec.lastBlockInstNo = -1;
        }
        this.blockInstTabCnt = 0;
    }

    public MiniTemplator cloneReset() {
        MiniTemplator miniTemplator = new MiniTemplator();
        miniTemplator.mtp = this.mtp;
        miniTemplator.charset = this.charset;
        miniTemplator.reset();
        return miniTemplator;
    }

    public void setVariable(String string, String string2) throws VariableNotDefinedException {
        this.setVariable(string, string2, false);
    }

    public void setVariable(String string, String string2, boolean bl) throws VariableNotDefinedException {
        int n = this.mtp.lookupVariableName(string);
        if (n == -1) {
            if (bl) {
                return;
            }
            throw new VariableNotDefinedException(string);
        }
        this.varValuesTab[n] = string2;
    }

    public void setVariableEsc(String string, String string2) throws VariableNotDefinedException {
        this.setVariable(string, MiniTemplator.escapeHtml(string2), false);
    }

    public void setVariableEsc(String string, String string2, boolean bl) throws VariableNotDefinedException {
        this.setVariable(string, MiniTemplator.escapeHtml(string2), bl);
    }

    public boolean variableExists(String string) {
        return this.mtp.lookupVariableName(string) != -1;
    }

    public void addBlock(String string) throws BlockNotDefinedException {
        int n = this.mtp.lookupBlockName(string);
        if (n == -1) {
            throw new BlockNotDefinedException(string);
        }
        while (n != -1) {
            this.addBlockByNo(n);
            n = this.mtp.blockTab[n].nextWithSameName;
        }
    }

    private void addBlockByNo(int n) {
        MiniTemplatorParser.BlockTabRec blockTabRec = this.mtp.blockTab[n];
        BlockDynTabRec blockDynTabRec = this.blockDynTab[n];
        int n2 = this.registerBlockInstance();
        BlockInstTabRec blockInstTabRec = this.blockInstTab[n2];
        if (blockDynTabRec.firstBlockInstNo == -1) {
            blockDynTabRec.firstBlockInstNo = n2;
        }
        if (blockDynTabRec.lastBlockInstNo != -1) {
            this.blockInstTab[blockDynTabRec.lastBlockInstNo].nextBlockInstNo = n2;
        }
        blockDynTabRec.lastBlockInstNo = n2;
        blockInstTabRec.blockNo = n;
        blockInstTabRec.instanceLevel = blockDynTabRec.instances++;
        blockInstTabRec.parentInstLevel = blockTabRec.parentBlockNo == -1 ? -1 : this.blockDynTab[blockTabRec.parentBlockNo].instances;
        blockInstTabRec.nextBlockInstNo = -1;
        if (blockTabRec.blockVarCnt > 0) {
            blockInstTabRec.blockVarTab = new String[blockTabRec.blockVarCnt];
        }
        for (int i = 0; i < blockTabRec.blockVarCnt; ++i) {
            int n3 = blockTabRec.blockVarNoToVarNoMap[i];
            blockInstTabRec.blockVarTab[i] = this.varValuesTab[n3];
        }
    }

    private int registerBlockInstance() {
        int n = this.blockInstTabCnt++;
        if (this.blockInstTab == null) {
            this.blockInstTab = new BlockInstTabRec[64];
        }
        if (this.blockInstTabCnt > this.blockInstTab.length) {
            this.blockInstTab = (BlockInstTabRec[])MiniTemplatorParser.resizeArray(this.blockInstTab, 2 * this.blockInstTabCnt);
        }
        this.blockInstTab[n] = new BlockInstTabRec();
        return n;
    }

    public boolean blockExists(String string) {
        return this.mtp.lookupBlockName(string) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutput(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.charset);
            this.generateOutput(outputStreamWriter);
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void generateOutput(Writer writer) throws IOException {
        String string = this.generateOutput();
        writer.write(string);
    }

    public String generateOutput() {
        if (this.blockDynTab[0].instances == 0) {
            this.addBlockByNo(0);
        }
        for (int i = 0; i < this.mtp.blockTabCnt; ++i) {
            BlockDynTabRec blockDynTabRec = this.blockDynTab[i];
            blockDynTabRec.currBlockInstNo = blockDynTabRec.firstBlockInstNo;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.writeBlockInstances(stringBuilder, 0, -1);
        return stringBuilder.toString();
    }

    private void writeBlockInstances(StringBuilder stringBuilder, int n, int n2) {
        int n3;
        BlockDynTabRec blockDynTabRec = this.blockDynTab[n];
        while ((n3 = blockDynTabRec.currBlockInstNo) != -1) {
            BlockInstTabRec blockInstTabRec = this.blockInstTab[n3];
            if (blockInstTabRec.parentInstLevel < n2) {
                throw new Error();
            }
            if (blockInstTabRec.parentInstLevel > n2) break;
            this.writeBlockInstance(stringBuilder, n3);
            blockDynTabRec.currBlockInstNo = blockInstTabRec.nextBlockInstNo;
        }
    }

    private void writeBlockInstance(StringBuilder stringBuilder, int n) {
        BlockInstTabRec blockInstTabRec = this.blockInstTab[n];
        int n2 = blockInstTabRec.blockNo;
        MiniTemplatorParser.BlockTabRec blockTabRec = this.mtp.blockTab[n2];
        int n3 = blockTabRec.tPosContentsBegin;
        int n4 = n2 + 1;
        int n5 = blockTabRec.firstVarRefNo;
        while (true) {
            Object object;
            int n6 = blockTabRec.tPosContentsEnd;
            int n7 = 0;
            if (n5 != -1 && n5 < this.mtp.varRefTabCnt) {
                object = this.mtp.varRefTab[n5];
                if (((MiniTemplatorParser.VarRefTabRec)object).tPosBegin < n3) {
                    ++n5;
                    continue;
                }
                if (((MiniTemplatorParser.VarRefTabRec)object).tPosBegin < n6) {
                    n6 = ((MiniTemplatorParser.VarRefTabRec)object).tPosBegin;
                    n7 = 1;
                }
            }
            if (n4 < this.mtp.blockTabCnt) {
                object = this.mtp.blockTab[n4];
                if (((MiniTemplatorParser.BlockTabRec)object).tPosBegin < n3) {
                    ++n4;
                    continue;
                }
                if (((MiniTemplatorParser.BlockTabRec)object).tPosBegin < n6) {
                    n6 = ((MiniTemplatorParser.BlockTabRec)object).tPosBegin;
                    n7 = 2;
                }
            }
            if (n6 > n3) {
                stringBuilder.append(this.mtp.template.substring(n3, n6));
            }
            switch (n7) {
                case 0: {
                    return;
                }
                case 1: {
                    object = this.mtp.varRefTab[n5];
                    if (((MiniTemplatorParser.VarRefTabRec)object).blockNo != n2) {
                        throw new Error();
                    }
                    String string = blockInstTabRec.blockVarTab[((MiniTemplatorParser.VarRefTabRec)object).blockVarNo];
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    n3 = ((MiniTemplatorParser.VarRefTabRec)object).tPosEnd;
                    ++n5;
                    break;
                }
                case 2: {
                    object = this.mtp.blockTab[n4];
                    if (((MiniTemplatorParser.BlockTabRec)object).parentBlockNo != n2) {
                        throw new Error();
                    }
                    this.writeBlockInstances(stringBuilder, n4, blockInstTabRec.instanceLevel);
                    n3 = ((MiniTemplatorParser.BlockTabRec)object).tPosEnd;
                    ++n4;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileIntoString(File file) throws IOException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.charset);
            String string = MiniTemplator.readStreamIntoString(inputStreamReader);
            return string;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private static String readStreamIntoString(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[65536];
        while ((n = reader.read(cArray)) != -1) {
            if (n <= 0) {
                throw new IOException();
            }
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static String escapeHtml(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        boolean bl = false;
        block10: for (n = 0; n < n2; ++n) {
            switch (string.charAt(n)) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    bl = true;
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        if (!bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 + 16);
        stringBuilder.append(string.substring(0, n));
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    break;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    break;
                }
                case '\"': {
                    stringBuilder.append("&#34;");
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private static class BlockInstTabRec {
        int blockNo;
        int instanceLevel;
        int parentInstLevel;
        int nextBlockInstNo;
        String[] blockVarTab;

        private BlockInstTabRec() {
        }
    }

    private static class BlockDynTabRec {
        int instances;
        int firstBlockInstNo;
        int lastBlockInstNo;
        int currBlockInstNo;

        private BlockDynTabRec() {
        }
    }

    public static class BlockNotDefinedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BlockNotDefinedException(String string) {
            super("Block \"" + string + "\" not defined in template.");
        }
    }

    public static class VariableNotDefinedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public VariableNotDefinedException(String string) {
            super("Variable \"" + string + "\" not defined in template.");
        }
    }

    public static class TemplateSyntaxException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TemplateSyntaxException(String string) {
            super("Syntax error in template: " + string);
        }
    }
}

