/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.confluence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ExportFormat;
import org.codehaus.swizzle.confluence.Page;

public class ConfluenceExportDecorator {
    final Confluence confluence;
    final String url;
    final String username;
    final String password;

    public ConfluenceExportDecorator(Confluence confluence, String url, String username, String password) {
        assert (url != null);
        assert (confluence != null);
        assert (username != null);
        assert (password != null);
        if (confluence == null) {
            throw new IllegalArgumentException("confluence is null!");
        }
        if (username == null) {
            throw new IllegalArgumentException("username is null!");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null!");
        }
        this.confluence = confluence;
        this.username = username;
        this.password = password;
        this.url = url;
    }

    public final void exportPage(String space, String pageTitle, ExportFormat format, final File outputFile) throws Exception {
        assert (space != null);
        assert (pageTitle != null);
        assert (format != null);
        assert (outputFile != null);
        if (space == null) {
            throw new IllegalArgumentException("space is null!");
        }
        if (pageTitle == null) {
            throw new IllegalArgumentException("pageTitle is null!");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null!");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile is null!");
        }
        if (outputFile.exists() && !outputFile.isFile()) {
            throw new IllegalArgumentException("outputFile is not a file!");
        }
        Page page = this.confluence.getPage(space, pageTitle);
        final HttpClient client = new HttpClient();
        client.getParams().setCookiePolicy("compatibility");
        this.login(client, String.format("%s?pageId=%s", format.url, page.getId()), new RedirectTask(){

            @Override
            public void exec(String location) throws Exception {
                ConfluenceExportDecorator.this.exportpdf(client, location, outputFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(HttpClient client, String redirectUrl, RedirectTask task) throws Exception {
        block6: {
            PostMethod post = null;
            try {
                String login = String.format("%s/%s", this.url, "login.action");
                post = new PostMethod(login);
                post.setDoAuthentication(true);
                post.addParameter("os_username", this.username);
                post.addParameter("os_password", this.password);
                post.addParameter("os_destination", redirectUrl);
                post.addParameter("login", "Log+In");
                int statusCode = client.executeMethod((HttpMethod)post);
                if (statusCode != 200 && statusCode != 302) {
                    throw new HttpException(String.format("Execute ethod failed: [%s]", String.valueOf(post.getStatusLine())));
                }
                Header locationHeader = post.getResponseHeader("Location");
                if (locationHeader != null) {
                    String redirectLocation = locationHeader.getValue();
                    task.exec(redirectLocation);
                    break block6;
                }
                throw new HttpException(String.format("no redirect to url found\n[%s]", new String(post.getResponseBody())));
            }
            finally {
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportpdf(HttpClient client, String url, File outputFile) throws IOException {
        InputStream is = null;
        FileOutputStream fos = null;
        GetMethod get = null;
        try {
            get = new GetMethod(url);
            get.setRequestHeader("X-Atlassian-Token", "no-check");
            int statusCode = client.executeMethod((HttpMethod)get);
            if (statusCode != 200) {
                throw new HttpException(String.format("Execute ethod failed: [%s]", String.valueOf(get.getStatusLine())));
            }
            is = get.getResponseBodyAsStream();
            fos = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(fos);
            if (get != null) {
                get.releaseConnection();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)fos);
        if (get != null) {
            get.releaseConnection();
        }
    }

    static interface RedirectTask {
        public void exec(String var1) throws Exception;
    }
}

