/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.ssl;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.TrustManager;
import org.bsc.ssl.SSLFactories;
import org.bsc.ssl.YesHostnameVerifier;
import org.bsc.ssl.YesTrustManager;

public class SSLCertificateInfo {
    boolean ignore = true;
    String hostnameVerifierClass;
    String trustManagerClass;

    protected static <T> T newClass(String clazz, Class<T> type) {
        try {
            Class<?> loadedClass = Thread.currentThread().getContextClassLoader().loadClass(clazz);
            Object initClass = loadedClass.newInstance();
            return type.cast(initClass);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Could not found Class with name %s", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Could create Instance of Class with name %s. Class must be concrete.", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Could create Instance of Class with name %s. Class must have a no-arg constructor.", clazz);
            throw new IllegalStateException(msg, e);
        }
    }

    public void setup(String endpoint) {
        if ((this.ignore || this.hostnameVerifierClass != null || this.trustManagerClass != null) && endpoint.startsWith("https://")) {
            try {
                HttpsURLConnection.setDefaultSSLSocketFactory(SSLFactories.newInstance(this.trustManagerClass != null ? SSLCertificateInfo.newClass(this.trustManagerClass, TrustManager.class) : new YesTrustManager()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            HttpsURLConnection.setDefaultHostnameVerifier(this.hostnameVerifierClass != null ? SSLCertificateInfo.newClass(this.hostnameVerifierClass, HostnameVerifier.class) : new YesHostnameVerifier());
        }
    }

    public String toString() {
        return "SSLCertificate" + '{' + "ignore:" + this.ignore + ',' + "hostnameVerifierClass:'" + this.hostnameVerifierClass + "'," + "trustManagerClass:'" + this.trustManagerClass + ',' + '}';
    }
}

