/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Stack;
import org.bsc.functional.F;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;

public abstract class ToConfluenceSerializer
implements Visitor {
    private StringBuilder _buffer = new StringBuilder(512000);
    private final Stack<Node> nodeStack = new Stack();
    final SpecialPanelProcessor specialPanelProcessor = new SpecialPanelProcessor();

    public static int extensions() {
        int EXT = 0;
        EXT |= 0x80;
        EXT |= 0x20;
        return EXT |= 0x200;
    }

    public static int[] lineAndColFromNode(String text, Node node) {
        int lastEOL = 0;
        int prevEOL = 0;
        int length = text.length();
        int pos = 0;
        int line = 0;
        int col = 0;
        int offset = node.getStartIndex();
        if (offset > length) {
            offset = length;
        }
        while (pos < length && (pos = text.indexOf(10, pos)) != -1) {
            prevEOL = lastEOL;
            lastEOL = pos;
            if (pos > offset) break;
            ++line;
            ++pos;
        }
        if (prevEOL < offset && lastEOL >= offset) {
            col = offset - prevEOL;
        }
        return new int[]{++line, col};
    }

    public String toString() {
        return this._buffer.toString();
    }

    protected abstract void notImplementedYet(Node var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder bufferVisit(F<Void, Void> closure) {
        StringBuilder _sb = new StringBuilder();
        StringBuilder _original = this._buffer;
        this._buffer = _sb;
        try {
            closure.f(null);
        }
        finally {
            this._buffer = _original;
        }
        return _sb;
    }

    protected <T extends Node> void forEachChild(T node, FindPredicate<T> cb) {
        List children = node.getChildren();
        for (int index = 0; index < children.size(); ++index) {
            Node child = (Node)children.get(index);
            if (cb.f(child, node, index)) continue;
            return;
        }
    }

    protected <T extends Node> void visitChildren(T node) {
        for (Node child : node.getChildren()) {
            child.accept((Visitor)this);
        }
    }

    protected <T extends Node, R extends Node> boolean findByClass(T node, Class<R> clazz, FindPredicate<R> predicate) {
        Node child;
        boolean result = false;
        List children = node.getChildren();
        for (int index = 0; index < children.size() && !(result = clazz.isInstance(child = (Node)children.get(index)) && predicate.f((Node)clazz.cast(child), node, index) ? true : this.findByClass(child, clazz, predicate)); ++index) {
        }
        return result;
    }

    public void visit(RootNode rn) {
        this.visitChildren(rn);
    }

    public void visit(SuperNode sn) {
        this.visitChildren(sn);
    }

    public void visit(ParaNode pn) {
        this.visitChildren(pn);
        this._buffer.append('\n');
    }

    public void visit(HeaderNode hn) {
        this._buffer.append(String.format("h%s.", hn.getLevel()));
        this.visitChildren(hn);
        this._buffer.append('\n');
    }

    public void visit(final BlockQuoteNode bqn) {
        String text = this.bufferVisit(new F<Void, Void>(){

            @Override
            public Void f(Void p) {
                ToConfluenceSerializer.this.visitChildren(bqn);
                return null;
            }
        }).toString();
        String[] lines = text.split("\n");
        if (lines.length == 1) {
            this._buffer.append('\n').append("bq. ").append(text).append('\n');
            return;
        }
        if (this.specialPanelProcessor.apply(bqn)) {
            return;
        }
        this._buffer.append('\n').append("{quote}").append('\n').append(text).append('\n').append("{quote}").append('\n');
    }

    public void visit(TextNode tn) {
        this._buffer.append(tn.getText());
    }

    public void visit(ExpLinkNode eln) {
        this._buffer.append('[');
        this.visitChildren(eln);
        this._buffer.append(String.format("|%s|%s]", eln.url, eln.title));
    }

    public void visit(VerbatimNode vn) {
        String[] lines = vn.getText().split("\n");
        if (lines.length == 1) {
            this._buffer.append("{noformat}").append(vn.getText()).append("{noformat}");
            return;
        }
        if (vn.getType() == null || vn.getType().isEmpty()) {
            this._buffer.append("{noformat}").append('\n').append(vn.getText()).append('\n').append("{noformat}").append('\n');
            return;
        }
        this._buffer.append(String.format("{code:%s}", vn.getType())).append('\n').append(vn.getText()).append('\n').append("{code}").append('\n');
    }

    public void visit(CodeNode cn) {
        String[] lines = cn.getText().split("\n");
        if (lines.length == 1) {
            this._buffer.append("{{").append(cn.getText()).append("}}");
            return;
        }
        this._buffer.append("{code}").append('\n').append(cn.getText()).append("{code}").append('\n');
    }

    public void visit(StrongEmphSuperNode sesn) {
        String chars;
        char sym = '*';
        if (!sesn.isStrong() && (chars = sesn.getChars()).equals("_")) {
            sym = '_';
        }
        this._buffer.append(sym);
        this.visitChildren(sesn);
        this._buffer.append(sym);
    }

    public void visit(StrikeNode sn) {
        this._buffer.append("-");
        this.visitChildren(sn);
        this._buffer.append("-");
    }

    public void visit(BulletListNode bln) {
        this._buffer.append('\n');
        for (Node child : bln.getChildren()) {
            this._buffer.append("* ");
            child.accept((Visitor)this);
            this._buffer.append('\n');
        }
        this._buffer.append('\n');
    }

    public void visit(ListItemNode lin) {
        this.visitChildren(lin);
    }

    public void visit(ExpImageNode ein) {
        try {
            URI uri = new URI(ein.url);
            String scheme = uri.getScheme();
            if (!uri.isAbsolute() && (null == uri.getScheme() || scheme.isEmpty()) && this.findByClass(ein, TextNode.class, new FindPredicate<TextNode>(){

                @Override
                public boolean f(TextNode node, Node parent, int index) {
                    ToConfluenceSerializer.this._buffer.append(String.format("!%s!", node.getText()));
                    return true;
                }
            })) {
                return;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this._buffer.append(String.format("!%s!", ein.url));
    }

    public void visit(HtmlBlockNode hbn) {
    }

    public void visit(InlineHtmlNode ihn) {
    }

    public void visit(TableHeaderNode thn) {
        this.nodeStack.push((Node)thn);
        try {
            this.visitChildren(thn);
        }
        finally {
            assert (thn == this.nodeStack.pop());
        }
    }

    public void visit(TableBodyNode tbn) {
        this.nodeStack.push((Node)tbn);
        try {
            this.visitChildren(tbn);
        }
        finally {
            assert (tbn == this.nodeStack.pop());
        }
    }

    public void visit(TableRowNode trn) {
        Node n = this.nodeStack.peek();
        if (n instanceof TableHeaderNode) {
            this._buffer.append("||");
        } else if (n instanceof TableBodyNode) {
            this._buffer.append('|');
        }
        this.visitChildren(trn);
        this._buffer.append('\n');
    }

    public void visit(TableCaptionNode tcn) {
        this.notImplementedYet((Node)tcn);
    }

    public void visit(TableCellNode tcn) {
        Node n = this.nodeStack.peek();
        this.visitChildren(tcn);
        if (n instanceof TableHeaderNode) {
            this._buffer.append("||");
        } else if (n instanceof TableBodyNode) {
            this._buffer.append('|');
        }
    }

    public void visit(RefLinkNode rln) {
        this._buffer.append('[');
        this.visitChildren(rln);
        this._buffer.append(']');
    }

    public void visit(TableColumnNode tcn) {
        this.notImplementedYet((Node)tcn);
    }

    public void visit(TableNode tn) {
        this.visitChildren(tn);
    }

    public void visit(AnchorLinkNode aln) {
        this._buffer.append(aln.getText());
    }

    public void visit(SpecialTextNode stn) {
        this._buffer.append(stn.getText());
    }

    public void visit(AbbreviationNode an) {
        this.notImplementedYet((Node)an);
    }

    public void visit(AutoLinkNode aln) {
        this.notImplementedYet((Node)aln);
    }

    public void visit(DefinitionListNode dln) {
        this.notImplementedYet((Node)dln);
    }

    public void visit(DefinitionNode dn) {
        this.notImplementedYet((Node)dn);
    }

    public void visit(DefinitionTermNode dtn) {
        this.notImplementedYet((Node)dtn);
    }

    public void visit(MailLinkNode mln) {
        this.notImplementedYet((Node)mln);
    }

    public void visit(OrderedListNode oln) {
        this._buffer.append('\n');
        for (Node child : oln.getChildren()) {
            this._buffer.append("# ");
            child.accept((Visitor)this);
            this._buffer.append('\n');
        }
        this._buffer.append('\n');
    }

    public void visit(QuotedNode qn) {
        this.notImplementedYet((Node)qn);
    }

    public void visit(ReferenceNode rn) {
        this.notImplementedYet((Node)rn);
    }

    public void visit(RefImageNode rin) {
        this.notImplementedYet((Node)rin);
    }

    public void visit(SimpleNode sn) {
        this.notImplementedYet((Node)sn);
    }

    public void visit(WikiLinkNode wln) {
        this.notImplementedYet((Node)wln);
    }

    public void visit(Node node) {
        this.notImplementedYet(node);
    }

    protected class SpecialPanelProcessor {
        private String element;
        private String title;
        final FindPredicate<TextNode> isSpecialPanelText = new FindPredicate<TextNode>(){

            @Override
            public boolean f(TextNode p, Node parent, int index) {
                if (index != 0) {
                    return false;
                }
                if ("note:".equalsIgnoreCase(p.getText())) {
                    SpecialPanelProcessor.this.element = "note";
                    return true;
                }
                if ("warning:".equalsIgnoreCase(p.getText())) {
                    SpecialPanelProcessor.this.element = "warning";
                    return true;
                }
                if ("info:".equalsIgnoreCase(p.getText())) {
                    SpecialPanelProcessor.this.element = "info";
                    return true;
                }
                if ("tip:".equalsIgnoreCase(p.getText())) {
                    SpecialPanelProcessor.this.element = "tip";
                    return true;
                }
                return false;
            }
        };

        protected SpecialPanelProcessor() {
        }

        boolean apply(BlockQuoteNode bqn) {
            this.element = null;
            this.title = null;
            List children = bqn.getChildren();
            if (children.size() != 2) {
                return false;
            }
            Node node1 = (Node)bqn.getChildren().get(1);
            if (!(node1 instanceof BlockQuoteNode)) {
                return false;
            }
            boolean result = ToConfluenceSerializer.this.findByClass((Node)bqn.getChildren().get(0), StrongEmphSuperNode.class, new FindPredicate<StrongEmphSuperNode>(){

                @Override
                public boolean f(StrongEmphSuperNode p, final Node parent, int index) {
                    if (index != 0 || !p.isStrong()) {
                        return false;
                    }
                    boolean found = ToConfluenceSerializer.this.findByClass(p, TextNode.class, SpecialPanelProcessor.this.isSpecialPanelText);
                    if (found) {
                        StringBuilder _sb = ToConfluenceSerializer.this.bufferVisit(new F<Void, Void>(){

                            @Override
                            public Void f(Void p) {
                                parent.getChildren().remove(0);
                                ToConfluenceSerializer.this.visitChildren(parent);
                                return null;
                            }
                        });
                        SpecialPanelProcessor.this.title = _sb.toString().trim();
                    }
                    return found;
                }
            });
            if (result) {
                ToConfluenceSerializer.this._buffer.append(String.format("{%s:title=%s}", this.element, this.title));
                ToConfluenceSerializer.this.visitChildren(node1);
                ToConfluenceSerializer.this._buffer.append(String.format("{%s}", this.element)).append('\n');
            }
            return result;
        }
    }

    protected static interface FindPredicate<T extends Node> {
        public boolean f(T var1, Node var2, int var3);
    }
}

