/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.confluence;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfluenceHtmlListUtils {
    private static final String LIST_TAGS_PATTERN = "<ol>|<ul>|</ul>|</ol>";
    private static final String LI_TAG_PATTERN = "<li>(.+)</li>";

    protected ConfluenceHtmlListUtils() {
    }

    public static String replaceHtmlList(String line) {
        if (line == null) {
            throw new IllegalArgumentException("parameter source is null");
        }
        StringWriter sw = new StringWriter(line.length());
        PrintWriter out = new PrintWriter(sw);
        Pattern patternLIST = Pattern.compile(LIST_TAGS_PATTERN, 2);
        Matcher matcherLIST = patternLIST.matcher(line);
        Stack<HtmlList> stack = new Stack<HtmlList>();
        int prevEnd = 0;
        while (matcherLIST.find()) {
            String l;
            HtmlList tag;
            boolean isOpen;
            String tagName = matcherLIST.group(0);
            boolean bl = isOpen = !tagName.startsWith("</");
            if (isOpen) {
                tag = new HtmlList();
                tag.name = tagName.toLowerCase();
                tag.start = matcherLIST.start();
                stack.push(tag);
                if (prevEnd >= tag.start) continue;
                out.print(line.substring(prevEnd, tag.start));
                continue;
            }
            tag = (HtmlList)stack.pop();
            prevEnd = tag.end = matcherLIST.end();
            if (tagName.equalsIgnoreCase("</ul>")) {
                l = line.substring(tag.start, tag.end).replaceAll("</?[Uu][Ll]>", "").replaceAll(LI_TAG_PATTERN, "* $1");
                out.print(l);
                continue;
            }
            if (!tagName.equalsIgnoreCase("</ol>")) continue;
            l = line.substring(tag.start, tag.end).replaceAll("</?[Oo][Ll]>", "").replaceAll(LI_TAG_PATTERN, "# $1");
            out.print(l);
        }
        out.print(line.substring(prevEnd));
        out.flush();
        return sw.toString();
    }

    static class HtmlList {
        String name;
        int start;
        int end;

        HtmlList() {
        }
    }
}

