/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.model.Page;
import org.bsc.ssl.SSLCertificateInfo;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;

public class RESTConfluenceServiceImpl
implements ConfluenceService {
    final ConfluenceService.Credentials credentials;
    final OkHttpClient.Builder client = new OkHttpClient.Builder();
    final URL endpoint;

    public RESTConfluenceServiceImpl(String url, ConfluenceService.Credentials credentials, SSLCertificateInfo sslInfo) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        try {
            this.endpoint = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("url argument is not valid!", ex);
        }
        this.credentials = credentials;
        this.client.connectTimeout(10L, TimeUnit.SECONDS);
        this.client.writeTimeout(10L, TimeUnit.SECONDS);
        this.client.readTimeout(30L, TimeUnit.SECONDS);
        if (!sslInfo.isIgnore() && "https".equals(this.endpoint.getProtocol())) {
            this.client.hostnameVerifier(sslInfo.getHostnameVerifier()).sslSocketFactory(sslInfo.getSSLSocketFactory(), sslInfo.getTrustManager());
        }
    }

    private HttpUrl.Builder urlBuilder() {
        int port = this.endpoint.getPort();
        port = port > -1 ? port : this.endpoint.getDefaultPort();
        String path = ConfluenceService.Protocol.XMLRPC.removeFrom(this.endpoint.getPath());
        return new HttpUrl.Builder().scheme(this.endpoint.getProtocol()).host(this.endpoint.getHost()).port(port).addPathSegments(path).addPathSegments(ConfluenceService.Protocol.REST.path());
    }

    private Observable<Response> rxfindPagesResponse(String spaceKey, String title) {
        String credential = Credentials.basic((String)this.credentials.username, (String)this.credentials.password);
        HttpUrl url = this.urlBuilder().addPathSegment("content").addQueryParameter("spaceKey", spaceKey).addQueryParameter("title", title).addQueryParameter("expand", "space,version,container").build();
        final Request req = new Request.Builder().header("Authorization", credential).url(url).get().build();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Response>(){

            public void call(Subscriber<? super Response> t) {
                try {
                    Response res = RESTConfluenceServiceImpl.this.client.build().newCall(req).execute();
                    t.onNext((Object)res);
                    t.onCompleted();
                }
                catch (IOException ex) {
                    t.onError((Throwable)ex);
                }
            }
        });
    }

    public Observable<JsonArray> rxfindPagesArray(String spaceKey, String title) {
        return this.rxfindPagesResponse(spaceKey, title).flatMap((Func1)new Func1<Response, Observable<? extends JsonArray>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Observable<? extends JsonArray> call(Response res) {
                ResponseBody body = res.body();
                try (Reader r = body.charStream();){
                    JsonReader rdr = Json.createReader((Reader)r);
                    JsonObject root = rdr.readObject();
                    JsonArray results = root.getJsonArray("results");
                    if (results == null) {
                        Observable observable2 = Observable.empty();
                        return observable2;
                    }
                    Observable observable = Observable.just((Object)results);
                    return observable;
                }
                catch (IOException ex) {
                    return Observable.error((Throwable)ex);
                }
            }
        });
    }

    public Observable<JsonObject> rxfindPage(String spaceKey, String title) {
        return this.rxfindPagesArray(spaceKey, title).flatMap((Func1)new Func1<JsonArray, Observable<? extends JsonObject>>(){

            public Observable<? extends JsonObject> call(JsonArray t) {
                if (t.size() == 1) {
                    return Observable.just((Object)t.getJsonObject(0));
                }
                if (t.size() == 0) {
                    return Observable.empty();
                }
                return Observable.error((Throwable)new Exception(String.format("results contains more than one element [%d]", t.size())));
            }
        });
    }

    public JsonObjectBuilder jsonForCreatingPage(String spaceKey, String title) {
        return Json.createObjectBuilder().add("type", "page").add("title", title).add("space", Json.createObjectBuilder().add("key", spaceKey));
    }

    public JsonObjectBuilder jsonForCreatingPage(String spaceKey, int parentPageId, String title) {
        return this.jsonForCreatingPage(spaceKey, title).add("ancestors", Json.createArrayBuilder().add(Json.createObjectBuilder().add("id", parentPageId)));
    }

    public JsonObjectBuilder jsonAddBody(JsonObjectBuilder builder, ConfluenceService.Storage storage) {
        return builder.add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", storage.rapresentation.toString()).add("value", storage.value)));
    }

    public Observable<JsonObject> rxCreatePage(JsonObject inputData) {
        String credential = Credentials.basic((String)this.credentials.username, (String)this.credentials.password);
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        final Request req = new Request.Builder().header("Authorization", credential).url(this.urlBuilder().addPathSegment("content").build()).post(inputBody).build();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<JsonObject>(){

            public void call(Subscriber<? super JsonObject> t) {
                try {
                    Response res = RESTConfluenceServiceImpl.this.client.build().newCall(req).execute();
                    if (!res.isSuccessful()) {
                        t.onError((Throwable)new Exception(String.format("error creating page\n%s", res.toString())));
                        return;
                    }
                    ResponseBody body = res.body();
                    try (Reader r = body.charStream();){
                        JsonReader rdr = Json.createReader((Reader)r);
                        JsonObject root = rdr.readObject();
                        t.onNext((Object)root);
                        t.onCompleted();
                    }
                }
                catch (IOException ex) {
                    t.onError((Throwable)ex);
                }
            }
        });
    }

    public Observable<JsonObject> rxUpdatePage(String pageId, JsonObject inputData) {
        String credential = Credentials.basic((String)this.credentials.username, (String)this.credentials.password);
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        final Request req = new Request.Builder().header("Authorization", credential).url(this.urlBuilder().addPathSegment("content").addPathSegment(pageId).build()).put(inputBody).build();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<JsonObject>(){

            public void call(Subscriber<? super JsonObject> t) {
                try {
                    Response res = RESTConfluenceServiceImpl.this.client.build().newCall(req).execute();
                    if (!res.isSuccessful()) {
                        t.onError((Throwable)new Exception(String.format("error updating page\n%s", res.toString())));
                        return;
                    }
                    ResponseBody body = res.body();
                    try (Reader r = body.charStream();){
                        JsonReader rdr = Json.createReader((Reader)r);
                        JsonObject root = rdr.readObject();
                        t.onNext((Object)root);
                        t.onCompleted();
                    }
                }
                catch (IOException ex) {
                    t.onError((Throwable)ex);
                }
            }
        });
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removePage(ConfluenceService.Model.Page parentPage, String title) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removePage(String pageId) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConfluenceService.Model.Page getOrCreatePage(final String spaceKey, String parentPageTitle, final String title) throws Exception {
        Observable error = Observable.error((Throwable)new Exception(String.format("parentPage [%s] doesn't exist!", parentPageTitle)));
        JsonObject page = (JsonObject)this.rxfindPage(spaceKey, parentPageTitle).switchIfEmpty(error).flatMap((Func1)new Func1<JsonObject, Observable<JsonObject>>(){

            public Observable<JsonObject> call(JsonObject parent) {
                String id = parent.getString("id");
                JsonObjectBuilder input = RESTConfluenceServiceImpl.this.jsonForCreatingPage(spaceKey, Integer.valueOf(id), title);
                return RESTConfluenceServiceImpl.this.rxfindPage(spaceKey, title).switchIfEmpty(RESTConfluenceServiceImpl.this.rxCreatePage(input.build()));
            }
        }).toBlocking().first();
        return new Page(page);
    }

    @Override
    public ConfluenceService.Model.Page getOrCreatePage(ConfluenceService.Model.Page parentPage, String title) throws Exception {
        String spaceKey = parentPage.getSpace();
        String id = parentPage.getId();
        JsonObjectBuilder input = this.jsonForCreatingPage(spaceKey, Integer.valueOf(id), title);
        JsonObject result = (JsonObject)this.rxfindPage(spaceKey, title).switchIfEmpty(this.rxCreatePage(input.build())).toBlocking().first();
        return new Page(result);
    }

    @Override
    public ConfluenceService.Model.Page getPage(String pageId) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConfluenceService.Model.Page getPage(String spaceKey, String pageTitle) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addLabelByName(String label, long id) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConfluenceService.Model.Page storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) throws Exception {
        int previousVersion = page.getVersion();
        JsonObject input = Json.createObjectBuilder().add("version", Json.createObjectBuilder().add("number", ++previousVersion)).add("id", page.getId()).add("type", "page").add("title", page.getTitle()).add("space", Json.createObjectBuilder().add("key", page.getSpace())).add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", content.rapresentation.toString()).add("value", content.value))).build();
        JsonObject result = (JsonObject)this.rxUpdatePage(page.getId(), input).toBlocking().first();
        return new Page(result);
    }

    @Override
    public ConfluenceService.Model.Page storePage(ConfluenceService.Model.Page page) throws Exception {
        return page;
    }

    @Override
    public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void call(Action1<ConfluenceService> task) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConfluenceService.Model.Attachment getAttachment(String pageId, String name, String version) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ConfluenceService.Model.Attachment addAttchment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

