/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.bsc.confluence.ExportFormat;
import rx.functions.Action1;

public interface ConfluenceService {
    public Credentials getCredentials();

    public Model.PageSummary findPageByTitle(String var1, String var2) throws Exception;

    public boolean removePage(Model.Page var1, String var2) throws Exception;

    public void removePage(String var1) throws Exception;

    public Model.Page getOrCreatePage(String var1, String var2, String var3) throws Exception;

    public Model.Page getOrCreatePage(Model.Page var1, String var2) throws Exception;

    public Model.Page getPage(String var1) throws Exception;

    public Model.Page getPage(String var1, String var2) throws Exception;

    public boolean addLabelByName(String var1, long var2) throws Exception;

    public Model.Page storePage(Model.Page var1, Storage var2) throws Exception;

    public Model.Page storePage(Model.Page var1) throws Exception;

    public List<Model.PageSummary> getDescendents(String var1) throws Exception;

    public void exportPage(String var1, String var2, String var3, ExportFormat var4, File var5) throws Exception;

    public void call(Action1<ConfluenceService> var1) throws Exception;

    public Model.Attachment createAttachment();

    public Model.Attachment getAttachment(String var1, String var2, String var3) throws Exception;

    public Model.Attachment addAttachment(Model.Page var1, Model.Attachment var2, InputStream var3) throws Exception;

    public static interface Model {

        public static interface Page
        extends PageSummary {
            public int getVersion();
        }

        public static interface PageSummary {
            public String getId();

            public String getTitle();

            public String getSpace();

            public String getParentId();
        }

        public static interface Attachment {
            public void setFileName(String var1);

            public String getFileName();

            public void setContentType(String var1);

            public void setComment(String var1);

            public Date getCreated();
        }
    }

    public static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            if (username == null) {
                throw new IllegalArgumentException("username argument is null!");
            }
            this.username = username;
            this.password = password;
        }
    }

    public static class Storage {
        public final String value;
        public final Representation rapresentation;

        public Storage(String value, Representation rapresentation) {
            this.value = value;
            this.rapresentation = rapresentation;
        }

        public static enum Representation {
            STORAGE,
            WIKI;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static enum Protocol {
        XMLRPC("rpc/xmlrpc"),
        REST("rest/api");

        private final String path;

        private Protocol(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        public String addTo(String endpoint) {
            if (null == endpoint) {
                throw new IllegalArgumentException("endpoint argument is null!");
            }
            if (endpoint.endsWith(this.path)) {
                return endpoint;
            }
            if (!endpoint.endsWith("/")) {
                endpoint = endpoint.concat("/");
            }
            return endpoint.concat(this.path);
        }

        public String removeFrom(String endpoint) {
            if (null == endpoint) {
                throw new IllegalArgumentException("endpoint argument is null!");
            }
            String result = endpoint.replace(this.path, "");
            result = result.startsWith("/") ? result.substring(1) : result;
            return result;
        }

        public boolean match(String endpoint) {
            return Pattern.matches(String.format(".+(%s)[/]?", this.path), endpoint);
        }
    }
}

