/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$1;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$10;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$11;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$12;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$13;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$14;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$4;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$5;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$6;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$7;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$8;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$9;
import org.bsc.confluence.rest.model.Attachment;
import rx.Observable;
import rx.Subscriber;

public abstract class AbstractRESTConfluenceService {
    private static final String EXPAND = "space,version,container";
    final OkHttpClient.Builder client = new OkHttpClient.Builder();

    public abstract ConfluenceService.Credentials getCredentials();

    protected abstract HttpUrl.Builder urlBuilder();

    protected Observable<Response> fromRequest(Request req, String description) {
        return Observable.create((Observable.OnSubscribe)AbstractRESTConfluenceService$$Lambda$1.lambdaFactory$(this, req, description));
    }

    protected Observable<Response> fromUrlGET(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).get().build();
        return this.fromRequest(req, description);
    }

    protected Observable<Response> fromUrlDELETE(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).delete().build();
        return this.fromRequest(req, description);
    }

    protected Observable<Response> fromUrlPOST(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).post(inputBody).build();
        return this.fromRequest(req, description);
    }

    protected Observable<Response> fromUrlPUT(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).put(inputBody).build();
        return this.fromRequest(req, description);
    }

    protected void debugBody(Response res) {
        ResponseBody body = res.body();
        try {
            System.out.printf("BODY\n%s\n", new String(body.bytes()));
        }
        catch (IOException e) {
            System.out.printf("READ BODY EXCEPTION\n%s\n", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Observable<JsonObject> mapToArray(Response res) {
        ResponseBody body = res.body();
        try (Reader r = body.charStream();){
            JsonReader rdr = Json.createReader((Reader)r);
            JsonObject root = rdr.readObject();
            if (!root.containsKey((Object)"results")) {
                Observable observable = Observable.error((Throwable)new Exception(root.toString()));
                return observable;
            }
            JsonArray results = root.getJsonArray("results");
            if (results == null || results.isEmpty()) {
                Observable observable = Observable.empty();
                return observable;
            }
            Object[] array = new JsonObject[results.size()];
            for (int ii = 0; ii < results.size(); ++ii) {
                array[ii] = results.getJsonObject(ii);
            }
            Observable observable = Observable.from((Object[])array);
            return observable;
        }
        catch (IOException | JsonParsingException e) {
            return Observable.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject mapToObject(Response res) {
        ResponseBody body = res.body();
        try (Reader r = body.charStream();){
            JsonObject root;
            JsonReader rdr = Json.createReader((Reader)r);
            JsonObject jsonObject = root = rdr.readObject();
            return jsonObject;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected Observable<JsonObject> rxfindPageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find page").map(AbstractRESTConfluenceService$$Lambda$4.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxfindPages(String spaceKey, String title) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addQueryParameter("spaceKey", spaceKey).addQueryParameter("title", title).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find pages").flatMap(AbstractRESTConfluenceService$$Lambda$5.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxDescendantPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get descendant pages").flatMap(AbstractRESTConfluenceService$$Lambda$6.lambdaFactory$(this)).concatMap(AbstractRESTConfluenceService$$Lambda$7.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxChildrenPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get children pages").flatMap(AbstractRESTConfluenceService$$Lambda$8.lambdaFactory$(this));
    }

    public Observable<JsonObject> rxfindPage(String spaceKey, String title) {
        return this.rxfindPages(spaceKey, title).take(1);
    }

    protected Observable<Response> rxDeletePageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).build();
        return this.fromUrlDELETE(url, "delete page");
    }

    public final Observable<JsonObject> rxCreatePage(JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").build();
        return this.fromUrlPOST(url, inputBody, "create page").map(AbstractRESTConfluenceService$$Lambda$9.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxUpdatePage(String pageId, JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(pageId).build();
        return this.fromUrlPUT(url, inputBody, "update page").map(AbstractRESTConfluenceService$$Lambda$10.lambdaFactory$(this));
    }

    protected final Observable<Response> rxAddLabels(String id, String ... labels) {
        JsonArrayBuilder inputBuilder = Json.createArrayBuilder();
        for (String name : labels) {
            inputBuilder.add(Json.createObjectBuilder().add("prefix", "global").add("name", name));
        }
        JsonArray inputData = inputBuilder.build();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegment("label").build();
        return this.fromUrlPOST(url, inputBody, "add label");
    }

    protected Observable<JsonObject> rxAttachments(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachments").flatMap(AbstractRESTConfluenceService$$Lambda$11.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxAttachment(String id, String fileName) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("filename", fileName).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachment").flatMap(AbstractRESTConfluenceService$$Lambda$12.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxAddAttachment(String id, Attachment att, InputStream data) {
        RequestBody fileBody;
        try {
            fileBody = RequestBody.create((MediaType)MediaType.parse((String)att.getContentType()), (byte[])IOUtils.toByteArray((InputStream)data));
        }
        catch (IOException ex) {
            return Observable.error((Throwable)ex);
        }
        MultipartBody inputBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("comment", att.getComment()).addFormDataPart("minorEdit", "true").addFormDataPart("file", att.getFileName(), fileBody).build();
        HttpUrl.Builder builder = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment");
        if (att.getId() != null) {
            builder.addPathSegment(att.getId()).addPathSegment("data");
        }
        Observable<Response> post = this.fromUrlPOST(builder.build(), (RequestBody)inputBody, "create attachment");
        return att.getId() != null ? post.map(AbstractRESTConfluenceService$$Lambda$13.lambdaFactory$(this)) : post.flatMap(AbstractRESTConfluenceService$$Lambda$14.lambdaFactory$(this));
    }

    static /* synthetic */ Observable lambda$rxDescendantPages$1(AbstractRESTConfluenceService this_, JsonObject o) {
        String childId = o.getString("id");
        return Observable.concat((Observable)Observable.just((Object)o), this_.rxDescendantPages(childId));
    }

    static /* synthetic */ void lambda$fromRequest$0(AbstractRESTConfluenceService this_, Request req, String description, Subscriber t) {
        try {
            Response res = this_.client.build().newCall(req).execute();
            if (!res.isSuccessful()) {
                t.onError((Throwable)new ServiceException(String.format("error: %s\n%s", description, res.toString()), res));
                return;
            }
            t.onNext((Object)res);
            t.onCompleted();
        }
        catch (IOException ex) {
            t.onError((Throwable)ex);
        }
    }

    public static class ServiceException
    extends Exception {
        public final Response res;

        public ServiceException(String message, Response res) {
            super(message);
            this.res = res;
        }
    }
}

