/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.confluence;

import java.awt.Label;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.naming.directory.SearchResult;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.BlogEntry;
import org.codehaus.swizzle.confluence.BlogEntrySummary;
import org.codehaus.swizzle.confluence.Comment;
import org.codehaus.swizzle.confluence.ConfluenceException;
import org.codehaus.swizzle.confluence.MapObject;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageHistorySummary;
import org.codehaus.swizzle.confluence.PageSummary;
import org.codehaus.swizzle.confluence.ServerInfo;
import org.codehaus.swizzle.confluence.Space;
import org.codehaus.swizzle.confluence.SpaceSummary;
import org.codehaus.swizzle.confluence.SwizzleException;
import org.codehaus.swizzle.confluence.User;
import org.codehaus.swizzle.confluence.UserInformation;

class Confluence {
    protected static final String SERVICE_PREFIX_1 = "confluence1.";
    private final XmlRpcClient client;
    private String token;
    protected boolean sendRawData;
    private SoftReference<ServerInfo> serverInfoCache = null;

    private boolean isNullOrEmpty(String v) {
        if (v == null) {
            return true;
        }
        return v.trim().length() == 0;
    }

    private boolean isProxyEnabled(ConfluenceProxy proxyInfo, URI serviceURI) {
        if (proxyInfo == null || this.isNullOrEmpty(proxyInfo.host)) {
            return false;
        }
        boolean result = true;
        if (!this.isNullOrEmpty(proxyInfo.nonProxyHosts)) {
            String proxyHost = System.setProperty("http.proxyHost", proxyInfo.host);
            String proxyPort = System.setProperty("http.proxyPort", String.valueOf(proxyInfo.port));
            String nonProxyHosts = System.setProperty("http.nonProxyHosts", proxyInfo.nonProxyHosts);
            List<Proxy> proxyList = ProxySelector.getDefault().select(serviceURI);
            if (proxyList != null && proxyList.size() == 1) {
                Proxy proxy = proxyList.get(0);
                boolean bl = result = proxy.type() != Proxy.Type.DIRECT && proxy.address() != null;
            }
            if (proxyHost != null) {
                System.setProperty("http.proxyHost", proxyHost);
            }
            if (proxyPort != null) {
                System.setProperty("http.proxyPort", proxyPort);
            }
            if (nonProxyHosts != null) {
                System.setProperty("http.nonProxyHosts", nonProxyHosts);
            }
        }
        return result;
    }

    protected Confluence(String endpoint, ConfluenceProxy proxyInfo) throws URISyntaxException, MalformedURLException {
        this(new XmlRpcClient());
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        endpoint = ConfluenceService.Protocol.XMLRPC.addTo(endpoint);
        URI serviceURI = new URI(endpoint);
        XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();
        clientConfig.setServerURL(serviceURI.toURL());
        clientConfig.setEnabledForExtensions(true);
        this.client.setConfig((XmlRpcClientConfig)clientConfig);
        if (this.isProxyEnabled(proxyInfo, serviceURI)) {
            XmlRpcCommonsTransportFactory transportFactory = new XmlRpcCommonsTransportFactory(this.client);
            HttpClient httpClient = new HttpClient();
            HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
            hostConfiguration.setProxy(proxyInfo.host, proxyInfo.port);
            hostConfiguration.setHost(serviceURI.getHost(), serviceURI.getPort(), serviceURI.toURL().getProtocol());
            if (!this.isNullOrEmpty(proxyInfo.userName) && !this.isNullOrEmpty(proxyInfo.password)) {
                UsernamePasswordCredentials cred = new UsernamePasswordCredentials(proxyInfo.userName, proxyInfo.password);
                httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)cred);
            }
            transportFactory.setHttpClient(httpClient);
            this.client.setTransportFactory((XmlRpcTransportFactory)transportFactory);
        }
    }

    protected Confluence(XmlRpcClient client) {
        this.client = client;
        this.token = "";
    }

    protected Confluence(Confluence c) {
        this.client = c.client;
        this.token = c.token;
    }

    protected String getServicePrefix() {
        return SERVICE_PREFIX_1;
    }

    public boolean willSendRawData() {
        return this.sendRawData;
    }

    public void sendRawData(boolean sendRawData) {
        this.sendRawData = sendRawData;
    }

    public void login(String username, String password) throws SwizzleException, ConfluenceException {
        this.token = (String)this.call("login", (Object)username, password);
    }

    public boolean logout() throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("logout");
        return value;
    }

    public String exportSite(boolean exportAttachments) throws SwizzleException, ConfluenceException {
        return (String)this.call("exportSite", new Boolean(exportAttachments));
    }

    public ServerInfo getServerInfo() throws SwizzleException, ConfluenceException {
        if (this.serverInfoCache == null || this.serverInfoCache.get() == null) {
            Map data = (Map)this.call("getServerInfo");
            this.serverInfoCache = new SoftReference<ServerInfo>(new ServerInfo(data));
        }
        return this.serverInfoCache.get();
    }

    public List getSpaces() throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getSpaces");
        return this.toList(vector, SpaceSummary.class);
    }

    public Space getSpace(String spaceKey) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getSpace", spaceKey);
        return new Space(data);
    }

    public String exportSpace(String spaceKey, String exportType) throws SwizzleException, ConfluenceException {
        return (String)this.call("exportSpace", (Object)spaceKey, exportType);
    }

    public Space addSpace(Space space) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("addSpace", space);
        return new Space(data);
    }

    public Boolean removeSpace(String spaceKey) throws SwizzleException, ConfluenceException {
        return (Boolean)this.call("removeSpace", spaceKey);
    }

    public List getPages(String spaceKey) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getPages", spaceKey);
        return this.toList(vector, PageSummary.class);
    }

    public Page getPage(PageSummary summary) throws SwizzleException, ConfluenceException {
        return this.getPage(summary.getId());
    }

    public Page getPage(String pageId) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getPage", pageId);
        return new Page(data);
    }

    public Page getPage(String spaceKey, String pageTitle) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getPage", (Object)spaceKey, pageTitle);
        return new Page(data);
    }

    public List getPageHistory(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getPageHistory", pageId);
        return this.toList(vector, PageHistorySummary.class);
    }

    public List getAttachments(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getAttachments", pageId);
        return this.toList(vector, Attachment.class);
    }

    public List getAncestors(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getAncestors", pageId);
        return this.toList(vector, PageSummary.class);
    }

    public List getChildren(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getChildren", pageId);
        return this.toList(vector, PageSummary.class);
    }

    public List getDescendents(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getDescendents", pageId);
        return this.toList(vector, PageSummary.class);
    }

    public List getComments(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getComments", pageId);
        return this.toList(vector, Comment.class);
    }

    public Comment getComment(String commentId) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getComment", commentId);
        return new Comment(data);
    }

    public Comment addComment(Comment comment) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("addComment", comment);
        return new Comment(data);
    }

    public boolean removeComment(String commentId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeComment", commentId);
        return value;
    }

    public Page storePage(Page page) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call(SERVICE_PREFIX_1, "storePage", new Object[]{page});
        return new Page(data);
    }

    public String renderContent(String spaceKey, String pageId, String content) throws SwizzleException, ConfluenceException {
        return (String)this.call("renderContent", spaceKey, pageId, content);
    }

    public String renderContent(String spaceKey, String pageId) throws SwizzleException, ConfluenceException {
        return this.renderContent(spaceKey, pageId, "");
    }

    public String renderContent(PageSummary page) throws SwizzleException, ConfluenceException {
        return this.renderContent(page.getSpace(), page.getId());
    }

    public String renderContent(String spaceKey, String pageId, String content, Map parameters) throws SwizzleException, ConfluenceException {
        return (String)this.call("renderContent", spaceKey, pageId, content, parameters);
    }

    public void removePage(String pageId) throws SwizzleException, ConfluenceException {
        this.call("removePage", pageId);
    }

    public Attachment getAttachment(String pageId, String fileName, String versionNumber) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getAttachment", pageId, fileName, versionNumber);
        return new Attachment(data);
    }

    public byte[] getAttachmentData(String pageId, String fileName, String versionNumber) throws SwizzleException, ConfluenceException {
        return (byte[])this.call("getAttachmentData", pageId, fileName, versionNumber);
    }

    public Attachment addAttachment(long contentId, Attachment attachment, byte[] attachmentData) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("addAttachment", new Long(contentId), attachment, attachmentData);
        return new Attachment(data);
    }

    public boolean removeAttachment(String contentId, String fileName) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeAttachment", (Object)contentId, fileName);
        return value;
    }

    public boolean moveAttachment(String originalContentId, String originalName, String newContentEntityId, String newName) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("moveAttachment", originalContentId, originalName, newContentEntityId, newName);
        return value;
    }

    public List getBlogEntries(String spaceKey) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getBlogEntries", spaceKey);
        return this.toList(vector, BlogEntrySummary.class);
    }

    public BlogEntry getBlogEntry(String pageId) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getBlogEntry", pageId);
        return new BlogEntry(data);
    }

    public BlogEntry storeBlogEntry(BlogEntry entry) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("storeBlogEntry", entry);
        return new BlogEntry(data);
    }

    public BlogEntry getBlogEntryByDayAndTitle(String spaceKey, int dayOfMonth, String postTitle) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getBlogEntryByDayAndTitle", spaceKey, new Integer(dayOfMonth), postTitle);
        return new BlogEntry(data);
    }

    public List search(String query, int maxResults) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("search", (Object)query, new Integer(maxResults));
        return this.toList(vector, SearchResult.class);
    }

    public List search(String query, Map parameters, int maxResults) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("search", query, parameters, new Integer(maxResults));
        return this.toList(vector, SearchResult.class);
    }

    public List getPermissions(String spaceKey) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getPermissions", spaceKey);
        return Arrays.asList(vector);
    }

    public List getPermissionsForUser(String spaceKey, String userName) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getPermissionsForUser", (Object)spaceKey, userName);
        return this.toList(vector, Permission.class);
    }

    public List getPagePermissions(String pageId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getPagePermissions", pageId);
        return this.toList(vector, Permission.class);
    }

    public List getSpaceLevelPermissions() throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getSpaceLevelPermissions");
        return this.toList(vector, Permission.class);
    }

    public boolean addPermissionToSpace(String permission, String remoteEntityName, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addPermissionToSpace", permission, remoteEntityName, spaceKey);
        return value;
    }

    public boolean addPermissionsToSpace(List permissions, String remoteEntityName, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addPermissionsToSpace", permissions.toArray(), remoteEntityName, spaceKey);
        return value;
    }

    public boolean removePermissionFromSpace(String permission, String remoteEntityName, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removePermissionFromSpace", permission, remoteEntityName, spaceKey);
        return value;
    }

    public boolean addAnonymousPermissionToSpace(String permission, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addAnonymousPermissionToSpace", (Object)permission, spaceKey);
        return value;
    }

    public boolean addAnonymousPermissionsToSpace(List permissions, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addAnonymousPermissionsToSpace", permissions.toArray(), spaceKey);
        return value;
    }

    public boolean removeAnonymousPermissionFromSpace(String permission, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeAnonymousPermissionFromSpace", (Object)permission, spaceKey);
        return value;
    }

    public boolean removeAllPermissionsForGroup(String groupname) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeAllPermissionsForGroup", groupname);
        return value;
    }

    public User getUser(String username) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getUser", username);
        return new User(data);
    }

    public void addUser(User user, String password) throws SwizzleException, ConfluenceException {
        this.call("addUser", user, password);
    }

    public void addGroup(String group) throws SwizzleException, ConfluenceException {
        this.call("addGroup", group);
    }

    public List getUserGroups(String username) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getUserGroups", username);
        return Arrays.asList(vector);
    }

    public void addUserToGroup(String username, String groupname) throws SwizzleException, ConfluenceException {
        this.call("addUserToGroup", (Object)username, groupname);
    }

    public boolean removeUserFromGroup(String username, String groupname) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeUserFromGroup", (Object)username, groupname);
        return value;
    }

    public boolean removeUser(String username) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeUser", username);
        return value;
    }

    public boolean removeGroup(String groupname, String defaultGroupName) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeGroup", (Object)groupname, defaultGroupName);
        return value;
    }

    public List getGroups() throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getGroups");
        return Arrays.asList(vector);
    }

    public boolean hasUser(String username) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("hasUser", username);
        return value;
    }

    public boolean hasGroup(String groupname) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("hasGroup", groupname);
        return value;
    }

    public boolean editUser(User remoteUser) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("editUser", remoteUser);
        return value;
    }

    public boolean deactivateUser(String username) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("deactivateUser", username);
        return value;
    }

    public boolean reactivateUser(String username) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("reactivateUser", username);
        return value;
    }

    public List getActiveUsers(boolean viewAll) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getActiveUsers", new Boolean(viewAll));
        return Arrays.asList(vector);
    }

    public boolean setUserInformation(UserInformation userInfo) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("setUserInformation", userInfo);
        return value;
    }

    public UserInformation getUserInformation(String username) throws SwizzleException, ConfluenceException {
        Map data = (Map)this.call("getUserInformation", username);
        return new UserInformation(data);
    }

    public boolean changeMyPassword(String oldPass, String newPass) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("changeMyPassword", (Object)oldPass, newPass);
        return value;
    }

    public boolean changeUserPassword(String username, String newPass) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("changeUserPassword", (Object)username, newPass);
        return value;
    }

    public List getLabelsById(long objectId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getLabelsById", new Long(objectId));
        return this.toList(vector, Label.class);
    }

    public List getMostPopularLabels(int maxCount) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getMostPopularLabels", new Integer(maxCount));
        return this.toList(vector, Label.class);
    }

    public List getMostPopularLabelsInSpace(String spaceKey, int maxCount) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getMostPopularLabelsInSpace", (Object)spaceKey, new Integer(maxCount));
        return this.toList(vector, Label.class);
    }

    public List getRecentlyUsedLabels(int maxResults) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getRecentlyUsedLabels", new Integer(maxResults));
        return this.toList(vector, Label.class);
    }

    public List getRecentlyUsedLabelsInSpace(String spaceKey, int maxResults) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getRecentlyUsedLabelsInSpace", (Object)spaceKey, new Integer(maxResults));
        return this.toList(vector, Label.class);
    }

    public List getSpacesWithLabel(String labelName) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getSpacesWithLabel", labelName);
        return this.toList(vector, Space.class);
    }

    public List getRelatedLabels(String labelName, int maxResults) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getRelatedLabels", (Object)labelName, new Integer(maxResults));
        return this.toList(vector, Label.class);
    }

    public List getRelatedLabelsInSpace(String labelName, String spaceKey, int maxResults) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getRelatedLabelsInSpace", labelName, spaceKey, new Integer(maxResults));
        return this.toList(vector, Label.class);
    }

    public List getLabelsByDetail(String labelName, String namespace, String spaceKey, String owner) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getLabelsByDetail", labelName, namespace, spaceKey, owner);
        return this.toList(vector, Label.class);
    }

    public List getLabelContentById(long labelId) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getLabelContentById", new Long(labelId));
        return Arrays.asList(vector);
    }

    public List getLabelContentByName(String labelName) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getLabelContentByName", labelName);
        return Arrays.asList(vector);
    }

    public List getLabelContentByObject(Label labelObject) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getLabelContentByObject", labelObject);
        return this.toList(vector, Label.class);
    }

    public List getSpacesContainingContentWithLabel(String labelName) throws SwizzleException, ConfluenceException {
        Object[] vector = (Object[])this.call("getSpacesContainingContentWithLabel", labelName);
        return this.toList(vector, Space.class);
    }

    public boolean addLabelByName(String labelName, long objectId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addLabelByName", (Object)labelName, new Long(objectId));
        return value;
    }

    public boolean addLabelById(long labelId, long objectId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addLabelById", new Long(labelId), new Long(objectId));
        return value;
    }

    public boolean addLabelByObject(Label labelObject, long objectId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addLabelByObject", labelObject, new Long(objectId));
        return value;
    }

    public boolean addLabelByNameToSpace(String labelName, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("addLabelByNameToSpace", (Object)labelName, spaceKey);
        return value;
    }

    public boolean removeLabelByName(String labelName, long objectId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeLabelByName", (Object)labelName, new Long(objectId));
        return value;
    }

    public boolean removeLabelById(long labelId, long objectId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeLabelById", new Long(labelId), new Long(objectId));
        return value;
    }

    public boolean removeLabelByObject(Label labelObject, long objectId) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeLabelByObject", labelObject, new Long(objectId));
        return value;
    }

    public boolean removeLabelByNameFromSpace(String labelName, String spaceKey) throws SwizzleException, ConfluenceException {
        Boolean value = (Boolean)this.call("removeLabelByNameFromSpace", (Object)labelName, spaceKey);
        return value;
    }

    private List toList(Object[] vector, Class type) throws SwizzleException {
        try {
            ArrayList list = new ArrayList(vector.length);
            Constructor constructor = type.getConstructor(Map.class);
            for (int i = 0; i < vector.length; ++i) {
                Map data = (Map)vector[i];
                Object object = constructor.newInstance(data);
                list.add(object);
            }
            return list;
        }
        catch (Exception e) {
            throw new SwizzleException(e);
        }
    }

    private Object call(String command) throws SwizzleException, ConfluenceException {
        Object[] args = new Object[]{};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1) throws SwizzleException, ConfluenceException {
        Object[] args = new Object[]{arg1};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1, Object arg2) throws SwizzleException, ConfluenceException {
        Object[] args = new Object[]{arg1, arg2};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1, Object arg2, Object arg3) throws SwizzleException, ConfluenceException {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1, Object arg2, Object arg3, Object arg4) throws SwizzleException, ConfluenceException {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.call(command, args);
    }

    private Object call(String command, Object[] args) throws SwizzleException {
        return this.call(this.getServicePrefix(), command, args);
    }

    private Object call(String servicePrefix, String command, Object[] args) throws SwizzleException {
        Object[] vector;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof MapObject)) continue;
            MapObject map = (MapObject)arg;
            if (this.sendRawData) {
                throw new UnsupportedOperationException("send raw data is unsupported!");
            }
            args[i] = map.toMap();
        }
        if (!command.equals("login")) {
            vector = new Object[args.length + 1];
            vector[0] = this.token;
            System.arraycopy(args, 0, vector, 1, args.length);
        } else {
            vector = args;
        }
        try {
            return this.client.execute(servicePrefix + command, vector);
        }
        catch (XmlRpcClientException e) {
            throw new SwizzleException(e.getMessage(), e.linkedException);
        }
        catch (XmlRpcException e) {
            throw new ConfluenceException(e.getMessage(), e.linkedException);
        }
    }
}

