/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$1;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$10;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$11;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$12;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$13;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$14;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$4;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$5;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$6;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$7;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$8;
import org.bsc.confluence.rest.AbstractRESTConfluenceService$$Lambda$9;
import org.bsc.confluence.rest.model.Attachment;
import rx.Observable;
import rx.Subscriber;

public abstract class AbstractRESTConfluenceService {
    private static final String EXPAND = "space,version,container";
    final OkHttpClient.Builder client = new OkHttpClient.Builder();

    public abstract ConfluenceService.Credentials getCredentials();

    protected abstract HttpUrl.Builder urlBuilder();

    protected Observable<Response> fromRequest(Request req, String description) {
        return Observable.create((Observable.OnSubscribe)AbstractRESTConfluenceService$$Lambda$1.lambdaFactory$(this, req, description));
    }

    protected Observable<Response> fromUrlGET(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).get().build();
        return this.fromRequest(req, description);
    }

    protected Observable<Response> fromUrlDELETE(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).delete().build();
        return this.fromRequest(req, description);
    }

    protected Observable<Response> fromUrlPOST(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).post(inputBody).build();
        return this.fromRequest(req, description);
    }

    protected Observable<Response> fromUrlPUT(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).put(inputBody).build();
        return this.fromRequest(req, description);
    }

    protected void debugBody(Response res) {
        ResponseBody body = res.body();
        try {
            System.out.printf("BODY\n%s\n", new String(body.bytes()));
        }
        catch (IOException e) {
            System.out.printf("READ BODY EXCEPTION\n%s\n", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Observable<JsonObject> mapToArray(Response res) {
        ResponseBody body = res.body();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Observable observable;
                Reader r = body.charStream();
                try {
                    JsonReader rdr = Json.createReader((Reader)r);
                    JsonObject root = rdr.readObject();
                    if (!root.containsKey((Object)"results")) {
                        observable = Observable.error((Throwable)new Exception(root.toString()));
                        return observable;
                    }
                    JsonArray results = root.getJsonArray("results");
                    if (results == null) return Observable.empty();
                    if (results.isEmpty()) {
                        return Observable.empty();
                    }
                    Object[] array = new JsonObject[results.size()];
                    int ii = 0;
                    while (ii < results.size()) {
                        array[ii] = results.getJsonObject(ii);
                        ++ii;
                    }
                    return Observable.from((Object[])array);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (r == null) return observable;
                    r.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException | JsonParsingException e) {
            return Observable.error((Throwable)e);
        }
    }

    protected JsonObject mapToObject(Response res) {
        ResponseBody body = res.body();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader r = body.charStream();){
                JsonReader rdr = Json.createReader((Reader)r);
                JsonObject root = rdr.readObject();
                return root;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected Observable<JsonObject> rxfindPageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find page").map(AbstractRESTConfluenceService$$Lambda$4.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxfindPages(String spaceKey, String title) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addQueryParameter("spaceKey", spaceKey).addQueryParameter("title", title).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find pages").flatMap(AbstractRESTConfluenceService$$Lambda$5.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxDescendantPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get descendant pages").flatMap(AbstractRESTConfluenceService$$Lambda$6.lambdaFactory$(this)).concatMap(AbstractRESTConfluenceService$$Lambda$7.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxChildrenPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get children pages").flatMap(AbstractRESTConfluenceService$$Lambda$8.lambdaFactory$(this));
    }

    public Observable<JsonObject> rxfindPage(String spaceKey, String title) {
        return this.rxfindPages(spaceKey, title).take(1);
    }

    protected Observable<Response> rxDeletePageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).build();
        return this.fromUrlDELETE(url, "delete page");
    }

    public final Observable<JsonObject> rxCreatePage(JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").build();
        return this.fromUrlPOST(url, inputBody, "create page").map(AbstractRESTConfluenceService$$Lambda$9.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxUpdatePage(String pageId, JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(pageId).build();
        return this.fromUrlPUT(url, inputBody, "update page").map(AbstractRESTConfluenceService$$Lambda$10.lambdaFactory$(this));
    }

    protected final Observable<Response> rxAddLabels(String id, String ... labels) {
        JsonArrayBuilder inputBuilder = Json.createArrayBuilder();
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            inputBuilder.add(Json.createObjectBuilder().add("prefix", "global").add("name", name));
            ++n2;
        }
        JsonArray inputData = inputBuilder.build();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegment("label").build();
        return this.fromUrlPOST(url, inputBody, "add label");
    }

    protected Observable<JsonObject> rxAttachments(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachments").flatMap(AbstractRESTConfluenceService$$Lambda$11.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxAttachment(String id, String fileName) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("filename", fileName).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachment").flatMap(AbstractRESTConfluenceService$$Lambda$12.lambdaFactory$(this));
    }

    protected Observable<JsonObject> rxAddAttachment(String id, Attachment att, InputStream data) {
        RequestBody fileBody;
        try {
            fileBody = RequestBody.create((MediaType)MediaType.parse((String)att.getContentType()), (byte[])IOUtils.toByteArray((InputStream)data));
        }
        catch (IOException ex) {
            return Observable.error((Throwable)ex);
        }
        MultipartBody inputBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("comment", att.getComment()).addFormDataPart("minorEdit", "true").addFormDataPart("file", att.getFileName(), fileBody).build();
        HttpUrl.Builder builder = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment");
        if (att.getId() != null) {
            builder.addPathSegment(att.getId()).addPathSegment("data");
        }
        Observable<Response> post = this.fromUrlPOST(builder.build(), (RequestBody)inputBody, "create attachment");
        return att.getId() != null ? post.map(AbstractRESTConfluenceService$$Lambda$13.lambdaFactory$(this)) : post.flatMap(AbstractRESTConfluenceService$$Lambda$14.lambdaFactory$(this));
    }

    static /* synthetic */ void lambda$0(AbstractRESTConfluenceService this_, Request request, String string, Subscriber t) {
        try {
            Response res = this_.client.build().newCall(request).execute();
            if (!res.isSuccessful()) {
                t.onError((Throwable)new ServiceException(String.format("error: %s\n%s", string, res.toString()), res));
                return;
            }
            t.onNext((Object)res);
            t.onCompleted();
        }
        catch (IOException ex) {
            t.onError((Throwable)ex);
        }
    }

    static /* synthetic */ Observable lambda$4(AbstractRESTConfluenceService this_, JsonObject o) {
        String childId = o.getString("id");
        return Observable.concat((Observable)Observable.just((Object)o), this_.rxDescendantPages(childId));
    }

    public static class ServiceException
    extends Exception {
        public final Response res;

        public ServiceException(String message, Response res) {
            super(message);
            this.res = res;
        }
    }
}

