/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import okhttp3.HttpUrl;
import okhttp3.Response;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.AbstractRESTConfluenceService;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$1;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$10;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$11;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$12;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$13;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$14;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$15;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$16;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$2;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$3;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$4;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$5;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$6;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$7;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$8;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl$$Lambda$9;
import org.bsc.confluence.rest.model.Attachment;
import org.bsc.confluence.rest.model.Page;
import org.bsc.ssl.SSLCertificateInfo;
import org.codehaus.swizzle.confluence.ConfluenceExportDecorator;
import rx.Observable;
import rx.functions.Action1;

public class RESTConfluenceServiceImpl
extends AbstractRESTConfluenceService
implements ConfluenceService {
    final ConfluenceService.Credentials credentials;
    final URL endpoint;

    public RESTConfluenceServiceImpl(String url, ConfluenceService.Credentials credentials, SSLCertificateInfo sslInfo) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        try {
            this.endpoint = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("url argument is not valid!", ex);
        }
        this.credentials = credentials;
        this.client.connectTimeout(10L, TimeUnit.SECONDS);
        this.client.writeTimeout(10L, TimeUnit.SECONDS);
        this.client.readTimeout(30L, TimeUnit.SECONDS);
        if (!sslInfo.isIgnore() && "https".equals(this.endpoint.getProtocol())) {
            this.client.hostnameVerifier(sslInfo.getHostnameVerifier()).sslSocketFactory(sslInfo.getSSLSocketFactory(), sslInfo.getTrustManager());
        }
    }

    private Attachment cast(ConfluenceService.Model.Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment argument is null!");
        }
        if (!(attachment instanceof Attachment)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Attachment)attachment;
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, String title) {
        return Json.createObjectBuilder().add("type", "page").add("title", title).add("space", Json.createObjectBuilder().add("key", spaceKey));
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, int parentPageId, String title) {
        return this.jsonForCreatingPage(spaceKey, title).add("ancestors", Json.createArrayBuilder().add(Json.createObjectBuilder().add("id", parentPageId)));
    }

    public final JsonObjectBuilder jsonAddBody(JsonObjectBuilder builder, ConfluenceService.Storage storage) {
        return builder.add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", storage.rapresentation.toString()).add("value", storage.value)));
    }

    @Override
    protected HttpUrl.Builder urlBuilder() {
        int port = this.endpoint.getPort();
        port = port > -1 ? port : this.endpoint.getDefaultPort();
        String path = this.endpoint.getPath();
        path = path.startsWith("/") ? path.substring(1) : path;
        return new HttpUrl.Builder().scheme(this.endpoint.getProtocol()).host(this.endpoint.getHost()).port(port).addPathSegments(path);
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
        return (ConfluenceService.Model.PageSummary)this.rxChildrenPages(parentPageId).map(RESTConfluenceServiceImpl$$Lambda$1.lambdaFactory$()).filter(RESTConfluenceServiceImpl$$Lambda$2.lambdaFactory$(title)).toBlocking().firstOrDefault(null);
    }

    @Override
    public ConfluenceService.Model.Page getOrCreatePage(String spaceKey, String parentPageTitle, String title) throws Exception {
        Observable error = Observable.error((Throwable)new Exception(String.format("parentPage [%s] doesn't exist!", parentPageTitle)));
        return (ConfluenceService.Model.Page)this.rxfindPage(spaceKey, parentPageTitle).switchIfEmpty(error).map(RESTConfluenceServiceImpl$$Lambda$3.lambdaFactory$()).flatMap(RESTConfluenceServiceImpl$$Lambda$4.lambdaFactory$(this, spaceKey, title)).map(RESTConfluenceServiceImpl$$Lambda$5.lambdaFactory$()).toBlocking().first();
    }

    @Override
    public ConfluenceService.Model.Page getOrCreatePage(ConfluenceService.Model.Page parentPage, String title) throws Exception {
        String spaceKey = parentPage.getSpace();
        String id = parentPage.getId();
        JsonObjectBuilder input = this.jsonForCreatingPage(spaceKey, Integer.valueOf(id), title);
        return (ConfluenceService.Model.Page)this.rxfindPage(spaceKey, title).switchIfEmpty(this.rxCreatePage(input.build())).map(RESTConfluenceServiceImpl$$Lambda$6.lambdaFactory$()).toBlocking().first();
    }

    @Override
    public ConfluenceService.Model.Page getPage(String pageId) throws Exception {
        return (ConfluenceService.Model.Page)this.rxfindPageById(pageId).map(RESTConfluenceServiceImpl$$Lambda$7.lambdaFactory$()).toBlocking().first();
    }

    @Override
    public ConfluenceService.Model.Page getPage(String spaceKey, String pageTitle) throws Exception {
        return (ConfluenceService.Model.Page)this.rxfindPage(spaceKey, pageTitle).map(RESTConfluenceServiceImpl$$Lambda$8.lambdaFactory$()).toBlocking().first();
    }

    @Override
    public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
        return (List)this.rxDescendantPages(pageId).map(RESTConfluenceServiceImpl$$Lambda$9.lambdaFactory$()).cast(ConfluenceService.Model.PageSummary.class).toList().toBlocking().first();
    }

    @Override
    public ConfluenceService.Model.Page storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) throws Exception {
        int previousVersion = page.getVersion();
        JsonObject input = Json.createObjectBuilder().add("version", Json.createObjectBuilder().add("number", ++previousVersion)).add("id", page.getId()).add("type", "page").add("title", page.getTitle()).add("space", Json.createObjectBuilder().add("key", page.getSpace())).add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", content.rapresentation.toString()).add("value", content.value))).build();
        return (ConfluenceService.Model.Page)this.rxUpdatePage(page.getId(), input).map(RESTConfluenceServiceImpl$$Lambda$10.lambdaFactory$()).toBlocking().first();
    }

    @Override
    public ConfluenceService.Model.Page storePage(ConfluenceService.Model.Page page) throws Exception {
        return page;
    }

    @Override
    public boolean addLabelByName(String label, long id) throws Exception {
        this.rxAddLabels(String.valueOf(id), label).toBlocking().first();
        return true;
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(this, url);
        exporter.exportPage(spaceKey, pageTitle, exfmt, outputFile);
    }

    @Override
    public void call(Action1<ConfluenceService> task) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException("task is null!");
        }
        task.call((Object)this);
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return new Attachment();
    }

    @Override
    public ConfluenceService.Model.Attachment getAttachment(String pageId, String name, String version) throws Exception {
        return (ConfluenceService.Model.Attachment)this.rxAttachment(pageId, name).map(RESTConfluenceServiceImpl$$Lambda$11.lambdaFactory$()).toBlocking().firstOrDefault(null);
    }

    @Override
    public ConfluenceService.Model.Attachment addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) throws Exception {
        return (ConfluenceService.Model.Attachment)this.rxAddAttachment(page.getId(), this.cast(attachment), source).map(RESTConfluenceServiceImpl$$Lambda$12.lambdaFactory$()).toBlocking().firstOrDefault(null);
    }

    @Override
    public boolean removePage(ConfluenceService.Model.Page parentPage, String title) throws Exception {
        return (Boolean)this.rxChildrenPages(parentPage.getId()).map(RESTConfluenceServiceImpl$$Lambda$13.lambdaFactory$()).first(RESTConfluenceServiceImpl$$Lambda$14.lambdaFactory$(title)).flatMap(RESTConfluenceServiceImpl$$Lambda$15.lambdaFactory$(this)).map(RESTConfluenceServiceImpl$$Lambda$16.lambdaFactory$()).toBlocking().firstOrDefault((Object)false);
    }

    @Override
    public void removePage(String pageId) throws Exception {
        this.rxDeletePageById(pageId).toBlocking().first();
    }

    static /* synthetic */ Page lambda$0(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Boolean lambda$1(String string, Page page) {
        return page.getTitle().equals(string);
    }

    static /* synthetic */ Page lambda$2(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Observable lambda$3(RESTConfluenceServiceImpl this_, String string, String string2, Page parent) {
        String id = parent.getId();
        JsonObjectBuilder input = this_.jsonForCreatingPage(string, Integer.valueOf(id), string2);
        return this_.rxfindPage(string, string2).switchIfEmpty(this_.rxCreatePage(input.build()));
    }

    static /* synthetic */ Page lambda$4(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Page lambda$5(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Page lambda$6(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Page lambda$7(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Page lambda$8(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Page lambda$9(JsonObject p) {
        return new Page(p);
    }

    static /* synthetic */ Attachment lambda$10(JsonObject att) {
        return new Attachment(att);
    }

    static /* synthetic */ Attachment lambda$11(JsonObject att) {
        return new Attachment(att);
    }

    static /* synthetic */ Page lambda$12(JsonObject page) {
        return new Page(page);
    }

    static /* synthetic */ Boolean lambda$13(String string, Page page) {
        return page.getTitle().equals(string);
    }

    static /* synthetic */ Observable lambda$14(RESTConfluenceServiceImpl this_, Page page) {
        return this_.rxDeletePageById(page.getId());
    }

    static /* synthetic */ Boolean lambda$15(Response res) {
        return true;
    }
}

