/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.confluence;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.ssl.SSLCertificateInfo;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Confluence2;
import org.codehaus.swizzle.confluence.ConfluenceExportDecorator;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageSummary;
import org.codehaus.swizzle.confluence.ServerInfo;
import rx.functions.Action1;

public class XMLRPCConfluenceServiceImpl
implements ConfluenceService {
    public final Confluence connection;
    public final ConfluenceService.Credentials credentials;

    public static XMLRPCConfluenceServiceImpl createInstanceDetectingVersion(String url, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        if (!sslInfo.isIgnore() && url.startsWith("https")) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslInfo.getSSLSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(sslInfo.getHostnameVerifier());
        }
        Confluence c = new Confluence(url, proxyInfo);
        c.login(credentials.username, credentials.password);
        ServerInfo info = c.getServerInfo();
        return new XMLRPCConfluenceServiceImpl(info.getMajorVersion() < 4 ? c : new Confluence2(c), credentials);
    }

    protected XMLRPCConfluenceServiceImpl(Confluence confluence, ConfluenceService.Credentials credentials) {
        if (confluence == null) {
            throw new IllegalArgumentException("confluence argument is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        this.connection = confluence;
        this.credentials = credentials;
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
        if (parentPageId == null) {
            throw new IllegalArgumentException("parentPageId argument is null!");
        }
        if (title == null) {
            throw new IllegalArgumentException("title argument is null!");
        }
        List children = this.connection.getChildren(parentPageId);
        for (PageSummary pageSummary : children) {
            if (!title.equals(pageSummary.getTitle())) continue;
            return pageSummary;
        }
        return null;
    }

    private Page cast(ConfluenceService.Model.Page page) {
        if (page == null) {
            throw new IllegalArgumentException("page argument is null!");
        }
        if (!(page instanceof Page)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Page)page;
    }

    private Attachment cast(ConfluenceService.Model.Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment argument is null!");
        }
        if (!(attachment instanceof Attachment)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Attachment)attachment;
    }

    @Override
    public boolean removePage(ConfluenceService.Model.Page parentPage, String title) throws Exception {
        if (parentPage == null) {
            throw new IllegalArgumentException("parentPage is null");
        }
        ConfluenceService.Model.PageSummary pageSummary = this.findPageByTitle(parentPage.getId(), title);
        if (pageSummary != null) {
            this.connection.removePage(pageSummary.getId());
            return true;
        }
        return false;
    }

    @Override
    public ConfluenceService.Model.Page getOrCreatePage(String spaceKey, String parentPageTitle, String title) throws Exception {
        Page parentPage = this.connection.getPage(spaceKey, parentPageTitle);
        return this.getOrCreatePage(parentPage, title);
    }

    @Override
    public ConfluenceService.Model.Page getOrCreatePage(ConfluenceService.Model.Page parentPage, String title) throws Exception {
        Page result;
        ConfluenceService.Model.PageSummary pageSummary = this.findPageByTitle(parentPage.getId(), title);
        if (pageSummary != null) {
            result = this.connection.getPage(pageSummary.getId());
        } else {
            result = new Page(Collections.emptyMap());
            result.setSpace(parentPage.getSpace());
            result.setParentId(parentPage.getId());
            result.setTitle(title);
        }
        return result;
    }

    @Override
    public ConfluenceService.Model.Attachment addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) throws Exception {
        int len;
        if (page.getId() == null) {
            throw new IllegalStateException("PageId is null. Attachment cannot be added!");
        }
        Attachment a = this.cast(attachment);
        BufferedInputStream fis = new BufferedInputStream(source, 4096);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] readbuf = new byte[4096];
        while ((len = fis.read(readbuf)) == readbuf.length) {
            baos.write(readbuf, 0, len);
        }
        if (len > 0) {
            baos.write(readbuf, 0, len);
        }
        a.setPageId(page.getId());
        return this.connection.addAttachment(new Long(page.getId()), a, baos.toByteArray());
    }

    @Override
    public ConfluenceService.Model.Page storePage(ConfluenceService.Model.Page page) throws Exception {
        Page p = this.cast(page);
        return this.connection.storePage(p);
    }

    @Override
    public ConfluenceService.Model.Page storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) throws Exception {
        if (content == null) {
            throw new IllegalArgumentException("content argument is null!");
        }
        Page p = this.cast(page);
        p.setContent(content.value);
        return this.connection.storePage(p);
    }

    public boolean logout() {
        try {
            return this.connection.logout();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean addLabelByName(String label, long id) throws Exception {
        return this.connection.addLabelByName(label, id);
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return new Attachment();
    }

    @Override
    public ConfluenceService.Model.Attachment getAttachment(String pageId, String name, String version) throws Exception {
        return this.connection.getAttachment(pageId, name, version);
    }

    @Override
    public ConfluenceService.Model.Page getPage(String spaceKey, String pageTitle) throws Exception {
        return this.connection.getPage(spaceKey, pageTitle);
    }

    @Override
    public ConfluenceService.Model.Page getPage(String pageId) throws Exception {
        return this.connection.getPage(pageId);
    }

    public String toString() {
        try {
            ServerInfo si = this.connection.getServerInfo();
            return String.format("Confluence version [%d.%d.%d-%s] development version [%b]", si.getMajorVersion(), si.getMinorVersion(), si.getPatchLevel(), si.getBuildId(), si.isDevelopmentBuild());
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @Override
    public void call(Action1<ConfluenceService> task) throws Exception {
        try {
            task.call((Object)this);
        }
        finally {
            this.logout();
        }
    }

    @Override
    public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
        return this.connection.getDescendents(pageId);
    }

    @Override
    public void removePage(String pageId) throws Exception {
        this.connection.removePage(pageId);
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(this, url);
        exporter.exportPage(spaceKey, pageTitle, exfmt, outputFile);
    }
}

