/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.bsc.confluence.ExportFormat;
import org.bsc.functional.Tuple2;

public interface ConfluenceService {
    public Credentials getCredentials();

    public Model.PageSummary findPageByTitle(String var1, String var2) throws Exception;

    public CompletableFuture<Boolean> removePage(Model.Page var1, String var2);

    public void removePage(String var1) throws Exception;

    public CompletableFuture<Model.Page> createPage(Model.Page var1, String var2);

    public CompletableFuture<Optional<Model.Page>> getPage(String var1);

    public CompletableFuture<Optional<Model.Page>> getPage(String var1, String var2);

    public boolean addLabelByName(String var1, long var2) throws Exception;

    public CompletableFuture<Model.Page> storePage(Model.Page var1, Storage var2);

    public CompletableFuture<Model.Page> storePage(Model.Page var1);

    public List<Model.PageSummary> getDescendents(String var1) throws Exception;

    public void exportPage(String var1, String var2, String var3, ExportFormat var4, File var5) throws Exception;

    public void call(Consumer<ConfluenceService> var1) throws Exception;

    public Model.Attachment createAttachment();

    public CompletableFuture<Optional<Model.Attachment>> getAttachment(String var1, String var2, String var3);

    public CompletableFuture<Model.Attachment> addAttachment(Model.Page var1, Model.Attachment var2, InputStream var3);

    default public CompletableFuture<Model.Page> getOrCreatePage(String spaceKey, String parentPageTitle, String title) {
        return ((CompletableFuture)((CompletableFuture)this.getPage(spaceKey, parentPageTitle).thenApply(parent -> (Model.Page)parent.orElseThrow(() -> new RuntimeException(String.format("cannot find parent page [%s] in space [%s]", parentPageTitle))))).thenCombine(this.getPage(spaceKey, title), Tuple2::of)).thenCompose(tuple -> ((Optional)tuple.value2).isPresent() ? CompletableFuture.completedFuture((Model.Page)((Optional)tuple.value2).get()) : this.createPage((Model.Page)tuple.value1, title));
    }

    public static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            if (username == null) {
                throw new IllegalArgumentException("username argument is null!");
            }
            this.username = username;
            this.password = password;
        }
    }

    public static interface Model {

        public static interface Attachment {
            public void setFileName(String var1);

            public String getFileName();

            public void setContentType(String var1);

            public void setComment(String var1);

            public Date getCreated();
        }

        public static interface Page
        extends PageSummary {
            public int getVersion();
        }

        public static interface PageSummary {
            public String getId();

            public String getTitle();

            public String getSpace();

            public String getParentId();
        }
    }

    public static enum Protocol {
        XMLRPC("rpc/xmlrpc"),
        REST("rest/api");

        private final String path;

        private Protocol(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        public String addTo(String endpoint) {
            if (endpoint == null) {
                throw new IllegalArgumentException("endpoint argument is null!");
            }
            if (endpoint.endsWith(this.path)) {
                return endpoint;
            }
            if (!endpoint.endsWith("/")) {
                endpoint = endpoint.concat("/");
            }
            return endpoint.concat(this.path);
        }

        public String removeFrom(String endpoint) {
            if (endpoint == null) {
                throw new IllegalArgumentException("endpoint argument is null!");
            }
            String result = endpoint.replace(this.path, "");
            result = result.startsWith("/") ? result.substring(1) : result;
            return result;
        }

        public boolean match(String endpoint) {
            return Pattern.matches(String.format(".+(%s)[/]?", this.path), endpoint);
        }
    }

    public static class Storage {
        public final String value;
        public final Representation rapresentation;

        public Storage(String value, Representation rapresentation) {
            this.value = value;
            this.rapresentation = rapresentation;
        }

        public static enum Representation {
            STORAGE,
            WIKI;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

