/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class DeployStateManager {
    public static final String STORAGE_NAME = "state.json";
    private Map<String, Map<String, JsonValue>> storage = new HashMap<String, Map<String, JsonValue>>();
    private final Parameters _info;
    private final String _endpoint;

    private DeployStateManager(String endpoint, Parameters info) {
        Objects.requireNonNull(endpoint, "endpoint is null!");
        Objects.requireNonNull(info, "info is null!");
        this._endpoint = endpoint;
        this._info = info;
        this._info._outdir.ifPresent(p -> {
            if (!Files.exists(p, new LinkOption[0])) {
                try {
                    Files.createDirectories(p, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Impossible create path [%s]", p));
                }
            } else if (!Files.isDirectory(p, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Path [%s] is not a directory", p));
            }
        });
    }

    public static DeployStateManager load(String endpoint, Parameters info) {
        DeployStateManager result = new DeployStateManager(endpoint, info);
        result._load();
        return result;
    }

    private boolean isValid() {
        return this._info.active && this._info._outdir.isPresent();
    }

    private void _load() {
        if (!this.isValid()) {
            return;
        }
        Path file = Paths.get(((Path)this._info._outdir.get()).toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            try {
                Throwable e2 = null;
                Object var3_6 = null;
                try (JsonReader r = Json.createReader((Reader)Files.newBufferedReader(file));){
                    r.readObject().entrySet().forEach(e -> {
                        HashMap ss = new HashMap();
                        ((JsonObject)e.getValue()).entrySet().forEach(ee -> {
                            JsonValue jsonValue = ss.put((String)ee.getKey(), (JsonValue)ee.getValue());
                        });
                        this.storage.put((String)e.getKey(), ss);
                    });
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.storage.containsKey(this._endpoint)) {
            this.storage.put(this._endpoint, new HashMap());
            this.save();
        }
    }

    private void save() {
        if (!this.isValid()) {
            return;
        }
        Path file = Paths.get(((Path)this._info._outdir.get()).toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        JsonObjectBuilder b = Json.createObjectBuilder();
        this.storage.entrySet().forEach(e -> {
            JsonObjectBuilder b1 = Json.createObjectBuilder();
            ((Map)e.getValue()).entrySet().forEach(ee -> {
                JsonObjectBuilder jsonObjectBuilder2 = b1.add((String)ee.getKey(), (JsonValue)ee.getValue());
            });
            b.add((String)e.getKey(), b1);
        });
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonWriter w = Json.createWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
                w.writeObject(b.build());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JsonNumber createValue(long value) {
        return Json.createArrayBuilder().add(value).build().getJsonNumber(0);
    }

    public boolean isUpdated(URI uri) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        if (Objects.nonNull(scheme) && "file".equalsIgnoreCase(scheme)) {
            return this.isUpdated(Paths.get(uri));
        }
        return true;
    }

    public boolean isUpdated(Path file) {
        long lastModifiedStored;
        Objects.requireNonNull(file, "file is null!");
        if (!this.isValid()) {
            return true;
        }
        Path b = file.toAbsolutePath();
        Map<String, JsonValue> s = this.storage.get(this._endpoint);
        if (s == null) {
            return true;
        }
        String key = ((Path)this._info._outdir.get()).relativize(b).toString();
        JsonNumber value = s.containsKey(key) ? (JsonNumber)s.get(key) : this.createValue(0L);
        long lastModified = file.toFile().lastModified();
        if (lastModified > (lastModifiedStored = value.longValue())) {
            s.put(key, (JsonValue)this.createValue(lastModified));
            this.save();
            return true;
        }
        return false;
    }

    public void resetState(URI uri) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        if (Objects.nonNull(scheme) && "file".equalsIgnoreCase(scheme)) {
            this.resetState(Paths.get(uri));
        }
    }

    public void resetState(Path file) {
        Objects.requireNonNull(file, "file is null!");
        if (!this.isValid()) {
            return;
        }
        Path b = file.toAbsolutePath();
        Map<String, JsonValue> s = this.storage.get(this._endpoint);
        String key = ((Path)this._info._outdir.get()).relativize(b).toString();
        s.put(key, (JsonValue)this.createValue(0L));
        this.save();
    }

    public String toString() {
        return this._info.toString();
    }

    public static class Parameters {
        private Optional<Path> _outdir = Optional.empty();
        private boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setOutdir(File outdir) {
            if (outdir == null) {
                this._outdir = Optional.empty();
                return;
            }
            this._outdir = Optional.of(outdir.toPath());
        }

        public Optional<Path> getOutdir() {
            return this._outdir;
        }

        public String toString() {
            return "DeployStateManager" + "\n\t" + "active=" + this.active + "\n\t" + "outdir=" + this._outdir + "\n";
        }
    }
}

