/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.rest.model.Attachment;

public abstract class AbstractRESTConfluenceService {
    private static final String EXPAND = "space,version,container";
    final OkHttpClient.Builder client = new OkHttpClient.Builder();

    public abstract ConfluenceService.Credentials getCredentials();

    protected abstract HttpUrl.Builder urlBuilder();

    protected Response fromRequest(Request req, String description) {
        try {
            Response res = this.client.build().newCall(req).execute();
            if (!res.isSuccessful()) {
                throw new ServiceException(String.format("error: %s\n%s", description, res.toString()), res);
            }
            return res;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected Stream<Response> fromUrlGET(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).get().build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected Stream<Response> fromUrlDELETE(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).delete().build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected Stream<Response> fromUrlPOST(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).post(inputBody).build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected Stream<Response> fromUrlPUT(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).put(inputBody).build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected void debugBody(Response res) {
        ResponseBody body = res.body();
        try {
            System.out.printf("BODY\n%s\n", new String(body.bytes()));
        }
        catch (IOException e) {
            System.out.printf("READ BODY EXCEPTION\n%s\n", e.getMessage());
        }
    }

    protected Stream<JsonObject> mapToArray(Response res) {
        ResponseBody body = res.body();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader r = body.charStream();){
                JsonReader rdr = Json.createReader((Reader)r);
                JsonObject root = rdr.readObject();
                if (!root.containsKey((Object)"results")) {
                    throw new Error(root.toString());
                }
                JsonArray results = root.getJsonArray("results");
                Stream.Builder<JsonObject> stream = Stream.builder();
                if (results != null) {
                    int ii = 0;
                    while (ii < results.size()) {
                        stream.add(results.getJsonObject(ii));
                        ++ii;
                    }
                }
                return stream.build();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JsonParsingException e) {
            throw new Error(e);
        }
    }

    protected JsonObject mapToObject(Response res) {
        ResponseBody body = res.body();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader r = body.charStream();){
                JsonReader rdr = Json.createReader((Reader)r);
                JsonObject root = rdr.readObject();
                return root;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected Optional<JsonObject> findPageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find page").flatMap(this::mapToArray).findFirst();
    }

    protected List<JsonObject> rxfindPages(String spaceKey, String title) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addQueryParameter("spaceKey", spaceKey).addQueryParameter("title", title).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find pages").flatMap(this::mapToArray).collect(Collectors.toList());
    }

    protected List<JsonObject> rxDescendantPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get descendant pages").flatMap(this::mapToArray).flatMap(o -> {
            String childId = o.getString("id");
            return Stream.concat(Stream.of(o), this.rxDescendantPages(childId).stream());
        }).collect(Collectors.toList());
    }

    protected List<JsonObject> childrenPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get children pages").flatMap(this::mapToArray).collect(Collectors.toList());
    }

    public Optional<JsonObject> findPage(String spaceKey, String title) {
        return this.rxfindPages(spaceKey, title).stream().findFirst();
    }

    protected boolean rxDeletePageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).build();
        this.fromUrlDELETE(url, "delete page");
        return true;
    }

    public final Optional<JsonObject> createPage(JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").build();
        return this.fromUrlPOST(url, inputBody, "create page").map(this::mapToObject).findFirst();
    }

    protected Optional<JsonObject> updatePage(String pageId, JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(pageId).build();
        return this.fromUrlPUT(url, inputBody, "update page").map(this::mapToObject).findFirst();
    }

    protected final void rxAddLabels(String id, String ... labels) {
        JsonArrayBuilder inputBuilder = Json.createArrayBuilder();
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            inputBuilder.add(Json.createObjectBuilder().add("prefix", "global").add("name", name));
            ++n2;
        }
        JsonArray inputData = inputBuilder.build();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegment("label").build();
        this.fromUrlPOST(url, inputBody, "add label");
    }

    protected List<JsonObject> getAttachments(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachments").flatMap(this::mapToArray).collect(Collectors.toList());
    }

    protected List<JsonObject> getAttachment(String id, String fileName) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("filename", fileName).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachment").flatMap(this::mapToArray).collect(Collectors.toList());
    }

    protected List<JsonObject> addAttachment(String id, Attachment att, InputStream data) {
        RequestBody fileBody;
        try {
            fileBody = RequestBody.create((MediaType)MediaType.parse((String)att.getContentType()), (byte[])IOUtils.toByteArray((InputStream)data));
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        MultipartBody inputBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("comment", att.getComment()).addFormDataPart("minorEdit", "true").addFormDataPart("file", att.getFileName(), fileBody).build();
        HttpUrl.Builder builder = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment");
        if (att.getId() != null) {
            builder.addPathSegment(att.getId()).addPathSegment("data");
        }
        return this.fromUrlPOST(builder.build(), (RequestBody)inputBody, "create attachment").flatMap(post -> att.getId() != null ? Stream.of(this.mapToObject((Response)post)) : this.mapToArray((Response)post)).collect(Collectors.toList());
    }

    public static class ServiceException
    extends Error {
        public final Response res;

        public ServiceException(String message, Response res) {
            super(message);
            this.res = res;
        }
    }
}

