/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bsc.confluence.model.Site;

public class SitePrinter {
    public static String getPrintableStringForResource(Site site, Site.Source source) {
        return SitePrinter.getPrintableStringForResource(site, source.getUri());
    }

    public static String getPrintableStringForResource(Site site, URI uri) {
        try {
            Path p = Paths.get(uri);
            return site.getBasedir().relativize(p).toString();
        }
        catch (Exception e) {
            return uri.toString();
        }
    }

    public static void printSource(Site site, PrintStream out, int level, char c, Site.Source source) {
        int i = 0;
        while (i < level) {
            System.out.print(c);
            ++i;
        }
        out.print(" ");
        out.println(SitePrinter.getPrintableStringForResource(site, source));
    }

    public static void printChildren(Site site, PrintStream out, int level, Site.Page parent) {
        SitePrinter.printSource(site, out, level, '-', parent);
        for (Site.Attachment attach : parent.getAttachments()) {
            SitePrinter.printSource(site, out, level + 1, '#', attach);
        }
        for (Site.Page child : parent.getChildren()) {
            SitePrinter.printChildren(site, out, level + 1, child);
        }
    }

    public static void print(Site site, PrintStream out) {
        out.println("Site");
        if (!site.getLabels().isEmpty()) {
            out.println(" Labels");
            for (String label : site.getLabels()) {
                out.printf("  %s\n", label);
            }
        }
        SitePrinter.printChildren(site, out, 0, site.getHome());
    }
}

