/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.functional.Tuple2;
import org.bsc.markdown.ToConfluenceSerializer;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.Visitor;

public class SiteProcessor {
    public static <T> T processUri(URI uri, BiFunction<Optional<Exception>, Optional<InputStream>, T> callback) {
        Objects.requireNonNull(uri, "uri is null!");
        Objects.requireNonNull(callback, "callback is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                result = cl.getResourceAsStream(source);
                Exception ex = new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        } else {
            try {
                URL url = uri.toURL();
                result = url.openStream();
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening url [%s]!", source), e);
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        }
        return callback.apply(Optional.empty(), Optional.of(result));
    }

    public static <T> T processPageUri(URI uri, String homePageTitle, BiFunction<Optional<Exception>, Tuple2<Optional<InputStream>, ConfluenceService.Storage.Representation>, T> callback) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = path != null && path.endsWith(".md");
        boolean isStorage = path != null && (path.endsWith(".xml") || path.endsWith(".xhtml"));
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(source);
                try {
                    InputStream inputStream = result = isMarkdown ? SiteProcessor.processMarkdown(is, homePageTitle) : is;
                    if (result == null) {
                        Exception ex = new Exception(String.format("page [%s] doesn't exist in classloader", source));
                        return callback.apply(Optional.of(ex), Tuple2.of(Optional.empty(), representation));
                    }
                }
                catch (IOException e) {
                    Exception ex = new Exception(String.format("error processing markdown for page [%s] ", source));
                    return callback.apply(Optional.of(ex), Tuple2.of(Optional.empty(), representation));
                }
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                result = isMarkdown ? SiteProcessor.processMarkdown(is, homePageTitle) : is;
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening/processing page [%s]!", source), e);
                return callback.apply(Optional.of(ex), Tuple2.of(Optional.empty(), representation));
            }
        }
        return callback.apply(Optional.empty(), Tuple2.of(Optional.of(result), representation));
    }

    public static <T> T processUriContent(URI uri, String homePageTitle, BiFunction<InputStream, ConfluenceService.Storage.Representation, T> onSuccess) throws Exception {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = path != null && path.endsWith(".md");
        boolean isStorage = path != null && (path.endsWith(".xml") || path.endsWith(".xhtml"));
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(source);
                InputStream inputStream = result = isMarkdown ? SiteProcessor.processMarkdown(is, homePageTitle) : is;
                if (result == null) {
                    throw new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                }
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                result = isMarkdown ? SiteProcessor.processMarkdown(is, homePageTitle) : is;
            }
            catch (IOException e) {
                throw new Exception(String.format("error opening url [%s]!", source), e);
            }
        }
        return onSuccess.apply(result, representation);
    }

    static InputStream processMarkdown(InputStream is, final String homePageTitle) throws IOException {
        final char[] contents = IOUtils.toCharArray((InputStream)is);
        PegDownProcessor p = new PegDownProcessor(ToConfluenceSerializer.extensions());
        RootNode root = p.parseMarkdown(contents);
        ToConfluenceSerializer ser = new ToConfluenceSerializer(){

            @Override
            protected void notImplementedYet(Node node) {
                int[] lc = ToConfluenceSerializer.lineAndColFromNode(new String(contents), node);
                throw new UnsupportedOperationException(String.format("Node [%s] not supported yet. line=[%d] col=[%d]", node.getClass().getSimpleName(), lc[0], lc[1]));
            }

            @Override
            protected String getHomePageTitle() {
                return homePageTitle;
            }
        };
        root.accept((Visitor)ser);
        return new ByteArrayInputStream(ser.toString().getBytes());
    }
}

