/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.rest.model.Attachment;

public abstract class AbstractRESTConfluenceService {
    private static final String EXPAND = "space,version,container";
    final OkHttpClient.Builder client = new OkHttpClient.Builder();

    public abstract ConfluenceService.Credentials getCredentials();

    protected abstract HttpUrl.Builder urlBuilder();

    protected Response fromRequest(Request req, String description) {
        try {
            Response res = this.client.build().newCall(req).execute();
            if (!res.isSuccessful()) {
                throw new ServiceException(String.format("error: %s\n%s\n%s", description, res.toString(), res.body().string()), res);
            }
            return res;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected Stream<Response> fromUrlGET(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).get().build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected Stream<Response> fromUrlDELETE(HttpUrl url, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).delete().build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected Stream<Response> fromUrlPOST(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).post(inputBody).build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected Stream<Response> fromUrlPUT(HttpUrl url, RequestBody inputBody, String description) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).put(inputBody).build();
        return Stream.of(this.fromRequest(req, description));
    }

    protected void debugBody(Response res) {
        ResponseBody body = res.body();
        try {
            System.out.printf("BODY\n%s\n", new String(body.bytes()));
        }
        catch (IOException e) {
            System.out.printf("READ BODY EXCEPTION\n%s\n", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Stream<JsonObject> mapToStream(Response res) {
        ResponseBody body = res.body();
        try (Reader r = body.charStream();){
            JsonReader rdr = Json.createReader((Reader)r);
            JsonObject root = rdr.readObject();
            Stream.Builder<JsonObject> stream = Stream.builder();
            if (root.containsKey((Object)"results")) {
                JsonArray results = root.getJsonArray("results");
                if (results != null) {
                    for (int ii = 0; ii < results.size(); ++ii) {
                        stream.add(results.getJsonObject(ii));
                    }
                }
            } else {
                stream.add(root);
            }
            Stream<JsonObject> stream2 = stream.build();
            return stream2;
        }
        catch (IOException | JsonParsingException e) {
            throw new Error(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject mapToObject(Response res) {
        ResponseBody body = res.body();
        try (Reader r = body.charStream();){
            JsonObject root;
            JsonReader rdr = Json.createReader((Reader)r);
            JsonObject jsonObject = root = rdr.readObject();
            return jsonObject;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected Optional<JsonObject> findPageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find page").flatMap(this::mapToStream).findFirst();
    }

    protected List<JsonObject> rxfindPages(String spaceKey, String title) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addQueryParameter("spaceKey", spaceKey).addQueryParameter("title", title).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "find pages").flatMap(this::mapToStream).collect(Collectors.toList());
    }

    protected List<JsonObject> rxDescendantPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get descendant pages").flatMap(this::mapToStream).flatMap(o -> {
            String childId = o.getString("id");
            return Stream.concat(Stream.of(o), this.rxDescendantPages(childId).stream());
        }).collect(Collectors.toList());
    }

    protected List<JsonObject> childrenPages(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get children pages").flatMap(this::mapToStream).collect(Collectors.toList());
    }

    public Optional<JsonObject> findPage(String spaceKey, String title) {
        return this.rxfindPages(spaceKey, title).stream().findFirst();
    }

    protected boolean rxDeletePageById(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).build();
        this.fromUrlDELETE(url, "delete page");
        return true;
    }

    public final Optional<JsonObject> createPage(JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").build();
        return this.fromUrlPOST(url, inputBody, "create page").map(this::mapToObject).findFirst();
    }

    protected Optional<JsonObject> updatePage(String pageId, JsonObject inputData) {
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(pageId).build();
        return this.fromUrlPUT(url, inputBody, "update page").map(this::mapToObject).findFirst();
    }

    protected final void rxAddLabels(String id, String ... labels) {
        JsonArrayBuilder inputBuilder = Json.createArrayBuilder();
        for (String name : labels) {
            inputBuilder.add(Json.createObjectBuilder().add("prefix", "global").add("name", name));
        }
        JsonArray inputData = inputBuilder.build();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegment("label").build();
        this.fromUrlPOST(url, inputBody, "add label");
    }

    protected List<JsonObject> getAttachments(String id) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachments").flatMap(this::mapToStream).collect(Collectors.toList());
    }

    protected List<JsonObject> getAttachment(String id, String fileName) {
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("filename", fileName).addQueryParameter("expand", EXPAND).build();
        return this.fromUrlGET(url, "get attachment").flatMap(this::mapToStream).collect(Collectors.toList());
    }

    protected List<JsonObject> addAttachment(String id, Attachment att, InputStream data) {
        RequestBody fileBody;
        try {
            fileBody = RequestBody.create((MediaType)MediaType.parse((String)att.getContentType()), (byte[])IOUtils.toByteArray((InputStream)data));
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        MultipartBody inputBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("comment", att.getComment()).addFormDataPart("minorEdit", "true").addFormDataPart("file", att.getFileName(), fileBody).build();
        HttpUrl.Builder builder = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment");
        if (att.getId() != null) {
            builder.addPathSegment(att.getId()).addPathSegment("data");
        }
        return this.fromUrlPOST(builder.build(), (RequestBody)inputBody, "create attachment").flatMap(post -> att.getId() != null ? Stream.of(this.mapToObject((Response)post)) : this.mapToStream((Response)post)).collect(Collectors.toList());
    }

    public static class ServiceException
    extends Error {
        public final Response res;

        public ServiceException(String message, Response res) {
            super(message);
            this.res = res;
        }
    }
}

