/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.codec.digest.DigestUtils;

public class DeployStateManager {
    public static final String STORAGE_NAME = "confluence-reporting-maven-plugin-storage.json";
    private Map<String, Map<String, JsonValue>> storage = new HashMap<String, Map<String, JsonValue>>();
    private final Parameters _info;
    private final String _endpoint;
    private final JsonWriterFactory writerFactory;

    private DeployStateManager(String endpoint, Parameters info) {
        Objects.requireNonNull(endpoint, "endpoint is null!");
        Objects.requireNonNull(info, "info is null!");
        this._endpoint = endpoint;
        this._info = info;
        this._info._outdir.ifPresent(p -> {
            if (!Files.exists(p, new LinkOption[0])) {
                try {
                    Files.createDirectories(p, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Impossible create path [%s]", p));
                }
            } else if (!Files.isDirectory(p, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Path [%s] is not a directory", p));
            }
        });
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        this.writerFactory = Json.createWriterFactory(config);
    }

    public static DeployStateManager load(String endpoint, Parameters info) {
        DeployStateManager result = new DeployStateManager(endpoint, info);
        result._load();
        return result;
    }

    private boolean isValid() {
        return this._info.active && this._info._outdir.isPresent();
    }

    private void _load() {
        if (!this.isValid()) {
            return;
        }
        Path file = Paths.get(((Path)this._info._outdir.get()).toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            try (JsonReader r = Json.createReader((Reader)Files.newBufferedReader(file));){
                r.readObject().entrySet().forEach(e -> {
                    HashMap ss = new HashMap();
                    ((JsonObject)e.getValue()).entrySet().forEach(ee -> ss.put((String)ee.getKey(), (JsonValue)ee.getValue()));
                    this.storage.put((String)e.getKey(), ss);
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.storage.containsKey(this._endpoint)) {
            this.storage.put(this._endpoint, new HashMap());
            this.save();
        }
    }

    private void save() {
        if (!this.isValid()) {
            return;
        }
        Path file = Paths.get(((Path)this._info._outdir.get()).toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        JsonObjectBuilder b = Json.createObjectBuilder();
        this.storage.entrySet().forEach(e -> {
            JsonObjectBuilder b1 = Json.createObjectBuilder();
            ((Map)e.getValue()).entrySet().forEach(ee -> b1.add((String)ee.getKey(), (JsonValue)ee.getValue()));
            b.add((String)e.getKey(), b1);
        });
        try (JsonWriter w = this.writerFactory.createWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
            w.writeObject(b.build());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JsonString createValue(String value) {
        return Json.createArrayBuilder().add(value).build().getJsonString(0);
    }

    public boolean isUpdated(URI uri) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        if (Objects.nonNull(scheme) && "file".equalsIgnoreCase(scheme)) {
            return this.isUpdated(Paths.get(uri));
        }
        return true;
    }

    public boolean isUpdated(Path file) {
        String lastStoredFileMd5Hash;
        Objects.requireNonNull(file, "file is null!");
        if (!this.isValid()) {
            return true;
        }
        Path b = file.toAbsolutePath();
        Map<String, JsonValue> s = this.storage.get(this._endpoint);
        if (s == null) {
            return true;
        }
        String key = ((Path)this._info._outdir.get()).relativize(b).toString();
        JsonString value = s.containsKey(key) ? (JsonString)s.get(key) : this.createValue("0");
        String fileMd5Hash = DeployStateManager.md5Hash(file);
        if (!Objects.equals(fileMd5Hash, lastStoredFileMd5Hash = value.getString())) {
            s.put(key, (JsonValue)this.createValue(fileMd5Hash));
            this.save();
            return true;
        }
        return false;
    }

    private static String md5Hash(Path file) {
        String string;
        FileInputStream fis = new FileInputStream(file.toFile());
        try {
            string = DigestUtils.md5Hex((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        fis.close();
        return string;
    }

    public void resetState(URI uri) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        if (Objects.nonNull(scheme) && "file".equalsIgnoreCase(scheme)) {
            this.resetState(Paths.get(uri));
        }
    }

    public void resetState(Path file) {
        Objects.requireNonNull(file, "file is null!");
        if (!this.isValid()) {
            return;
        }
        Path b = file.toAbsolutePath();
        Map<String, JsonValue> s = this.storage.get(this._endpoint);
        String key = ((Path)this._info._outdir.get()).relativize(b).toString();
        s.put(key, (JsonValue)this.createValue("0"));
        this.save();
    }

    public String toString() {
        return this._info.toString();
    }

    public static class Parameters {
        private Optional<Path> _outdir = Optional.empty();
        private boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setOutdir(File outdir) {
            if (outdir == null) {
                this._outdir = Optional.empty();
                return;
            }
            this._outdir = Optional.of(outdir.toPath());
        }

        public Optional<Path> getOutdir() {
            return this._outdir;
        }

        public String toString() {
            return "DeployStateManager" + "\n\t" + "active=" + this.active + "\n\t" + "outdir=" + this._outdir + "\n";
        }
    }
}

