/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.ParentChildTuple;

public interface ConfluenceService
extends Closeable {
    public Credentials getCredentials();

    public CompletableFuture<Optional<? extends Model.PageSummary>> getPageByTitle(Model.ID var1, String var2);

    public CompletableFuture<Boolean> removePage(Model.Page var1, String var2);

    public CompletableFuture<Boolean> removePage(Model.ID var1);

    public CompletableFuture<Model.Page> createPage(Model.Page var1, String var2, Storage var3);

    public CompletableFuture<Model.Page> storePage(Model.Page var1, Storage var2);

    public CompletableFuture<Model.Page> storePage(Model.Page var1);

    public CompletableFuture<Optional<Model.Page>> getPage(Model.ID var1);

    public CompletableFuture<Optional<Model.Page>> getPage(String var1, String var2);

    public CompletableFuture<Void> addLabelsByName(Model.ID var1, String[] var2);

    default public CompletableFuture<Void> addLabelsByName(Model.ID id, List<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        String[] labelArray = new String[labels.size()];
        return this.addLabelsByName(id, labels.toArray(labelArray));
    }

    public CompletableFuture<List<Model.PageSummary>> getDescendents(Model.ID var1);

    public void exportPage(String var1, String var2, String var3, ExportFormat var4, File var5) throws Exception;

    public Model.Attachment createAttachment();

    public CompletableFuture<Optional<Model.Attachment>> getAttachment(Model.ID var1, String var2, String var3);

    public CompletableFuture<Model.Attachment> addAttachment(Model.Page var1, Model.Attachment var2, InputStream var3);

    public Model.Blogpost createBlogpost(String var1, String var2, Storage var3, int var4);

    public CompletableFuture<Model.Blogpost> addBlogpost(Model.Blogpost var1);

    default public CompletableFuture<Model.Page> getOrCreatePage(String spaceKey, String parentPageTitle, String title) {
        return ((CompletableFuture)((CompletableFuture)this.getPage(spaceKey, parentPageTitle).thenApply(parent -> (Model.Page)parent.orElseThrow(() -> new RuntimeException(String.format("cannot find parent page [%s] in space [%s]", parentPageTitle, spaceKey))))).thenCombine(this.getPage(spaceKey, title), ParentChildTuple::of)).thenCompose(tuple -> tuple.getChild().isPresent() ? CompletableFuture.completedFuture(tuple.getChild().get()) : this.createPage(tuple.getParent(), title, Storage.of("", Storage.Representation.WIKI)));
    }

    default public <T> CompletableFuture<T> retry(int times, long delay, TimeUnit timeUnit, Optional<CompletableFuture<T>> resultHandler, Supplier<CompletableFuture<T>> action) {
        CompletableFuture future = resultHandler.orElseGet(() -> new CompletableFuture());
        ((CompletableFuture)action.get().thenAccept(a -> future.complete(a))).exceptionally(ex -> {
            if (times <= 0) {
                future.completeExceptionally((Throwable)ex);
            } else {
                try {
                    timeUnit.sleep(delay);
                    this.retry(times - 1, delay, timeUnit, Optional.of(future), action);
                }
                catch (InterruptedException e) {
                    future.completeExceptionally(e);
                }
            }
            return null;
        });
        return future;
    }

    public static interface Model {

        public static interface Blogpost {
            public ID getId();

            public String getTitle();

            public String getSpace();

            public int getVersion();
        }

        public static interface Page
        extends PageSummary {
            public int getVersion();
        }

        public static interface PageSummary {
            public ID getId();

            public String getTitle();

            public String getSpace();

            public ID getParentId();
        }

        public static interface Attachment {
            public void setFileName(String var1);

            public String getFileName();

            public void setContentType(String var1);

            public void setComment(String var1);

            public Date getCreated();
        }

        public static class ID
        implements Comparable<ID> {
            final long value;

            private ID(long value) {
                this.value = value;
            }

            public long getValue() {
                return this.value;
            }

            public String toString() {
                return String.valueOf(this.value);
            }

            public static ID of(long value) {
                return new ID(value);
            }

            public static ID of(String value) {
                return new ID(Long.valueOf(value));
            }

            @Override
            public int compareTo(ID o) {
                return (int)(this.value - o.value);
            }
        }
    }

    public static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            if (username == null) {
                throw new IllegalArgumentException("username argument is null!");
            }
            this.username = username;
            this.password = password;
        }
    }

    public static class Storage {
        public final String value;
        public final Representation rapresentation;

        private Storage(String value, Representation rapresentation) {
            this.value = value;
            this.rapresentation = rapresentation;
        }

        public static Storage of(String value, Representation rapresentation) {
            return new Storage(value, rapresentation);
        }

        public static enum Representation {
            STORAGE,
            WIKI;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static enum Protocol {
        XMLRPC("rpc/xmlrpc"),
        REST("rest/api");

        private final String path;

        private Protocol(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        public String addTo(String endpoint) {
            if (null == endpoint) {
                throw new IllegalArgumentException("endpoint argument is null!");
            }
            if (endpoint.endsWith(this.path)) {
                return endpoint;
            }
            if (!endpoint.endsWith("/")) {
                endpoint = endpoint.concat("/");
            }
            return endpoint.concat(this.path);
        }

        public String removeFrom(String endpoint) {
            if (null == endpoint) {
                throw new IllegalArgumentException("endpoint argument is null!");
            }
            String result = endpoint.replace(this.path, "");
            result = result.startsWith("/") ? result.substring(1) : result;
            return result;
        }

        public boolean match(String endpoint) {
            return Pattern.matches(String.format(".+(%s)[/]?", this.path), endpoint);
        }
    }
}

