/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.bsc.confluence.ConfluenceHtmlUtils;

public class ConfluenceUtils {
    private static final String LABEL_BAD_CHARS = "[:;,\\.,\\?&\\[\\]\\(\\)#^\\*!@ ]";
    private static final Pattern LABEL_BAD_CHARS_PATTERN = Pattern.compile("[:;,\\.,\\?&\\[\\]\\(\\)#^\\*!@ ]");
    private static final String LABEL_REPLACEMENT = "-";

    public static String encodeAnchor(String value) {
        if (null == value) {
            return null;
        }
        String v = ConfluenceHtmlUtils.replaceHTML(value);
        try {
            new URL(v);
            return v;
        }
        catch (MalformedURLException e) {
            return v.replace(':', '_');
        }
    }

    public static String getBannerWiki() {
        StringBuilder wiki = new StringBuilder().append("{info:title=").append("Generated page").append('}').append("this page has been generated by plugin: ").append("[org.bsc.maven:maven-confluence-reporting-plugin|https://github.com/bsorrentino/maven-confluence-plugin]").append("{info}").append('\n');
        return wiki.toString();
    }

    public static String sanitizeLabel(String label) {
        return LABEL_BAD_CHARS_PATTERN.matcher(label).replaceAll(LABEL_REPLACEMENT);
    }
}

