/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.json.JsonObjectBuilder;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl;
import org.bsc.confluence.rest.model.Page;
import org.bsc.confluence.xmlrpc.XMLRPCConfluenceServiceImpl;
import org.bsc.ssl.SSLCertificateInfo;

public class ConfluenceServiceFactory {
    public static ConfluenceService createInstance(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
        if (ConfluenceService.Protocol.XMLRPC.match(endpoint)) {
            return new MixedConfluenceService(endpoint, credentials, proxyInfo, sslInfo);
        }
        if (ConfluenceService.Protocol.REST.match(endpoint)) {
            return new RESTConfluenceServiceImpl(endpoint, credentials, sslInfo);
        }
        throw new IllegalArgumentException(String.format("endpoint doesn't contain a valid API protocol\nIt must be '%s' or '%s'", ConfluenceService.Protocol.XMLRPC.path(), ConfluenceService.Protocol.REST.path()));
    }

    private static class MixedConfluenceService
    implements ConfluenceService {
        final XMLRPCConfluenceServiceImpl xmlrpcService;
        final RESTConfluenceServiceImpl restService;

        public MixedConfluenceService(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
            this.xmlrpcService = XMLRPCConfluenceServiceImpl.createInstanceDetectingVersion(endpoint, credentials, proxyInfo, sslInfo);
            String restEndpoint = ConfluenceService.Protocol.XMLRPC.removeFrom(endpoint) + ConfluenceService.Protocol.REST.path();
            this.restService = new RESTConfluenceServiceImpl(restEndpoint, credentials, sslInfo);
        }

        @Override
        public ConfluenceService.Credentials getCredentials() {
            return this.xmlrpcService.getCredentials();
        }

        @Override
        public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
            return this.xmlrpcService.findPageByTitle(parentPageId, title);
        }

        @Override
        public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
            return this.xmlrpcService.removePage(parentPage, title);
        }

        @Override
        public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title) {
            return this.xmlrpcService.createPage(parentPage, title);
        }

        @Override
        public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
            return this.xmlrpcService.addAttachment(page, attachment, source);
        }

        @Override
        public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
            return this.xmlrpcService.storePage(page);
        }

        @Override
        public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
            if (ConfluenceService.Storage.Representation.STORAGE == content.rapresentation) {
                if (page.getId() == null) {
                    JsonObjectBuilder inputData = this.restService.jsonForCreatingPage(page.getSpace(), Integer.valueOf(page.getParentId()), page.getTitle());
                    this.restService.jsonAddBody(inputData, content);
                    return CompletableFuture.supplyAsync(() -> this.restService.createPage(inputData.build()).map(Page::new).get());
                }
                return this.restService.storePage(page, content);
            }
            return this.xmlrpcService.storePage(page, content);
        }

        @Override
        public boolean addLabelByName(String label, long id) throws Exception {
            return this.xmlrpcService.addLabelByName(label, id);
        }

        @Override
        public ConfluenceService.Model.Attachment createAttachment() {
            return this.xmlrpcService.createAttachment();
        }

        @Override
        public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(String pageId, String name, String version) {
            return this.xmlrpcService.getAttachment(pageId, name, version);
        }

        @Override
        public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
            return this.xmlrpcService.getPage(spaceKey, pageTitle);
        }

        @Override
        public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String pageId) {
            return this.xmlrpcService.getPage(pageId);
        }

        public String toString() {
            return this.xmlrpcService.toString();
        }

        @Override
        public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
            return this.xmlrpcService.getDescendents(pageId);
        }

        @Override
        public void removePage(String pageId) throws Exception {
            this.xmlrpcService.removePage(pageId);
        }

        @Override
        public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
            this.xmlrpcService.exportPage(url, spaceKey, pageTitle, exfmt, outputFile);
        }

        @Override
        public void close() throws IOException {
            this.xmlrpcService.logout();
        }
    }
}

