/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.bsc.confluence.ConfluenceService;

public class Attachment
implements ConfluenceService.Model.Attachment {
    String id;
    String fileName;
    Date created;
    String contentType;
    String comment;
    final DateFormat ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Attachment(JsonObject delegate) {
        JsonObject version;
        if (delegate == null) {
            throw new IllegalArgumentException("delegate argument is null!");
        }
        this.id = delegate.getString("id");
        this.fileName = delegate.getString("title");
        JsonObject extensions = delegate.getJsonObject("extensions");
        if (extensions != null) {
            this.contentType = extensions.getString("mediaType");
            this.comment = extensions.getString("comment", "");
        }
        if ((version = delegate.getJsonObject("version")) != null) {
            try {
                this.created = this.ISO8601Local.parse(version.getString("when"));
            }
            catch (ParseException ex) {
                this.created = new Date();
            }
        }
    }

    public Attachment() {
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setFileName(String name) {
        this.fileName = name;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    public JsonObject toJsonObject() {
        JsonObjectBuilder extensions = Json.createObjectBuilder().add("mediaType", this.contentType).add("comment", this.comment);
        return Json.createObjectBuilder().add("title", this.getFileName()).add("extensions", extensions).build();
    }

    public String toString() {
        return "Attachment [id=" + this.id + ", fileName=" + this.fileName + ", created=" + this.created + ", contentType=" + this.contentType + ", comment=" + this.comment + "]";
    }
}

