/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.FileExtension;
import org.bsc.confluence.model.Site;
import org.bsc.markdown.ToConfluenceSerializer;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.Visitor;

public class SiteProcessor {
    public static <T> T processUri(URI uri, BiFunction<Optional<Exception>, Optional<InputStream>, T> callback) {
        Objects.requireNonNull(uri, "uri is null!");
        Objects.requireNonNull(callback, "callback is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                result = cl.getResourceAsStream(source);
                Exception ex = new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        } else {
            try {
                URL url = uri.toURL();
                result = url.openStream();
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening url [%s]!", source), e);
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        }
        return callback.apply(Optional.empty(), Optional.of(result));
    }

    public static <T> T processPageUri(Site site, ConfluenceService.Model.Page page, URI uri, String homePageTitle, BiFunction<Optional<Exception>, Optional<PageContent>, T> callback) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = path != null && (path.endsWith(".xml") || path.endsWith(".xhtml"));
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(source);
                try {
                    InputStream inputStream = result = isMarkdown ? SiteProcessor.processMarkdown(site, Optional.ofNullable(page), is, homePageTitle) : is;
                    if (result == null) {
                        Exception ex = new Exception(String.format("page [%s] doesn't exist in classloader", source));
                        return callback.apply(Optional.of(ex), Optional.empty());
                    }
                }
                catch (IOException e) {
                    Exception ex = new Exception(String.format("error processing markdown for page [%s] ", source));
                    return callback.apply(Optional.of(ex), Optional.empty());
                }
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                result = isMarkdown ? SiteProcessor.processMarkdown(site, Optional.ofNullable(page), is, homePageTitle) : is;
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening/processing page [%s]!", source), e);
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        }
        return callback.apply(Optional.empty(), Optional.of(PageContent.of(result, representation)));
    }

    public static <T> T processUriContent(Site site, URI uri, String homePageTitle, Function<PageContent, T> onSuccess) throws Exception {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(source);
                InputStream inputStream = result = isMarkdown ? SiteProcessor.processMarkdown(site, Optional.empty(), is, homePageTitle) : is;
                if (result == null) {
                    throw new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                }
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                result = isMarkdown ? SiteProcessor.processMarkdown(site, Optional.empty(), is, homePageTitle) : is;
            }
            catch (IOException e) {
                throw new Exception(String.format("error opening url [%s]!", source), e);
            }
        }
        return onSuccess.apply(PageContent.of(result, representation));
    }

    static InputStream processMarkdown(final Site site, final Optional<ConfluenceService.Model.Page> page, InputStream content, final String homePageTitle) throws IOException {
        final char[] contents = IOUtils.toCharArray((InputStream)content);
        PegDownProcessor p = new PegDownProcessor(ToConfluenceSerializer.extensions());
        RootNode root = p.parseMarkdown(contents);
        ToConfluenceSerializer ser = new ToConfluenceSerializer(){

            @Override
            protected Optional<Site> getSite() {
                return Optional.of(site);
            }

            @Override
            protected void notImplementedYet(Node node) {
                int[] lc = ToConfluenceSerializer.lineAndColFromNode(new String(contents), node);
                throw new UnsupportedOperationException(String.format("Node [%s] not supported yet. line=[%d] col=[%d]", node.getClass().getSimpleName(), lc[0], lc[1]));
            }

            @Override
            protected Optional<String> getHomePageTitle() {
                return Optional.ofNullable(homePageTitle);
            }

            @Override
            protected boolean isImagePrefixEnabled() {
                return page.map(p -> !p.getTitle().contains("[")).orElse(true);
            }
        };
        root.accept((Visitor)ser);
        return new ByteArrayInputStream(ser.toString().getBytes());
    }

    public static final class PageContent {
        private final InputStream inputStream;
        private final ConfluenceService.Storage.Representation type;

        private PageContent(InputStream inputStream, ConfluenceService.Storage.Representation type) {
            this.inputStream = inputStream;
            this.type = type;
        }

        public static PageContent of(InputStream inputStream, ConfluenceService.Storage.Representation type) {
            return new PageContent(inputStream, type);
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public ConfluenceService.Storage.Representation getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageContent)) {
                return false;
            }
            PageContent other = (PageContent)o;
            InputStream this$inputStream = this.getInputStream();
            InputStream other$inputStream = other.getInputStream();
            if (this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream)) {
                return false;
            }
            ConfluenceService.Storage.Representation this$type = this.getType();
            ConfluenceService.Storage.Representation other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InputStream $inputStream = this.getInputStream();
            result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
            ConfluenceService.Storage.Representation $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "SiteProcessor.PageContent(inputStream=" + this.getInputStream() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }
}

