/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest.scrollversions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl;
import org.bsc.confluence.rest.scrollversions.model.ScrollVersionsNewPage;
import org.bsc.confluence.rest.scrollversions.model.ScrollVersionsPage;
import org.bsc.confluence.rest.scrollversions.model.ScrollVersionsPageByTitle;
import org.bsc.confluence.rest.scrollversions.model.ScrollVersionsTargetVersion;
import org.bsc.ssl.SSLCertificateInfo;

public class ScrollVersionsRESTConfluenceService
implements ConfluenceService {
    public static final String CHANGE_TYPE_MODIFY_QUERY_PARAM = "Modify";
    static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static final String REQUEST_BODY_GET_ALL_VERSIONED_PAGES = "[{\"queryArg\": \"pageType\", \"value\": \"change\"}]";
    static final Integer GET_CREATED_PAGE_MAX_RETRIES = 3;
    static final Long GET_CREATED_PAGE_WAIT_MS = 3000L;
    final RESTConfluenceServiceImpl delegate;
    final URL scrollVersionsUrl;
    final String scrollVersionsName;
    final ObjectMapper objectMapper;

    public ScrollVersionsRESTConfluenceService(String confluenceUrl, String scrollVersionName, ConfluenceService.Credentials credentials, SSLCertificateInfo sslCertificateInfo) {
        if (scrollVersionName == null) {
            throw new IllegalArgumentException("scrollVersionName is null!");
        }
        try {
            String regex = "/rest/api(/?)$";
            this.scrollVersionsUrl = new URL(confluenceUrl.replaceAll("/rest/api(/?)$", "/rest/scroll-versions/1.0"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid Scroll Versions url", e);
        }
        this.scrollVersionsName = scrollVersionName;
        this.delegate = new RESTConfluenceServiceImpl(confluenceUrl, credentials, sslCertificateInfo);
        this.objectMapper = new ObjectMapper();
    }

    HttpUrl.Builder urlBuilder() {
        return new HttpUrl.Builder().scheme(this.scrollVersionsUrl.getProtocol()).host(this.scrollVersionsUrl.getHost()).port(this.scrollVersionsUrl.getPort()).addPathSegments(this.scrollVersionsUrl.getPath().replaceAll("^/+", ""));
    }

    Request.Builder requestBuilder() {
        return new Request.Builder().header("Authorization", Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password)).header("X-Atlassian-Token", "nocheck");
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.delegate.getCredentials();
    }

    @Override
    public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
        Supplier<ScrollVersionsException> notFoundException = () -> new ScrollVersionsException(String.format("no page found for parent id %s and title %s in version %s", parentPageId, title, this.scrollVersionsName));
        ConfluenceService.Model.PageSummary page = this.delegate.findPageByTitle(parentPageId, title);
        return this.getPage(page.getSpace(), page.getTitle()).get().orElseThrow(notFoundException);
    }

    @Override
    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        try {
            ConfluenceService.Model.PageSummary page = this.delegate.findPageByTitle(parentPage.getId(), title);
            return this.removePageAsync(page.getId());
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(false);
        }
    }

    @Override
    public CompletableFuture<Boolean> removePageAsync(String pageId) {
        return this.getDotPageId(pageId).thenCompose(dotPageId -> this.delegate.removePageAsync((String)dotPageId));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title) {
        return this.getMasterPageId(parentPage.getId()).thenCompose(parentPageId -> this.getScrollVersionId(parentPage.getSpace()).thenCompose(scrollVersionId -> {
            HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment("new").addPathSegment(parentPage.getSpace()).addQueryParameter("parentConfluenceId", parentPageId).addEncodedQueryParameter("pageTitle", title).addQueryParameter("versionId", scrollVersionId).build();
            FormBody body = new FormBody.Builder().add("message", "Your message").build();
            Request request = this.requestBuilder().url(httpUrl).post((RequestBody)body).build();
            return ((CompletableFuture)((CompletableFuture)this.delegate.fromRequestAsync(request).thenCompose(response -> this.getCreatedPageAsync((Response)response, title))).exceptionally(ex -> {
                if (ex.getMessage().contains("Validation Error: A page already exists with the title")) {
                    return parentPage;
                }
                throw new IllegalStateException((Throwable)ex);
            })).thenCompose(id -> this.updatePage(parentPage, title, (String)scrollVersionId));
        }));
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String pageId) {
        return ((CompletableFuture)this.getDotPageId(pageId).thenCompose(this.delegate::getPage)).exceptionally(e -> Optional.empty());
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        return ((CompletableFuture)this.getDotPageId(spaceKey, pageTitle).thenCompose(this.delegate::getPage)).exceptionally(e -> Optional.empty());
    }

    @Override
    public boolean addLabelByName(String label, long id) throws Exception {
        return this.delegate.addLabelByName(label, Long.parseLong(this.getDotPageId(String.valueOf(id)).get()));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        return this.getPage(page.getId()).thenCompose(dotPage -> dotPage.isPresent() ? this.delegate.storePage((ConfluenceService.Model.Page)dotPage.get(), content) : this.completeExceptionally(String.format("failed to store page with id %s", page.getId())));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        return this.getPage(page.getId()).thenCompose(dotPage -> dotPage.isPresent() ? this.delegate.storePage((ConfluenceService.Model.Page)dotPage.get()) : this.completeExceptionally(String.format("failed to store page with id %s", page.getId())));
    }

    @Override
    public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
        return this.delegate.getDescendents(this.getMasterPageId(pageId).get()).stream().filter(page -> this.isDotPage(page.getSpace(), page.getTitle())).skip(1L).collect(Collectors.toList());
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        String dotTitle = this.getPage(spaceKey, pageTitle).get().get().getTitle();
        this.delegate.exportPage(url, spaceKey, dotTitle, exfmt, outputFile);
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return this.delegate.createAttachment();
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(String pageId, String name, String version) {
        return ((CompletableFuture)this.getDotPageId(pageId).thenCompose(versionedPageId -> this.delegate.getAttachment((String)versionedPageId, name, version))).exceptionally(e -> Optional.empty());
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        return this.delegate.addAttachment(page, attachment, source);
    }

    @Override
    public void close() {
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> getOrCreatePage(String spaceKey, String parentPageTitle, String title) {
        return this.getPage(spaceKey, parentPageTitle).thenCompose(optionalParentPage -> {
            CompletableFuture futureResult = new CompletableFuture();
            if (!optionalParentPage.isPresent()) {
                String msg = String.format("no parent page found with title %s", parentPageTitle);
                return this.completeExceptionally(futureResult, msg);
            }
            return this.getPage(spaceKey, title).thenCompose(optionalPage -> {
                if (!optionalPage.isPresent()) {
                    return this.createPage((ConfluenceService.Model.Page)optionalParentPage.get(), title);
                }
                futureResult.complete(optionalPage.get());
                return futureResult;
            });
        });
    }

    private CompletableFuture<ConfluenceService.Model.Page> getCreatedPageAsync(Response response, String title) {
        CompletableFuture<ConfluenceService.Model.Page> result = new CompletableFuture<ConfluenceService.Model.Page>();
        try {
            String responseBody = response.body().string();
            ScrollVersionsNewPage scrollVersionsNewPage = (ScrollVersionsNewPage)this.objectMapper.readValue(responseBody, ScrollVersionsNewPage.class);
            this.delegate.retry(GET_CREATED_PAGE_MAX_RETRIES, GET_CREATED_PAGE_WAIT_MS, TimeUnit.MILLISECONDS, Optional.of(result), () -> {
                Long pageId = scrollVersionsNewPage.getConfluencePage().getId();
                return this.getPage(String.valueOf(pageId)).thenApply(Optional::get);
            });
        }
        catch (IOException e) {
            this.completeExceptionally(result, "error getting created page", e);
        }
        return result;
    }

    private CompletableFuture<String> getDotPageId(String pageId) {
        return this.delegate.getPage(pageId).thenCompose(optionalPage -> optionalPage.map(page -> this.getDotPageId(page.getSpace(), page.getTitle())).orElseGet(() -> this.completeExceptionally(String.format("no page found for id %s", pageId))));
    }

    private CompletableFuture<String> getDotPageId(String spaceKey, String pageTitle) {
        if (this.isDotPage(spaceKey, pageTitle)) {
            return this.delegate.getPage(spaceKey, pageTitle).thenCompose(optionalPage -> this.mapToPageId(spaceKey, pageTitle, (Optional<ConfluenceService.Model.Page>)optionalPage));
        }
        ScrollVersionsPageByTitle[] scrollVersionsPageByTitle = new ScrollVersionsPageByTitle[]{new ScrollVersionsPageByTitle(pageTitle)};
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment(spaceKey).build();
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.mapToJsonString(scrollVersionsPageByTitle));
        Request request = this.requestBuilder().url(httpUrl).post(body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture<String> future = new CompletableFuture<String>();
            ResponseBody responseBody = response.body();
            if (null == responseBody) {
                future.completeExceptionally(new ScrollVersionsException(String.format("could not retrieve content for page %s in space %s with version %s", pageTitle, spaceKey, this.scrollVersionsName)));
                return future;
            }
            try {
                String responseBodyString = responseBody.string();
                ScrollVersionsPage[] pages = (ScrollVersionsPage[])this.objectMapper.readValue(responseBodyString, ScrollVersionsPage[].class);
                Optional<String> optionalFutureVersionedPageId = Arrays.stream(pages).filter(scrollVersionsPage -> this.scrollVersionsName.equals(scrollVersionsPage.getTargetVersion().getName())).map(ScrollVersionsPage::getConfluencePageId).map(String::valueOf).findAny();
                if (optionalFutureVersionedPageId.isPresent()) {
                    future.complete(optionalFutureVersionedPageId.get());
                } else {
                    String msg = String.format("no page named %s found in space %s with version %s", pageTitle, spaceKey, this.scrollVersionsName);
                    this.completeExceptionally(future, msg);
                }
            }
            catch (IOException e) {
                String msg = String.format("could not interpret response for page named %s in space %s with version %s", pageTitle, spaceKey, this.scrollVersionsName);
                this.completeExceptionally(future, msg, e);
            }
            return future;
        });
    }

    CompletableFuture<String> getScrollVersionId(String spaceKey) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment(spaceKey).build();
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)REQUEST_BODY_GET_ALL_VERSIONED_PAGES);
        Request request = this.requestBuilder().url(httpUrl).post(body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture<String> futureResult = new CompletableFuture<String>();
            ResponseBody responseBody = response.body();
            if (null == responseBody) {
                futureResult.completeExceptionally(new ScrollVersionsException("could not retrieve versions info"));
                return futureResult;
            }
            try {
                String responseBodyString = responseBody.string();
                ScrollVersionsPage[] pages = (ScrollVersionsPage[])this.objectMapper.readValue(responseBodyString, ScrollVersionsPage[].class);
                Optional<String> optionalVersionId = Arrays.stream(pages).map(ScrollVersionsPage::getTargetVersion).filter(scrollVersionsTargetVersion -> this.scrollVersionsName.equals(scrollVersionsTargetVersion.getName())).map(ScrollVersionsTargetVersion::getVersionId).findAny();
                if (optionalVersionId.isPresent()) {
                    futureResult.complete(optionalVersionId.get());
                } else {
                    String msg = String.format("no version named %s found in space %s", this.scrollVersionsName, spaceKey);
                    this.completeExceptionally(futureResult, msg);
                }
            }
            catch (IOException e) {
                String msg = "could not interpret response";
                this.completeExceptionally(futureResult, "could not interpret response", e);
            }
            return futureResult;
        });
    }

    CompletableFuture<String> getMasterPageId(String pageId) {
        return this.getPage(pageId).thenCompose(optionalPage -> {
            CompletableFuture futureResult = new CompletableFuture();
            if (optionalPage.isPresent()) {
                ConfluenceService.Model.Page page = (ConfluenceService.Model.Page)optionalPage.get();
                ((CompletableFuture)this.getMasterPageTitle(page.getSpace(), page.getTitle()).thenCompose(masterPageTitle -> this.delegate.getPage(page.getSpace(), (String)masterPageTitle))).thenAccept(optionalMasterPage -> {
                    if (optionalMasterPage.isPresent()) {
                        futureResult.complete(((ConfluenceService.Model.Page)optionalMasterPage.get()).getId());
                    } else {
                        String msg = String.format("failed to retrieve master page for page %s in space %s with version %s", page.getTitle(), page.getSpace(), this.scrollVersionsName);
                        this.completeExceptionally(futureResult, msg);
                    }
                });
            } else {
                String msg = String.format("failed to retrieve master page for page id %s with version %s", pageId, this.scrollVersionsName);
                this.completeExceptionally(futureResult, msg);
            }
            return futureResult;
        });
    }

    private CompletableFuture<String> getMasterPageTitle(String spaceKey, String pageTitle) {
        if (!this.isDotPage(spaceKey, pageTitle)) {
            return this.delegate.getPage(spaceKey, pageTitle).thenCompose(optionalPage -> this.mapToPageId(spaceKey, pageTitle, (Optional<ConfluenceService.Model.Page>)optionalPage));
        }
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment(spaceKey).build();
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)REQUEST_BODY_GET_ALL_VERSIONED_PAGES);
        Request request = this.requestBuilder().url(httpUrl).post(body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture<String> futureResult = new CompletableFuture<String>();
            try {
                String responseBody = response.body().string();
                ScrollVersionsPage[] pages = (ScrollVersionsPage[])this.objectMapper.readValue(responseBody, ScrollVersionsPage[].class);
                Optional<String> optionalMasterPageTitle = Arrays.stream(pages).filter(page -> this.scrollVersionsName.equals(page.getTargetVersion().getName()) && spaceKey.equals(page.getSpaceKey()) && pageTitle.equals(page.getConfluencePageTitle())).map(ScrollVersionsPage::getScrollPageTitle).findAny();
                if (optionalMasterPageTitle.isPresent()) {
                    futureResult.complete(optionalMasterPageTitle.get());
                } else {
                    String msg = String.format("failed to retrieve page %s in space %s with version %s", pageTitle, spaceKey, this.scrollVersionsName);
                    this.completeExceptionally(futureResult, msg);
                }
            }
            catch (IOException e) {
                String msg = String.format("failed to retrieve page %s in space %s with version %s", pageTitle, spaceKey, this.scrollVersionsName);
                this.completeExceptionally(futureResult, msg, e);
            }
            return futureResult;
        });
    }

    boolean isDotPage(String spaceKey, String pageTitle) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment(spaceKey).build();
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)REQUEST_BODY_GET_ALL_VERSIONED_PAGES);
        Request request = this.requestBuilder().url(httpUrl).post(body).build();
        String responseBody = this.delegate.fromRequest(request, "isDotPage").body().string();
        return Arrays.stream((Object[])this.objectMapper.readValue(responseBody, ScrollVersionsPage[].class)).anyMatch(page -> this.scrollVersionsName.equals(page.getTargetVersion().getName()) && spaceKey.equals(page.getSpaceKey()) && pageTitle.equals(page.getConfluencePageTitle()));
    }

    CompletableFuture<String> mapToPageId(String spaceKey, String pageTitle, Optional<ConfluenceService.Model.Page> optionalPage) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        if (optionalPage.isPresent()) {
            future.complete(optionalPage.get().getId());
        } else {
            String msg = String.format("failed to retrieve page %s in space %s with version %s", pageTitle, spaceKey, this.scrollVersionsName);
            this.completeExceptionally(future, msg);
        }
        return future;
    }

    String mapToJsonString(Object object) {
        return this.objectMapper.writeValueAsString(object);
    }

    private CompletableFuture<ConfluenceService.Model.Page> updatePage(ConfluenceService.Model.Page parentPage, String title, String scrollVersionId) {
        return ((CompletableFuture)this.delegate.getPage(parentPage.getSpace(), title).thenCompose(optionalMasterPage -> optionalMasterPage.map(p -> CompletableFuture.completedFuture(p)).orElseGet(() -> this.completeExceptionally(String.format("failed to get master page with title %s in space %s", title, parentPage.getSpace()))))).thenCompose(masterPage -> {
            HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment("modify").addQueryParameter("masterPageId", masterPage.getId()).addEncodedQueryParameter("pageTitle", masterPage.getTitle()).addQueryParameter("versionId", scrollVersionId).addQueryParameter("changeType", CHANGE_TYPE_MODIFY_QUERY_PARAM).build();
            Request request = this.requestBuilder().url(httpUrl).post((RequestBody)new FormBody.Builder().build()).build();
            return this.delegate.fromRequestAsync(request).thenCompose(response -> this.getCreatedPageAsync((Response)response, title));
        });
    }

    @Deprecated
    <U> CompletableFuture<U> completeExceptionally(Throwable ex) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(ex);
        return completableFuture;
    }

    <U> CompletableFuture<U> completeExceptionally(String message) {
        CompletableFuture completableFuture = new CompletableFuture();
        return this.completeExceptionally(completableFuture, message);
    }

    <U> CompletableFuture<U> completeExceptionally(String message, Throwable ex) {
        CompletableFuture completableFuture = new CompletableFuture();
        return this.completeExceptionally(completableFuture, message, ex);
    }

    <T> CompletableFuture<T> completeExceptionally(CompletableFuture<T> future, String message) {
        future.completeExceptionally(new ScrollVersionsException(String.format(message, new Object[0])));
        return future;
    }

    <T> CompletableFuture<T> completeExceptionally(CompletableFuture<T> future, String message, Throwable e) {
        future.completeExceptionally(new ScrollVersionsException(String.format(message, new Object[0]), e));
        return future;
    }

    public class ScrollVersionsException
    extends Exception {
        public ScrollVersionsException(String message) {
            super(message);
        }

        public ScrollVersionsException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

