/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.xmlrpc;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.xmlrpc.Attachment;
import org.bsc.confluence.xmlrpc.Confluence;
import org.bsc.confluence.xmlrpc.Confluence2;
import org.bsc.confluence.xmlrpc.ConfluenceExportDecorator;
import org.bsc.confluence.xmlrpc.Page;
import org.bsc.confluence.xmlrpc.PageSummary;
import org.bsc.confluence.xmlrpc.ServerInfo;
import org.bsc.ssl.SSLCertificateInfo;

public class XMLRPCConfluenceServiceImpl
implements ConfluenceService {
    public final Confluence connection;
    public final ConfluenceService.Credentials credentials;

    public static XMLRPCConfluenceServiceImpl createInstanceDetectingVersion(String url, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        if (!sslInfo.isIgnore() && url.startsWith("https")) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslInfo.getSSLSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(sslInfo.getHostnameVerifier());
        }
        Confluence c = new Confluence(url, proxyInfo);
        c.login(credentials.username, credentials.password);
        ServerInfo info = c.getServerInfo();
        return new XMLRPCConfluenceServiceImpl(info.getMajorVersion() < 4 ? c : new Confluence2(c), credentials);
    }

    protected XMLRPCConfluenceServiceImpl(Confluence confluence, ConfluenceService.Credentials credentials) {
        if (confluence == null) {
            throw new IllegalArgumentException("confluence argument is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        this.connection = confluence;
        this.credentials = credentials;
    }

    @Override
    public void close() throws IOException {
        this.logout();
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
        if (parentPageId == null) {
            throw new IllegalArgumentException("parentPageId argument is null!");
        }
        if (title == null) {
            throw new IllegalArgumentException("title argument is null!");
        }
        List children = this.connection.getChildren(parentPageId);
        for (PageSummary pageSummary : children) {
            if (!title.equals(pageSummary.getTitle())) continue;
            return pageSummary;
        }
        return null;
    }

    private Page cast(ConfluenceService.Model.Page page) {
        if (page == null) {
            throw new IllegalArgumentException("page argument is null!");
        }
        if (!(page instanceof Page)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Page)page;
    }

    private Attachment cast(ConfluenceService.Model.Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment argument is null!");
        }
        if (!(attachment instanceof Attachment)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Attachment)attachment;
    }

    @Override
    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        Objects.requireNonNull(parentPage, "parentPage is null!");
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        try {
            ConfluenceService.Model.PageSummary pageSummary = this.findPageByTitle(parentPage.getId(), title);
            if (pageSummary != null) {
                this.connection.removePage(pageSummary.getId());
                result.complete(true);
            } else {
                result.complete(false);
            }
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title) {
        Page result = new Page(Collections.emptyMap());
        result.setSpace(parentPage.getSpace());
        result.setParentId(parentPage.getId());
        result.setTitle(title);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        if (page.getId() == null) {
            throw new IllegalStateException("PageId is null. Attachment cannot be added!");
        }
        Attachment a = this.cast(attachment);
        CompletableFuture<ConfluenceService.Model.Attachment> result = new CompletableFuture<ConfluenceService.Model.Attachment>();
        try (BufferedInputStream fis = new BufferedInputStream(source, 4096);){
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] readbuf = new byte[4096];
            while ((len = fis.read(readbuf)) == readbuf.length) {
                baos.write(readbuf, 0, len);
            }
            if (len > 0) {
                baos.write(readbuf, 0, len);
            }
            a.setPageId(page.getId());
            result.complete(this.connection.addAttachment(Long.parseLong(page.getId()), a, baos.toByteArray()));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        Page p = this.cast(page);
        CompletableFuture<ConfluenceService.Model.Page> result = new CompletableFuture<ConfluenceService.Model.Page>();
        try {
            result.complete(this.connection.storePage(p));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        if (content == null) {
            throw new IllegalArgumentException("content argument is null!");
        }
        Page p = this.cast(page);
        p.setContent(content.value);
        CompletableFuture<ConfluenceService.Model.Page> result = new CompletableFuture<ConfluenceService.Model.Page>();
        try {
            result.complete(this.connection.storePage(p));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    public boolean logout() {
        try {
            if (!this.connection.logout()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean addLabelByName(String label, long id) throws Exception {
        return this.connection.addLabelByName(label, id);
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return new Attachment();
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(String pageId, String name, String version) {
        CompletableFuture<Optional<ConfluenceService.Model.Attachment>> result = new CompletableFuture<Optional<ConfluenceService.Model.Attachment>>();
        try {
            result.complete(Optional.ofNullable(this.connection.getAttachment(pageId, name, version)));
        }
        catch (Exception e) {
            result.complete(Optional.empty());
        }
        return result;
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        CompletableFuture<Optional<ConfluenceService.Model.Page>> result = new CompletableFuture<Optional<ConfluenceService.Model.Page>>();
        try {
            result.complete(Optional.ofNullable(this.connection.getPage(spaceKey, pageTitle)));
        }
        catch (Exception e) {
            result.complete(Optional.empty());
        }
        return result;
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String pageId) {
        CompletableFuture<Optional<ConfluenceService.Model.Page>> result = new CompletableFuture<Optional<ConfluenceService.Model.Page>>();
        try {
            result.complete(Optional.ofNullable(this.connection.getPage(pageId)));
        }
        catch (Exception e) {
            result.complete(Optional.empty());
        }
        return result;
    }

    public String toString() {
        try {
            ServerInfo si = this.connection.getServerInfo();
            return String.format("Confluence version [%d.%d.%d-%s] development version [%b]", si.getMajorVersion(), si.getMinorVersion(), si.getPatchLevel(), si.getBuildId(), si.isDevelopmentBuild());
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @Override
    public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
        return this.connection.getDescendents(pageId);
    }

    @Override
    public CompletableFuture<Boolean> removePageAsync(String pageId) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            this.connection.removePage(pageId);
            future.complete(true);
        }
        catch (Exception e) {
            future.complete(false);
        }
        return future;
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(this, url);
        exporter.exportPage(spaceKey, pageTitle, exfmt, outputFile);
    }
}

