/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.bsc.confluence.model.Site;

public interface SiteFactory {

    public static interface Model {
        public Site createSiteFromModel();

        default public Site createFrom(File siteDescriptor) throws Exception {
            String ext;
            Objects.requireNonNull(siteDescriptor, "siteDescriptor is null!");
            switch (ext = Optional.ofNullable(FilenameUtils.getExtension((String)siteDescriptor.getName())).map(v -> v.toLowerCase()).orElse("")) {
                case "xml": {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    return (Site)unmarshaller.unmarshal(siteDescriptor);
                }
                case "yml": 
                case "yaml": {
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                    return (Site)mapper.readValue(siteDescriptor, Site.class);
                }
            }
            throw new IllegalArgumentException(String.format("file extension [%s] not supported! Currently only '.xml' and '.yaml' are valid", ext));
        }
    }

    public static interface Folder {
        public Site createSiteFromFolder();
    }
}

