/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bsc.confluence.FileExtension;
import org.bsc.confluence.model.Site;
import org.parboiled.common.StringUtils;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;

public abstract class ToConfluenceSerializer
implements Visitor {
    private int listLevel = 0;
    private HashMap<String, ReferenceNode> referenceNodes = new HashMap();
    private StringBuilder _buffer = new StringBuilder(512000);
    private final Stack<Node> nodeStack = new Stack();
    private static final Pattern patternUri = Pattern.compile("(?:(\\$\\{.+\\})\\^)?(.+)");
    final SpecialPanelProcessor specialPanelProcessor = new SpecialPanelProcessor();

    public static int extensions() {
        int EXT = 0;
        EXT |= 0x80;
        EXT |= 0x20;
        return EXT |= 0x200;
    }

    public static int[] lineAndColFromNode(String text, Node node) {
        int lastEOL = 0;
        int prevEOL = 0;
        int length = text.length();
        int pos = 0;
        int line = 0;
        int col = 0;
        int offset = node.getStartIndex();
        if (offset > length) {
            offset = length;
        }
        while (pos < length && (pos = text.indexOf(10, pos)) != -1) {
            prevEOL = lastEOL;
            lastEOL = pos;
            if (pos > offset) break;
            ++line;
            ++pos;
        }
        if (prevEOL < offset && lastEOL >= offset) {
            col = offset - prevEOL;
        }
        return new int[]{++line, col};
    }

    private static CompletableFuture<String> getFileName(String uri) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        try {
            URI uriObject = URI.create(uri);
            String scheme = uriObject.getScheme();
            if (scheme != null) {
                switch (scheme.toLowerCase()) {
                    case "classpath": {
                        result.completeExceptionally(new IllegalArgumentException("'classpath' scheme is not supported!"));
                        return result;
                    }
                    case "http": 
                    case "https": {
                        result.complete(uri);
                        return result;
                    }
                }
            }
            Path path = Paths.get(uriObject.getPath(), new String[0]);
            result.complete(path.getFileName().toString());
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private boolean isURL(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public String processImageUrl(String url) {
        if (this.isURL(url)) {
            return url;
        }
        Matcher m = patternUri.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("the URL [%s] is not valid!", url));
        }
        if (m.group(1) != null) {
            return url;
        }
        return (String)((CompletableFuture)ToConfluenceSerializer.getFileName(m.group(2)).thenApply(s -> this.isImagePrefixEnabled() ? "${page.title}^".concat((String)s) : s)).join();
    }

    public String toString() {
        return this._buffer.toString();
    }

    protected Optional<Site> getSite() {
        return Optional.empty();
    }

    protected boolean isImagePrefixEnabled() {
        return true;
    }

    protected Optional<String> getHomePageTitle() {
        return Optional.empty();
    }

    protected abstract void notImplementedYet(Node var1);

    protected StringBuilder bufferVisit(Consumer<Void> closure) {
        return this.bufferVisit(new StringBuilder(), closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder bufferVisit(StringBuilder _sb, Consumer<Void> closure) {
        StringBuilder _original = this._buffer;
        this._buffer = _sb;
        try {
            closure.accept(null);
        }
        finally {
            this._buffer = _original;
        }
        return _sb;
    }

    protected <T extends Node> void forEachChild(T node, FindPredicate<T> cb) {
        List children = node.getChildren();
        for (int index = 0; index < children.size(); ++index) {
            Node child = (Node)children.get(index);
            if (cb.f(child, node, index)) continue;
            return;
        }
    }

    protected <T extends Node> void visitChildren(T node) {
        for (Node child : node.getChildren()) {
            child.accept((Visitor)this);
        }
    }

    protected <T extends Node, R extends Node> boolean findByClass(T node, Class<R> clazz, FindPredicate<R> predicate) {
        Node child;
        boolean result = false;
        List children = node.getChildren();
        for (int index = 0; index < children.size() && !(result = clazz.isInstance(child = (Node)children.get(index)) && predicate.f((Node)clazz.cast(child), node, index) ? true : this.findByClass(child, clazz, predicate)); ++index) {
        }
        return result;
    }

    public void visit(RootNode rn) {
        for (ReferenceNode referenceNode : rn.getReferences()) {
            String ref = this.bufferVisit(p -> this.visitChildren(referenceNode)).toString();
            this.referenceNodes.put(ref, referenceNode);
        }
        this.visitChildren(rn);
    }

    public void visit(SuperNode sn) {
        this.visitChildren(sn);
    }

    public void visit(ParaNode pn) {
        this.visitChildren(pn);
        this._buffer.append('\n');
    }

    public void visit(HeaderNode hn) {
        this._buffer.append(String.format("\n\nh%s.", hn.getLevel()));
        this.visitChildren(hn);
        this._buffer.append("\n\n");
    }

    public void visit(BlockQuoteNode bqn) {
        String text = this.bufferVisit(p -> this.visitChildren(bqn)).toString();
        String[] lines = text.split("\n");
        if (lines.length == 1) {
            this._buffer.append('\n').append("bq. ").append(text).append('\n');
            return;
        }
        if (this.specialPanelProcessor.apply(bqn)) {
            return;
        }
        this._buffer.append('\n').append("{quote}").append('\n').append(text).append('\n').append("{quote}").append('\n');
    }

    public void visit(TextNode tn) {
        this._buffer.append(tn.getText());
    }

    public void visit(ExpLinkNode eln) {
        Optional<Site> site;
        this._buffer.append('[');
        this.visitChildren(eln);
        String url = eln.url;
        if (!this.isURL(url) && FileExtension.MARKDOWN.isExentionOf(url) && (site = this.getSite()).isPresent()) {
            String _uri1 = url;
            Optional<Site.Page> page = site.get().getHome().findPage(p -> _uri1.equals(String.valueOf(p.getRelativeUri())));
            if (page.isPresent()) {
                Optional<String> parentPageTitle = this.getHomePageTitle();
                url = parentPageTitle.isPresent() && !url.startsWith(parentPageTitle.get()) ? String.format("%s - %s", parentPageTitle.get(), page.get().getName()) : page.get().getName();
            }
        }
        this._buffer.append(String.format("|%s|%s]", url, eln.title));
    }

    public void visit(VerbatimNode vn) {
        String[] lines = vn.getText().split("\n");
        if (lines.length == 1) {
            this._buffer.append("\n{noformat}").append(vn.getText()).append("{noformat}\n\n");
            return;
        }
        if (vn.getType() == null || vn.getType().isEmpty()) {
            this._buffer.append("\n{noformat}\n").append(vn.getText()).append("\n{noformat}\n\n");
            return;
        }
        this._buffer.append(String.format("\n{code:%s}\n", vn.getType())).append(vn.getText()).append("\n{code}\n\n");
    }

    public void visit(CodeNode cn) {
        String text = cn.getText();
        String[] lines = text.split("\n");
        if (lines.length == 1) {
            this._buffer.append("{{").append(text.replace("{", "\\{").replace("}", "\\}")).append("}}");
            return;
        }
        this._buffer.append("\n{code}").append('\n').append(text).append("{code}").append('\n');
    }

    public void visit(StrongEmphSuperNode sesn) {
        String chars;
        char sym = '*';
        if (!sesn.isStrong() && (chars = sesn.getChars()).equals("_")) {
            sym = '_';
        }
        this._buffer.append(sym);
        this.visitChildren(sesn);
        this._buffer.append(sym);
    }

    public void visit(StrikeNode sn) {
        this._buffer.append("-");
        this.visitChildren(sn);
        this._buffer.append("-");
    }

    public void visit(ListItemNode lin) {
        this.visitChildren(lin);
    }

    public void visit(ExpImageNode ein) {
        ArrayList alt = new ArrayList();
        boolean found = this.findByClass(ein, TextNode.class, (node, parent, index) -> {
            alt.add(node.getText());
            return true;
        });
        String altText = found ? (String)alt.get(0) : "";
        String titlePart = ToConfluenceSerializer.isNotBlank(ein.title) ? String.format("title=\"%s\"", ein.title) : "";
        String url = this.processImageUrl(ein.url);
        this._buffer.append(String.format("!%s|%s!", url, altText, titlePart));
    }

    public void visit(RefImageNode rin) {
        String ref;
        ArrayList alt = new ArrayList();
        boolean found = this.findByClass(rin, TextNode.class, (node, parent, index) -> {
            alt.add(node.getText());
            return true;
        });
        String altText = found ? (String)alt.get(0) : "";
        SuperNode referenceKey = rin.referenceKey;
        String ref_url = ref = this.getRefString((SuperNode)rin, referenceKey);
        String title = null;
        ReferenceNode referenceNode = this.referenceNodes.get(ref);
        if (referenceNode != null) {
            if (ToConfluenceSerializer.isNotBlank(referenceNode.getUrl())) {
                ref_url = referenceNode.getUrl();
            }
            title = referenceNode.getTitle();
        }
        String url = this.processImageUrl(ref_url);
        String titlePart = ToConfluenceSerializer.isNotBlank(title) ? String.format("|title=\"%s\"", title) : "";
        this._buffer.append(String.format("!%s|%s!", url, altText, titlePart));
    }

    private String getRefString(SuperNode refnode, SuperNode referenceKey) {
        String ref = referenceKey != null ? this.bufferVisit(p -> this.visitChildren(referenceKey)).toString() : this.bufferVisit(p -> this.visitChildren(refnode)).toString();
        return ref;
    }

    private static boolean isNotBlank(String str) {
        return str != null && str.length() > 0;
    }

    public void visit(HtmlBlockNode hbn) {
    }

    public void visit(InlineHtmlNode ihn) {
    }

    public void visit(TableHeaderNode thn) {
        this.nodeStack.push((Node)thn);
        try {
            this.visitChildren(thn);
        }
        finally {
            assert (thn == this.nodeStack.pop());
        }
    }

    public void visit(TableBodyNode tbn) {
        this.nodeStack.push((Node)tbn);
        try {
            this.visitChildren(tbn);
        }
        finally {
            assert (tbn == this.nodeStack.pop());
        }
    }

    public void visit(TableRowNode trn) {
        Node n = this.nodeStack.peek();
        if (n instanceof TableHeaderNode) {
            this._buffer.append("||");
        } else if (n instanceof TableBodyNode) {
            this._buffer.append('|');
        }
        this.visitChildren(trn);
        this._buffer.append('\n');
    }

    public void visit(TableCaptionNode tcn) {
        this.notImplementedYet((Node)tcn);
    }

    public void visit(TableCellNode tcn) {
        Node n = this.nodeStack.peek();
        this.visitChildren(tcn);
        if (n instanceof TableHeaderNode) {
            this._buffer.append("||");
        } else if (n instanceof TableBodyNode) {
            this._buffer.append('|');
        }
    }

    public void visit(RefLinkNode rln) {
        Optional<String> parentPageTitle;
        String ref;
        this._buffer.append('[');
        this.visitChildren(rln);
        this._buffer.append('|');
        String url = ref = this.getRefString((SuperNode)rln, rln.referenceKey);
        ReferenceNode referenceNode = this.referenceNodes.get(ref);
        if (referenceNode != null && referenceNode.getUrl() != null && url.length() > 0) {
            url = referenceNode.getUrl();
        }
        if (!this.isURL(url) && (parentPageTitle = this.getHomePageTitle()).isPresent() && !url.startsWith(parentPageTitle.get())) {
            this._buffer.append(parentPageTitle.get()).append(" - ");
        }
        this._buffer.append(url);
        if (referenceNode != null && referenceNode.getTitle() != null) {
            this._buffer.append('|').append(referenceNode.getTitle());
        }
        this._buffer.append(']');
    }

    public void visit(TableColumnNode tcn) {
        this.notImplementedYet((Node)tcn);
    }

    public void visit(TableNode tn) {
        this.visitChildren(tn);
    }

    public void visit(AnchorLinkNode aln) {
        this._buffer.append(aln.getText());
    }

    public void visit(SpecialTextNode stn) {
        this._buffer.append(stn.getText());
    }

    public void visit(AbbreviationNode an) {
        this.notImplementedYet((Node)an);
    }

    public void visit(AutoLinkNode aln) {
        this.notImplementedYet((Node)aln);
    }

    public void visit(DefinitionListNode dln) {
        this.notImplementedYet((Node)dln);
    }

    public void visit(DefinitionNode dn) {
        this.notImplementedYet((Node)dn);
    }

    public void visit(DefinitionTermNode dtn) {
        this.notImplementedYet((Node)dtn);
    }

    public void visit(MailLinkNode mln) {
        this.notImplementedYet((Node)mln);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(OrderedListNode oln) {
        ++this.listLevel;
        try {
            this._buffer.append('\n');
            for (Node child : oln.getChildren()) {
                this._buffer.append(StringUtils.repeat((char)'#', (int)this.listLevel)).append(' ');
                child.accept((Visitor)this);
                this._buffer.append('\n');
            }
            this._buffer.append('\n');
        }
        finally {
            --this.listLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(BulletListNode bln) {
        ++this.listLevel;
        try {
            this._buffer.append('\n');
            for (Node child : bln.getChildren()) {
                this._buffer.append(StringUtils.repeat((char)'*', (int)this.listLevel)).append(' ');
                child.accept((Visitor)this);
                this._buffer.append('\n');
            }
            this._buffer.append('\n');
        }
        finally {
            --this.listLevel;
        }
    }

    public void visit(QuotedNode qn) {
        this.notImplementedYet((Node)qn);
    }

    public void visit(ReferenceNode rn) {
    }

    public void visit(SimpleNode sn) {
        switch (sn.getType()) {
            case HRule: {
                this._buffer.append("----\n");
                break;
            }
            case Linebreak: {
                this._buffer.append("\n");
                break;
            }
            case Nbsp: {
                this._buffer.append("&nbsp;");
                break;
            }
            case Emdash: {
                this._buffer.append("&mdash;");
                break;
            }
            case Endash: {
                this._buffer.append("&ndash;");
                break;
            }
            case Ellipsis: {
                this._buffer.append("&hellip;");
                break;
            }
            default: {
                this.notImplementedYet((Node)sn);
            }
        }
    }

    public void visit(WikiLinkNode wln) {
        this.notImplementedYet((Node)wln);
    }

    public void visit(Node node) {
        this.notImplementedYet(node);
    }

    protected class SpecialPanelProcessor {
        private String element;
        private String title;
        final FindPredicate<TextNode> isSpecialPanelText = (p, parent, index) -> {
            if (index != 0) {
                return false;
            }
            if ("note:".equalsIgnoreCase(p.getText())) {
                this.element = "note";
                return true;
            }
            if ("warning:".equalsIgnoreCase(p.getText())) {
                this.element = "warning";
                return true;
            }
            if ("info:".equalsIgnoreCase(p.getText())) {
                this.element = "info";
                return true;
            }
            if ("tip:".equalsIgnoreCase(p.getText())) {
                this.element = "tip";
                return true;
            }
            return false;
        };

        protected SpecialPanelProcessor() {
        }

        boolean apply(BlockQuoteNode bqn) {
            this.element = null;
            this.title = null;
            List children = bqn.getChildren();
            if (children.size() < 2) {
                return false;
            }
            boolean result = ToConfluenceSerializer.this.findByClass((Node)bqn.getChildren().get(0), StrongEmphSuperNode.class, new FindPredicate<StrongEmphSuperNode>(){

                @Override
                public boolean f(StrongEmphSuperNode p, Node parent, int index) {
                    if (index != 0 || !p.isStrong()) {
                        return false;
                    }
                    boolean found = ToConfluenceSerializer.this.findByClass(p, TextNode.class, SpecialPanelProcessor.this.isSpecialPanelText);
                    if (found) {
                        StringBuilder _sb = ToConfluenceSerializer.this.bufferVisit(param -> {
                            parent.getChildren().remove(0);
                            ToConfluenceSerializer.this.visitChildren(parent);
                        });
                        SpecialPanelProcessor.this.title = _sb.toString().trim();
                    }
                    return found;
                }
            });
            if (result) {
                ToConfluenceSerializer.this._buffer.append(String.format("\n{%s%s}\n", this.element, ToConfluenceSerializer.isNotBlank(this.title) ? ":title=" + this.title : ""));
                bqn.getChildren().remove(0);
                ToConfluenceSerializer.this.visitChildren(bqn);
                ToConfluenceSerializer.this._buffer.append(String.format("\n{%s}\n", this.element)).append('\n');
            }
            return result;
        }
    }

    protected static interface FindPredicate<T extends Node> {
        public boolean f(T var1, Node var2, int var3);
    }
}

