/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.preprocessor.SitePocessorService;

public interface SiteFactory {

    public static interface Model {
        public Site createSiteFromModel(Map<String, Object> var1);

        default public Site createFrom(File siteDescriptor, Map<String, Object> variables) throws Exception {
            if (variables == null) {
                throw new IllegalArgumentException("variables is null!");
            }
            String ext = Optional.ofNullable(FilenameUtils.getExtension((String)siteDescriptor.getName())).map(v -> v.toLowerCase()).orElse("");
            Function<String, CompletableFuture> _createSite = preprocessedDescriptor -> {
                CompletableFuture<Site> result = new CompletableFuture<Site>();
                switch (ext) {
                    case "xml": {
                        try {
                            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
                            Unmarshaller unmarshaller = jc.createUnmarshaller();
                            result.complete((Site)unmarshaller.unmarshal((Reader)new StringReader((String)preprocessedDescriptor)));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                        break;
                    }
                    case "yml": 
                    case "yaml": {
                        try {
                            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                            result.complete((Site)mapper.readValue(preprocessedDescriptor, Site.class));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                        break;
                    }
                    default: {
                        result.completeExceptionally(new IllegalArgumentException(String.format("file extension [%s] not supported! Currently only '.xml' and '.yaml' are valid", ext)));
                    }
                }
                return result;
            };
            String content = new String(Files.readAllBytes(siteDescriptor.toPath()), StandardCharsets.UTF_8);
            Optional<SitePocessorService> siteProcessor = SitePocessorService.getDefaultPreprocessorService();
            return (Site)siteProcessor.map(p -> p.process(content, variables).thenCompose(_createSite)).orElseGet(() -> {
                LogHolder.log.debug((Object)String.format("a Preprocessor service is not configurated", new Object[0]));
                return (CompletableFuture)_createSite.apply(content);
            }).get();
        }
    }

    public static interface Folder {
        public Site createSiteFromFolder();
    }

    public static final class LogHolder {
        private static final Log log = LogFactory.getLog(LogHolder.class);
    }
}

