/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import okhttp3.HttpUrl;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.CurrentThreadExecutor;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.AbstractRESTConfluenceService;
import org.bsc.confluence.rest.model.Attachment;
import org.bsc.confluence.rest.model.Page;
import org.bsc.confluence.xmlrpc.ConfluenceExportDecorator;
import org.bsc.ssl.SSLCertificateInfo;

public class RESTConfluenceServiceImpl
extends AbstractRESTConfluenceService
implements ConfluenceService {
    final ConfluenceService.Credentials credentials;
    final URL endpoint;

    public RESTConfluenceServiceImpl(String url, ConfluenceService.Credentials credentials, SSLCertificateInfo sslInfo) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        try {
            this.endpoint = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("url argument is not valid!", ex);
        }
        this.credentials = credentials;
        this.client.connectTimeout(10L, TimeUnit.SECONDS);
        this.client.writeTimeout(10L, TimeUnit.SECONDS);
        this.client.readTimeout(30L, TimeUnit.SECONDS);
        if (!sslInfo.isIgnore() && "https".equals(this.endpoint.getProtocol())) {
            this.client.hostnameVerifier(sslInfo.getHostnameVerifier()).sslSocketFactory(sslInfo.getSSLSocketFactory(), sslInfo.getTrustManager());
        }
    }

    private Attachment cast(ConfluenceService.Model.Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment argument is null!");
        }
        if (!(attachment instanceof Attachment)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Attachment)attachment;
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, String title) {
        return Json.createObjectBuilder().add("type", "page").add("title", title).add("space", Json.createObjectBuilder().add("key", spaceKey));
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, String parentPageId, String title) {
        return this.jsonForCreatingPage(spaceKey, Long.valueOf(parentPageId), title);
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, long parentPageId, String title) {
        return this.jsonForCreatingPage(spaceKey, title).add("ancestors", Json.createArrayBuilder().add(Json.createObjectBuilder().add("id", parentPageId)));
    }

    public final JsonObjectBuilder jsonAddBody(JsonObjectBuilder builder, ConfluenceService.Storage storage) {
        return builder.add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", storage.rapresentation.toString()).add("value", storage.value)));
    }

    @Override
    protected HttpUrl.Builder urlBuilder() {
        int port = this.endpoint.getPort();
        port = port > -1 ? port : this.endpoint.getDefaultPort();
        String path = this.endpoint.getPath();
        path = path.startsWith("/") ? path.substring(1) : path;
        return new HttpUrl.Builder().scheme(this.endpoint.getProtocol()).host(this.endpoint.getHost()).port(port).addPathSegments(path);
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
        return this.childrenPages(parentPageId).stream().map(Page::new).filter(page -> page.getTitle().equals(title)).findFirst().orElse(null);
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title) {
        String spaceKey = parentPage.getSpace();
        String id = parentPage.getId();
        JsonObjectBuilder input = this.jsonForCreatingPage(spaceKey, Integer.valueOf(id).intValue(), title);
        return CompletableFuture.supplyAsync(() -> this.createPage(input.build()).map(Page::new).get(), CurrentThreadExecutor.instance);
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String pageId) {
        return CompletableFuture.completedFuture(this.findPageById(pageId).map(Page::new));
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        return CompletableFuture.completedFuture(this.findPage(spaceKey, pageTitle).map(Page::new));
    }

    @Override
    public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
        return this.descendantPages(pageId).stream().map(page -> new Page((JsonObject)page)).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        int previousVersion = page.getVersion();
        JsonObject input = Json.createObjectBuilder().add("version", Json.createObjectBuilder().add("number", ++previousVersion)).add("id", page.getId()).add("type", "page").add("title", page.getTitle()).add("space", Json.createObjectBuilder().add("key", page.getSpace())).add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", content.rapresentation.toString()).add("value", content.value))).build();
        return CompletableFuture.supplyAsync(() -> this.updatePage(page.getId(), input).map(Page::new).get(), CurrentThreadExecutor.instance);
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        return CompletableFuture.completedFuture(page);
    }

    @Override
    public boolean addLabelByName(String label, long id) throws Exception {
        this.addLabels(String.valueOf(id), label);
        return true;
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(this, url);
        exporter.exportPage(spaceKey, pageTitle, exfmt, outputFile);
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return new Attachment();
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(String pageId, String name, String version) {
        Optional<ConfluenceService.Model.Attachment> att = this.getAttachment(pageId, name).stream().map(result -> new Attachment((JsonObject)result)).findFirst();
        return CompletableFuture.completedFuture(att);
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        Optional<ConfluenceService.Model.Attachment> att = this.addAttachment(page.getId(), this.cast(attachment), source).stream().map(result -> new Attachment((JsonObject)result)).findFirst();
        return CompletableFuture.completedFuture(att.get());
    }

    @Override
    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        return CompletableFuture.completedFuture(this.childrenPages(parentPage.getId()).stream().map(page -> new Page((JsonObject)page)).filter(page -> page.getTitle().equals(title)).map(page -> this.deletePageById(page.getId())).findFirst().orElse(false));
    }

    @Override
    public CompletableFuture<Boolean> removePageAsync(String pageId) {
        return CompletableFuture.completedFuture(this.deletePageById(pageId));
    }

    @Override
    public void close() throws IOException {
    }
}

