/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceUtils;
import org.bsc.confluence.rest.model.Attachment;
import org.bsc.confluence.rest.model.IdHelper;

public abstract class AbstractRESTConfluenceService
implements IdHelper {
    private static final String EXPAND = "space,version,container";
    protected final OkHttpClient.Builder client = new OkHttpClient.Builder();

    public abstract ConfluenceService.Credentials getCredentials();

    protected abstract HttpUrl.Builder urlBuilder();

    public CompletableFuture<Response> fromRequestAsync(Request req) {
        final CompletableFuture<Response> result = new CompletableFuture<Response>();
        this.client.build().newCall(req).enqueue(new Callback(){

            public void onResponse(Call call, Response res) throws IOException {
                if (!res.isSuccessful()) {
                    result.completeExceptionally(new ServiceException(String.format("error: %s\n%s", res.toString(), res.body().string()), res));
                    return;
                }
                result.complete(res);
            }

            public void onFailure(Call call, IOException e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public void fromRequest(Request req, String description, Consumer<Response> consumer) {
        try (Response res = this.client.build().newCall(req).execute();){
            if (!res.isSuccessful()) {
                throw new ServiceException(String.format("error: %s\n%s\n%s", description, res.toString(), res.body().string()), res);
            }
            consumer.accept(res);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    protected void fromUrlGET(HttpUrl url, String description, Consumer<Response> consumer) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).get().build();
        this.fromRequest(req, description, consumer);
    }

    protected void fromUrlDELETE(HttpUrl url, String description, Consumer<Response> consumer) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).url(url).delete().build();
        this.fromRequest(req, description, consumer);
    }

    protected void fromUrlPOST(HttpUrl url, RequestBody inputBody, String description, Consumer<Response> consumer) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).post(inputBody).build();
        this.fromRequest(req, description, consumer);
    }

    protected void fromUrlPUT(HttpUrl url, RequestBody inputBody, String description, Consumer<Response> consumer) {
        String credential = Credentials.basic((String)this.getCredentials().username, (String)this.getCredentials().password);
        Request req = new Request.Builder().header("Authorization", credential).header("X-Atlassian-Token", "nocheck").url(url).put(inputBody).build();
        this.fromRequest(req, description, consumer);
    }

    protected void debugBody(Response res) {
        ResponseBody body = res.body();
        try {
            System.out.printf("BODY\n%s\n", new String(body.bytes()));
        }
        catch (IOException e) {
            System.out.printf("READ BODY EXCEPTION\n%s\n", e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    protected Stream<JsonObject> mapToStream(Response res) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected JsonObject mapToObject(Response res) {
        JsonObject jsonObject;
        block8: {
            ResponseBody body = res.body();
            Reader r = body.charStream();
            try {
                JsonObject root;
                JsonReader rdr = Json.createReader((Reader)r);
                jsonObject = root = rdr.readObject();
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
            r.close();
        }
        return jsonObject;
    }

    protected CompletableFuture<Optional<JsonObject>> findPageById(String id) {
        CompletableFuture<Optional<JsonObject>> result = new CompletableFuture<Optional<JsonObject>>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addQueryParameter("expand", EXPAND).build();
        this.fromUrlGET(url, "find page", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).findFirst()));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> findPages(String spaceKey, String title) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addQueryParameter("spaceKey", spaceKey).addQueryParameter("title", title).addQueryParameter("expand", EXPAND).build();
        this.fromUrlGET(url, "find pages", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> descendantPages(long id) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(String.valueOf(id)).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        this.fromUrlGET(url, "get descendant pages", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).flatMap(o -> {
            long childId = IdHelper.getId(o);
            return Stream.concat(Stream.of(o), this.descendantPages(childId).join().stream());
        }).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> childrenPages(String id) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/page").addQueryParameter("expand", EXPAND).build();
        this.fromUrlGET(url, "get children pages", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    public CompletableFuture<Optional<JsonObject>> findPage(String spaceKey, String title) {
        return this.findPages(spaceKey, title).thenApply(list -> list.stream().findFirst());
    }

    protected CompletableFuture<Boolean> deletePageById(String id) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).build();
        this.fromUrlDELETE(url, "delete page", res -> result.complete(true));
        return result;
    }

    public final CompletableFuture<Optional<JsonObject>> createPage(JsonObject inputData) {
        CompletableFuture<Optional<JsonObject>> result = new CompletableFuture<Optional<JsonObject>>();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").build();
        this.fromUrlPOST(url, inputBody, "create page", res -> result.complete(Stream.of(res).map(this::mapToObject).findFirst()));
        return result;
    }

    protected CompletableFuture<Optional<JsonObject>> updatePage(String pageId, JsonObject inputData) {
        CompletableFuture<Optional<JsonObject>> result = new CompletableFuture<Optional<JsonObject>>();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(pageId).build();
        this.fromUrlPUT(url, inputBody, "update page", res -> result.complete(Stream.of(res).map(this::mapToObject).findFirst()));
        return result;
    }

    protected final CompletableFuture<Void> addLabels(String id, String ... labels) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        JsonArrayBuilder inputBuilder = Json.createArrayBuilder();
        for (String name : labels) {
            inputBuilder.add(Json.createObjectBuilder().add("prefix", "global").add("name", ConfluenceUtils.sanitizeLabel(name)));
        }
        JsonArray inputData = inputBuilder.build();
        MediaType storageFormat = MediaType.parse((String)"application/json");
        RequestBody inputBody = RequestBody.create((MediaType)storageFormat, (String)inputData.toString());
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegment("label").build();
        this.fromUrlPOST(url, inputBody, "add label", res -> result.complete(null));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> getAttachments(String id) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("expand", EXPAND).build();
        this.fromUrlGET(url, "get attachments", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> getAttachment(String id, String fileName) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        HttpUrl url = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment").addQueryParameter("filename", fileName).addQueryParameter("expand", EXPAND).build();
        this.fromUrlGET(url, "get attachment", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> addAttachment(String id, Attachment att, InputStream data) {
        RequestBody fileBody;
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        try {
            fileBody = RequestBody.create((MediaType)MediaType.parse((String)att.getContentType()), (byte[])IOUtils.toByteArray((InputStream)data));
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        MultipartBody inputBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("comment", att.getComment()).addFormDataPart("minorEdit", "true").addFormDataPart("file", att.getFileName(), fileBody).build();
        HttpUrl.Builder builder = this.urlBuilder().addPathSegment("content").addPathSegment(id).addPathSegments("child/attachment");
        if (att.getId() != null) {
            builder.addPathSegment(att.getId()).addPathSegment("data");
        }
        this.fromUrlPOST(builder.build(), (RequestBody)inputBody, "create attachment", res -> result.complete(Stream.of(res).flatMap(post -> att.getId() != null ? Stream.of(this.mapToObject((Response)post)) : this.mapToStream((Response)post)).collect(Collectors.toList())));
        return result;
    }

    public static class ServiceException
    extends Error {
        public final Response res;

        public ServiceException(String message, Response res) {
            super(message);
            this.res = res;
        }
    }
}

