/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.AbstractRESTConfluenceService;
import org.bsc.confluence.rest.model.Attachment;
import org.bsc.confluence.rest.model.Page;
import org.bsc.confluence.xmlrpc.ConfluenceExportDecorator;
import org.bsc.ssl.SSLCertificateInfo;

public class RESTConfluenceService
extends AbstractRESTConfluenceService
implements ConfluenceService {
    final ConfluenceService.Credentials credentials;
    final URL endpoint;

    public RESTConfluenceService(String url, ConfluenceService.Credentials credentials, SSLCertificateInfo sslInfo) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        try {
            this.endpoint = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("url argument is not valid!", ex);
        }
        this.credentials = credentials;
        this.client.connectTimeout(10L, TimeUnit.SECONDS);
        this.client.writeTimeout(10L, TimeUnit.SECONDS);
        this.client.readTimeout(30L, TimeUnit.SECONDS);
        if (!sslInfo.isIgnore() && "https".equals(this.endpoint.getProtocol())) {
            this.client.hostnameVerifier(sslInfo.getHostnameVerifier()).sslSocketFactory(sslInfo.getSSLSocketFactory(), sslInfo.getTrustManager());
        }
    }

    private Attachment cast(ConfluenceService.Model.Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment argument is null!");
        }
        if (!(attachment instanceof Attachment)) {
            throw new IllegalArgumentException("page argument is not right type!");
        }
        return (Attachment)attachment;
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, String title) {
        return Json.createObjectBuilder().add("type", "page").add("title", title).add("space", Json.createObjectBuilder().add("key", spaceKey));
    }

    public final JsonObjectBuilder jsonForCreatingPage(String spaceKey, long parentPageId, String title) {
        return this.jsonForCreatingPage(spaceKey, title).add("ancestors", Json.createArrayBuilder().add(Json.createObjectBuilder().add("id", parentPageId)));
    }

    public final JsonObjectBuilder jsonAddBody(JsonObjectBuilder builder, ConfluenceService.Storage storage) {
        return builder.add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", storage.rapresentation.toString()).add("value", storage.value)));
    }

    public final CompletableFuture<ConfluenceService.Model.Page> createPageByTitle(String spaceKey, String title) {
        JsonObjectBuilder input = this.jsonForCreatingPage(spaceKey, title);
        return this.createPage(input.build()).thenApply(data -> data.map(Page::new).get());
    }

    @Override
    protected HttpUrl.Builder urlBuilder() {
        int port = this.endpoint.getPort();
        port = port > -1 ? port : this.endpoint.getDefaultPort();
        String path = this.endpoint.getPath();
        path = path.startsWith("/") ? path.substring(1) : path;
        return new HttpUrl.Builder().scheme(this.endpoint.getProtocol()).host(this.endpoint.getHost()).port(port).addPathSegments(path);
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>> getPageByTitle(long parentPageId, String title) {
        return this.childrenPages(String.valueOf(parentPageId)).thenApply(children -> children.stream().map(Page::new).filter(page -> page.getTitle().equals(title)).findFirst());
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title) {
        String spaceKey = parentPage.getSpace();
        String id = parentPage.getId();
        JsonObjectBuilder input = this.jsonForCreatingPage(spaceKey, Integer.valueOf(id).intValue(), title);
        return this.createPage(input.build()).thenApply(page -> page.map(Page::new).get());
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(long pageId) {
        return this.findPageById(String.valueOf(pageId)).thenApply(page -> page.map(Page::new));
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        return this.findPage(spaceKey, pageTitle).thenApply(page -> page.map(Page::new));
    }

    @Override
    public CompletableFuture<List<ConfluenceService.Model.PageSummary>> getDescendents(long pageId) {
        return this.descendantPages(pageId).thenApply(descendant -> descendant.stream().map(page -> new Page((JsonObject)page)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        int previousVersion = page.getVersion();
        JsonObject input = Json.createObjectBuilder().add("version", Json.createObjectBuilder().add("number", ++previousVersion)).add("id", page.getId()).add("type", "page").add("title", page.getTitle()).add("space", Json.createObjectBuilder().add("key", page.getSpace())).add("body", Json.createObjectBuilder().add("storage", Json.createObjectBuilder().add("representation", content.rapresentation.toString()).add("value", content.value))).build();
        CompletionStage updatePage = this.updatePage(page.getId(), input).thenApply(p -> p.map(Page::new).get());
        return CompletableFuture.supplyAsync(() -> RESTConfluenceService.lambda$storePage$9((CompletableFuture)updatePage));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        return CompletableFuture.completedFuture(page);
    }

    @Override
    public CompletableFuture<Void> addLabelsByName(long id, String[] labels) {
        return CompletableFuture.runAsync(() -> this.addLabels(String.valueOf(id), labels));
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(this, url);
        exporter.exportPage(spaceKey, pageTitle, exfmt, outputFile);
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return new Attachment();
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(long pageId, String name, String version) {
        return this.getAttachment(String.valueOf(pageId), name).thenApply(attachments -> attachments.stream().findFirst().map(result -> new Attachment((JsonObject)result)));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        CompletionStage addAttchment = this.addAttachment(page.getId(), this.cast(attachment), source).thenApply(attachments -> attachments.stream().findFirst().map(result -> new Attachment((JsonObject)result)).get());
        return CompletableFuture.supplyAsync(() -> RESTConfluenceService.lambda$addAttachment$15((CompletableFuture)addAttchment));
    }

    @Override
    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        return this.childrenPages(parentPage.getId()).thenCompose(children -> children.stream().map(page -> new Page((JsonObject)page)).filter(page -> page.getTitle().equals(title)).map(page -> this.deletePageById(page.getId())).findFirst().orElse(CompletableFuture.completedFuture(false)));
    }

    @Override
    public CompletableFuture<Boolean> removePage(long pageId) {
        return this.deletePageById(String.valueOf(pageId));
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ ConfluenceService.Model.Attachment lambda$addAttachment$15(CompletableFuture addAttchment) {
        return (ConfluenceService.Model.Attachment)addAttchment.join();
    }

    private static /* synthetic */ ConfluenceService.Model.Page lambda$storePage$9(CompletableFuture updatePage) {
        return (ConfluenceService.Model.Page)updatePage.join();
    }

    static {
        Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);
    }
}

