/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bsc.markdown.MarkdownProcessor;
import org.bsc.markdown.MarkdownProcessorInfo;

public final class MarkdownProcessorProvider {
    public static final MarkdownProcessorProvider instance = new MarkdownProcessorProvider();
    private MarkdownProcessorInfo info = null;

    public void setInfo(MarkdownProcessorInfo info) {
        this.info = info;
    }

    public MarkdownProcessorInfo getInfo() {
        return this.info;
    }

    public Optional<MarkdownProcessorInfo> optInfo() {
        return Optional.ofNullable(this.info);
    }

    private MarkdownProcessorProvider() {
    }

    public MarkdownProcessor Load() {
        String name = (String)this.optInfo().flatMap(info -> info.optName()).orElseThrow(() -> new IllegalStateException("processor's name doesn't set!"));
        ServiceLoader<MarkdownProcessor> loader = ServiceLoader.load(MarkdownProcessor.class);
        Stream<MarkdownProcessor> processors = StreamSupport.stream(loader.spliterator(), false);
        return processors.filter(p -> name.equalsIgnoreCase(p.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Markdown processor [%s] not found!", name)));
    }
}

