/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bsc.confluence.FileExtension;
import org.bsc.confluence.model.Site;
import org.bsc.markdown.MarkdownParserContext;

public class MarkdownVisitorHelper {
    private static Pattern patternUri = Pattern.compile("(?:(\\$\\{.+\\})\\^)?(.+)");

    private static Optional<String> getFileName(String uri) {
        try {
            URI uriObject = URI.create(uri);
            String scheme = uriObject.getScheme();
            if (scheme != null) {
                switch (scheme.toLowerCase()) {
                    case "classpath": {
                        return Optional.empty();
                    }
                    case "http": 
                    case "https": {
                        return Optional.ofNullable(uri);
                    }
                }
            }
            Path path = Paths.get(uriObject.getPath(), new String[0]);
            return Optional.ofNullable(path.getFileName().toString());
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static String processImageUrl(String url, MarkdownParserContext<?> context) {
        if (MarkdownVisitorHelper.isURL(url)) {
            return url;
        }
        Matcher m = patternUri.matcher(url);
        if (!m.matches()) {
            return url;
        }
        if (m.group(1) != null) {
            return url;
        }
        return MarkdownVisitorHelper.getFileName(m.group(2)).map(fileName -> context.isLinkPrefixEnabled() ? "${page.title}^".concat((String)fileName) : fileName).orElse(url);
    }

    public static String processLinkUrl(String url, MarkdownParserContext<?> parseContext) {
        if (!MarkdownVisitorHelper.isURL(url) && FileExtension.MARKDOWN.isExentionOf(url)) {
            Predicate<Site.Page> comparePath = p -> {
                Path parentPath = Paths.get(parseContext.getPage().getUri()).getParent();
                Path relativePath = parentPath.relativize(Paths.get(p.getUri()));
                boolean result = relativePath.equals(Paths.get(url, new String[0]));
                return result;
            };
            return parseContext.getSite().flatMap(site -> site.getHome().findPage(comparePath)).map(page -> parseContext.getPagePrefixToApply().filter(prefixToApply -> !url.startsWith((String)prefixToApply)).map(prefixToApply -> String.format("%s - %s", prefixToApply, page.getName())).orElse(page.getName())).orElse(url);
        }
        return url;
    }
}

