/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.codec.digest.DigestUtils;

public class DeployStateManager {
    public static final String STORAGE_NAME = ".confluence-maven-plugin-storage.json";
    private Map<String, Map<String, JsonValue>> storage = new HashMap<String, Map<String, JsonValue>>();
    private final String endpoint;
    private final Path outdir;
    private final JsonWriterFactory writerFactory;

    private DeployStateManager(String endpoint, Path outdir) {
        Objects.requireNonNull(endpoint, "endpoint is null!");
        Objects.requireNonNull(outdir, "outdir is null!");
        if (!Files.exists(outdir, new LinkOption[0])) {
            try {
                Files.createDirectories(outdir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Impossible create path [%s]", outdir));
            }
        } else if (!Files.isDirectory(outdir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path [%s] is not a directory", outdir));
        }
        this.endpoint = endpoint;
        this.outdir = outdir;
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        this.writerFactory = Json.createWriterFactory(config);
    }

    public static DeployStateManager load(String endpoint, Path outdir) {
        DeployStateManager result = new DeployStateManager(endpoint, outdir);
        result.load();
        return result;
    }

    private void load() {
        Path file = Paths.get(this.outdir.toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            try (JsonReader r = Json.createReader((Reader)Files.newBufferedReader(file));){
                r.readObject().entrySet().forEach(e -> {
                    HashMap ss = new HashMap();
                    ((JsonObject)e.getValue()).entrySet().forEach(ee -> ss.put((String)ee.getKey(), (JsonValue)ee.getValue()));
                    this.storage.put((String)e.getKey(), ss);
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.storage.containsKey(this.endpoint)) {
            this.storage.put(this.endpoint, new HashMap());
            this.save();
        }
    }

    private void save() {
        Path file = Paths.get(this.outdir.toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        JsonObjectBuilder b = Json.createObjectBuilder();
        this.storage.entrySet().forEach(e -> {
            JsonObjectBuilder b1 = Json.createObjectBuilder();
            ((Map)e.getValue()).entrySet().forEach(ee -> b1.add((String)ee.getKey(), (JsonValue)ee.getValue()));
            b.add((String)e.getKey(), b1);
        });
        try (JsonWriter w = this.writerFactory.createWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
            w.writeObject(b.build());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JsonString createValue(String value) {
        return Json.createArrayBuilder().add(value).build().getJsonString(0);
    }

    public boolean isUpdated(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return Objects.nonNull(scheme) && "file".equalsIgnoreCase(scheme) ? this.isUpdated(Paths.get(uri)) : true;
    }

    public boolean isUpdated(Path file) {
        String lastStoredFileMd5Hash;
        if (file == null) {
            return false;
        }
        Path b = file.toAbsolutePath();
        Map<String, JsonValue> s = this.storage.get(this.endpoint);
        if (s == null) {
            return true;
        }
        String key = this.outdir.relativize(b).toString();
        JsonString value = s.containsKey(key) ? (JsonString)s.get(key) : this.createValue("0");
        String fileMd5Hash = DeployStateManager.md5Hash(file);
        if (!Objects.equals(fileMd5Hash, lastStoredFileMd5Hash = value.getString())) {
            s.put(key, (JsonValue)this.createValue(fileMd5Hash));
            this.save();
            return true;
        }
        return false;
    }

    private static String md5Hash(Path file) {
        String string;
        FileInputStream fis = new FileInputStream(file.toFile());
        try {
            string = DigestUtils.md5Hex((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        fis.close();
        return string;
    }

    public boolean resetState(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return Objects.nonNull(scheme) && "file".equalsIgnoreCase(scheme) ? this.resetState(Paths.get(uri)) : false;
    }

    public boolean resetState(Path file) {
        if (file == null) {
            return false;
        }
        Path b = file.toAbsolutePath();
        Map<String, JsonValue> s = this.storage.get(this.endpoint);
        String key = this.outdir.relativize(b).toString();
        s.put(key, (JsonValue)this.createValue("0"));
        this.save();
        return true;
    }

    public String toString() {
        return "DeployStateManager" + "\n\t" + "endopint=" + this.endpoint + "\n\t" + "outdir=" + this.outdir + "\n";
    }
}

