/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.xmlrpc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceUtils;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.xmlrpc.Confluence;
import org.bsc.confluence.xmlrpc.Confluence2;
import org.bsc.confluence.xmlrpc.ConfluenceExportDecorator;
import org.bsc.confluence.xmlrpc.TrySupplier;
import org.bsc.confluence.xmlrpc.model.Attachment;
import org.bsc.confluence.xmlrpc.model.BlogEntry;
import org.bsc.confluence.xmlrpc.model.Page;
import org.bsc.confluence.xmlrpc.model.ServerInfo;
import org.bsc.ssl.SSLCertificateInfo;

public class XMLRPCConfluenceService
implements ConfluenceService {
    public final Confluence connection;
    public final ConfluenceService.Credentials credentials;

    public static XMLRPCConfluenceService createInstanceDetectingVersion(String url, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("url argument is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        if (sslInfo == null) {
            throw new IllegalArgumentException("sslInfo argument is null!");
        }
        if (!sslInfo.isIgnore() && url.startsWith("https")) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslInfo.getSSLSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(sslInfo.getHostnameVerifier());
        }
        Confluence c = new Confluence(url, proxyInfo);
        c.login(credentials.username, credentials.password);
        ServerInfo info = c.getServerInfo();
        return new XMLRPCConfluenceService(info.getMajorVersion() < 4 ? c : new Confluence2(c), credentials);
    }

    protected XMLRPCConfluenceService(Confluence confluence, ConfluenceService.Credentials credentials) {
        if (confluence == null) {
            throw new IllegalArgumentException("confluence argument is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials argument is null!");
        }
        this.connection = confluence;
        this.credentials = credentials;
    }

    @Override
    public void close() throws IOException {
        this.logout();
    }

    @Override
    public ConfluenceService.Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>> getPageByTitle(ConfluenceService.Model.ID parentPageId, String title) {
        if (title == null) {
            throw new IllegalArgumentException("title argument is null!");
        }
        CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>> result = new CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>>();
        try {
            List children = this.connection.getChildren(String.valueOf(parentPageId));
            Optional<ConfluenceService.Model.PageSummary> value = children.stream().filter(pageSummary -> title.equals(pageSummary.getTitle())).map(pageSummary -> pageSummary).findFirst();
            result.complete(value);
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private <T> CompletableFuture<T> toFuture(TrySupplier<T> s) {
        CompletableFuture<T> result = new CompletableFuture<T>();
        try {
            result.complete(s.get());
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private <T> CompletableFuture<T> toFuture(TrySupplier<T> s, Supplier<T> onExceptionReturn) {
        CompletableFuture<T> result = new CompletableFuture<T>();
        try {
            result.complete(s.get());
        }
        catch (Exception e) {
            result.complete(onExceptionReturn.get());
        }
        return result;
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title, ConfluenceService.Storage content) {
        Page result = new Page(Collections.emptyMap());
        result.setSpace(parentPage.getSpace());
        result.setParentId(parentPage.getId());
        result.setTitle(title);
        result.setContent(content.value);
        return this.storePage(result);
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        return this.toFuture(() -> this.connection.storePage((Page)Page.class.cast(page)));
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        if (content == null) {
            throw new IllegalArgumentException("content argument is null!");
        }
        Page p = (Page)Page.class.cast(page);
        p.setContent(content.value);
        return this.toFuture(() -> this.connection.storePage(p));
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        return this.toFuture(() -> Optional.ofNullable(this.connection.getPage(spaceKey, pageTitle)), () -> Optional.empty());
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(ConfluenceService.Model.ID pageId) {
        return this.toFuture(() -> Optional.ofNullable(this.connection.getPage(pageId.toString())), () -> Optional.empty());
    }

    @Override
    public CompletableFuture<List<ConfluenceService.Model.PageSummary>> getDescendents(ConfluenceService.Model.ID pageId) {
        return this.toFuture(() -> this.connection.getDescendents(pageId.toString()));
    }

    @Override
    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        Objects.requireNonNull(parentPage, "parentPage is null!");
        return this.getPageByTitle(parentPage.getId(), title).thenCompose(page -> page.isPresent() ? this.removePage(((ConfluenceService.Model.PageSummary)page.get()).getId()) : CompletableFuture.completedFuture(false));
    }

    @Override
    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.ID pageId) {
        return this.toFuture(() -> {
            this.connection.removePage(pageId.toString());
            return true;
        }, () -> false);
    }

    @Override
    public CompletableFuture<Void> addLabelsByName(ConfluenceService.Model.ID id, String[] labels) {
        return CompletableFuture.runAsync(() -> Arrays.asList(labels).forEach(label -> {
            try {
                this.connection.addLabelByName(ConfluenceUtils.sanitizeLabel(label), id.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    @Override
    public ConfluenceService.Model.Attachment createAttachment() {
        return new Attachment();
    }

    @Override
    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(ConfluenceService.Model.ID pageId, String name, String version) {
        return this.toFuture(() -> Optional.ofNullable(this.connection.getAttachment(String.valueOf(pageId), name, version)), () -> Optional.empty());
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        if (page.getId() == null) {
            throw new IllegalStateException("PageId is null. Attachment cannot be added!");
        }
        return this.toFuture(() -> this.connection.addAttachment(page.getId().getValue(), (Attachment)Attachment.class.cast(attachment), IOUtils.toByteArray((InputStream)source)));
    }

    @Override
    public ConfluenceService.Model.Blogpost createBlogpost(String space, String title, ConfluenceService.Storage content, int version) {
        BlogEntry result = new BlogEntry();
        result.setSpace(space);
        result.setTitle(title);
        result.setVersion(version);
        result.setContent(content.value);
        return result;
    }

    @Override
    public CompletableFuture<ConfluenceService.Model.Blogpost> addBlogpost(ConfluenceService.Model.Blogpost blogpost) {
        return this.toFuture(() -> this.connection.storeBlogEntry((BlogEntry)BlogEntry.class.cast(blogpost)));
    }

    public boolean logout() {
        try {
            if (!this.connection.logout()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
        ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(this, url);
        exporter.exportPage(spaceKey, pageTitle, exfmt, outputFile);
    }

    public String toString() {
        try {
            ServerInfo si = this.connection.getServerInfo();
            return String.format("Confluence version [%d.%d.%d-%s] development version [%b]", si.getMajorVersion(), si.getMinorVersion(), si.getPatchLevel(), si.getBuildId(), si.isDevelopmentBuild());
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }
}

