/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown;

import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bsc.markdown.MarkdownParserContext;

public interface MarkdownProcessor {
    public static final Shared shared = new Shared();

    public String getName();

    public String processMarkdown(MarkdownParserContext var1, String var2) throws IOException;

    default public String processMarkdown(String content) throws IOException {
        return this.processMarkdown(new MarkdownParserContext(){}, content);
    }

    public static MarkdownProcessor load(String name) {
        ServiceLoader<MarkdownProcessor> loader = ServiceLoader.load(MarkdownProcessor.class);
        Stream<MarkdownProcessor> processors = StreamSupport.stream(loader.spliterator(), false);
        return processors.filter(p -> name.equalsIgnoreCase(p.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Markdown processor [%s] not found!", name)));
    }

    public static class Shared {
        private String name = "pegdown";

        public String getName() {
            return Optional.ofNullable(MarkdownProcessor.shared.name).orElseThrow(() -> new IllegalStateException("processor's name doesn't set!"));
        }

        public void setName(String value) {
            this.name = value;
        }

        public MarkdownProcessor load() {
            return MarkdownProcessor.load(this.getName());
        }
    }
}

