/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.FileExtension;
import org.bsc.confluence.model.Site;
import org.bsc.markdown.MarkdownParserContext;
import org.bsc.markdown.MarkdownProcessor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SiteProcessor {
    public static <T> T processUri(URI uri, BiFunction<Optional<Exception>, Optional<InputStream>, T> callback) {
        Objects.requireNonNull(uri, "uri is null!");
        Objects.requireNonNull(callback, "callback is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        InputStream result = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                result = cl.getResourceAsStream(source);
                Exception ex = new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        } else {
            try {
                URL url = uri.toURL();
                result = url.openStream();
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening url [%s]!", source), e);
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        }
        return callback.apply(Optional.empty(), Optional.of(result));
    }

    public static <P extends Site.Page> CompletableFuture<PageContent> processPageUri(Site site, P child, Optional<ConfluenceService.Model.Page> page, URI uri, Optional<String> pagePrefixToApply) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        CompletableFuture<PageContent> result = new CompletableFuture<PageContent>();
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        String content = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(source);
            if (is == null) {
                cl = Site.class.getClassLoader();
                is = cl.getResourceAsStream(source);
                if (is == null) {
                    result.completeExceptionally(new Exception(String.format("page [%s] doesn't exist in classloader", source)));
                    return result;
                }
                try {
                    String candidateContent = IOUtils.toString((InputStream)is);
                    content = isMarkdown ? SiteProcessor.processMarkdown(site, child, page, candidateContent, pagePrefixToApply) : candidateContent;
                }
                catch (IOException e) {
                    result.completeExceptionally(new Exception(String.format("error processing markdown for page [%s] ", source)));
                    return result;
                }
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                String candidateContent = IOUtils.toString((InputStream)is);
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, page, candidateContent, pagePrefixToApply) : candidateContent;
            }
            catch (IOException e) {
                result.completeExceptionally(new Exception(String.format("error opening/processing page [%s]!", source), e));
                return result;
            }
        }
        result.complete(PageContent.of(content, representation));
        return result;
    }

    public static <T, P extends Site.Page> T processUriContent(Site site, P child, URI uri, Optional<String> homePageTitle, Function<PageContent, T> onSuccess) throws Exception {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        String content = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(source);
            if (is == null) {
                cl = Site.class.getClassLoader();
                is = cl.getResourceAsStream(source);
                if (is == null) {
                    throw new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                }
                String candidateContent = IOUtils.toString((InputStream)is);
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, Optional.empty(), candidateContent, homePageTitle) : candidateContent;
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                String candidateContent = IOUtils.toString((InputStream)is);
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, Optional.empty(), candidateContent, homePageTitle) : candidateContent;
            }
            catch (IOException e) {
                throw new Exception(String.format("error opening url [%s]!", source), e);
            }
        }
        return onSuccess.apply(PageContent.of(content, representation));
    }

    public static String processMarkdown(final Site site, final Site.Page child, final Optional<ConfluenceService.Model.Page> page, String content, final Optional<String> pagePrefixToApply) throws IOException {
        return MarkdownProcessor.shared.processMarkdown(new MarkdownParserContext(){

            @Override
            public Optional<Site> getSite() {
                return Optional.of(site);
            }

            @Override
            public Optional<Site.Page> getPage() {
                return Optional.of(child);
            }

            @Override
            public Optional<String> getPagePrefixToApply() {
                return pagePrefixToApply;
            }

            @Override
            public boolean isLinkPrefixEnabled() {
                if (child.isIgnoreVariables().booleanValue()) {
                    return false;
                }
                return page.map(p -> !p.getTitle().contains("[")).orElse(true);
            }
        }, content);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class PageContent {
        private final String content;
        private final ConfluenceService.Storage.Representation type;

        public InputStream getInputStream() {
            return IOUtils.toInputStream((String)this.content);
        }

        public InputStream getInputStream(Charset charset) throws IOException {
            return IOUtils.toInputStream((String)this.content, (String)charset.toString());
        }

        public String getContent(Charset charset) {
            if (charset != Charset.defaultCharset()) {
                return new String(this.content.getBytes(Charset.defaultCharset()), charset);
            }
            return this.content;
        }

        private PageContent(String content, ConfluenceService.Storage.Representation type) {
            this.content = content;
            this.type = type;
        }

        public static PageContent of(String content, ConfluenceService.Storage.Representation type) {
            return new PageContent(content, type);
        }

        public String getContent() {
            return this.content;
        }

        public ConfluenceService.Storage.Representation getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageContent)) {
                return false;
            }
            PageContent other = (PageContent)o;
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            ConfluenceService.Storage.Representation this$type = this.getType();
            ConfluenceService.Storage.Representation other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            ConfluenceService.Storage.Representation $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "SiteProcessor.PageContent(content=" + this.getContent() + ", type=" + this.getType() + ")";
        }
    }
}

