/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest.model;

import java.util.Optional;
import javax.json.JsonObject;
import javax.json.JsonValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface IdHelper {
    public static long getId(JsonObject o) {
        JsonValue value = (JsonValue)o.get((Object)"id");
        switch (value.getValueType()) {
            case NUMBER: {
                return Optional.ofNullable(o.getJsonNumber("id")).map(n -> n.longValue()).orElseThrow(() -> new IllegalArgumentException("id not found in object!"));
            }
            case STRING: {
                return Optional.ofNullable(o.getString("id")).map(s -> Long.valueOf(s)).orElseThrow(() -> new IllegalArgumentException("id not found in object!"));
            }
        }
        throw new IllegalArgumentException(String.format("wrong type for 'id' - %s", value.getValueType()));
    }
}

