/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.xmlrpc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConfluenceExportDecorator {
    final ConfluenceService confluence;
    final String url;

    public ConfluenceExportDecorator(ConfluenceService confluence, String url) {
        assert (url != null);
        assert (confluence != null);
        if (confluence == null) {
            throw new IllegalArgumentException("confluence is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null!");
        }
        this.confluence = confluence;
        this.url = url;
    }

    public final void exportPage(String space, String pageTitle, ExportFormat format, File outputFile) {
        assert (space != null);
        assert (pageTitle != null);
        assert (format != null);
        assert (outputFile != null);
        if (space == null) {
            throw new IllegalArgumentException("space is null!");
        }
        if (pageTitle == null) {
            throw new IllegalArgumentException("pageTitle is null!");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null!");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile is null!");
        }
        if (outputFile.exists() && !outputFile.isFile()) {
            throw new IllegalArgumentException("outputFile is not a file!");
        }
        ((CompletableFuture)this.confluence.getPage(space, pageTitle).thenAccept(p -> {
            ConfluenceService.Model.Page page = (ConfluenceService.Model.Page)p.orElseThrow(() -> new RuntimeException(String.format("page [%s] not found!", pageTitle)));
            HttpClient client = new HttpClient();
            client.getParams().setCookiePolicy("compatibility");
            this.login(client, String.format("%s?pageId=%s", format.url, page.getId()), location -> {
                URI uri = URI.create(this.url).resolve(location).normalize();
                System.out.printf("==> EXPORT URL [%s]\n", uri.toString());
                this.exportpdf(client, uri.toURL(), outputFile);
            });
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private void login(HttpClient client, String redirectUrl, RedirectTask task) {
        block8: {
            PostMethod post = null;
            try {
                String login = String.format("%s/%s", this.url, "login.action");
                post = new PostMethod(login);
                post.setDoAuthentication(true);
                post.addParameter("os_username", this.confluence.getCredentials().username);
                post.addParameter("os_password", this.confluence.getCredentials().password);
                post.addParameter("os_destination", redirectUrl);
                post.addParameter("login", "Log+In");
                int statusCode = client.executeMethod((HttpMethod)post);
                if (statusCode != 200 && statusCode != 302) {
                    throw new HttpException(String.format("Execute ethod failed: [%s]", String.valueOf(post.getStatusLine())));
                }
                Header locationHeader = post.getResponseHeader("Location");
                if (locationHeader != null) {
                    String redirectLocation = locationHeader.getValue();
                    task.exec(redirectLocation);
                    break block8;
                }
                throw new HttpException(String.format("no redirect to url found\n[%s]", new String(post.getResponseBody())));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportpdf(HttpClient client, URL url, File outputFile) throws IOException {
        InputStream is = null;
        FileOutputStream fos = null;
        GetMethod get = null;
        try {
            get = new GetMethod(url.toString());
            get.setRequestHeader("X-Atlassian-Token", "no-check");
            int statusCode = client.executeMethod((HttpMethod)get);
            if (statusCode != 200) {
                throw new HttpException(String.format("Execute ethod failed: [%s]", String.valueOf(get.getStatusLine())));
            }
            is = get.getResponseBodyAsStream();
            fos = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(fos);
            if (get != null) {
                get.releaseConnection();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)fos);
        if (get != null) {
            get.releaseConnection();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface RedirectTask {
        public void exec(String var1) throws Exception;
    }
}

