/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown;

import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bsc.markdown.MarkdownParserContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface MarkdownProcessor {
    public static final Shared shared = new Shared();

    public String getName();

    public String processMarkdown(MarkdownParserContext var1, String var2) throws IOException;

    default public String processMarkdown(String content) throws IOException {
        return this.processMarkdown(new MarkdownParserContext(){}, content);
    }

    public static MarkdownProcessor load(String name) {
        ServiceLoader<MarkdownProcessor> loader = ServiceLoader.load(MarkdownProcessor.class);
        Stream<MarkdownProcessor> processors = StreamSupport.stream(loader.spliterator(), false);
        return processors.filter(p -> name.equalsIgnoreCase(p.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Markdown processor [%s] not found!", name)));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Shared
    implements MarkdownProcessor {
        private String name = "commonmark";
        private MarkdownProcessor processor;

        @Override
        public String getName() {
            return Optional.ofNullable(Shared.shared.name).orElseThrow(() -> new IllegalStateException("processor's name doesn't set!"));
        }

        @Override
        public String processMarkdown(MarkdownParserContext context, String content) throws IOException {
            return Optional.ofNullable(this.processor).orElseThrow(() -> new IllegalStateException("processor has not been initialized yet!")).processMarkdown(context, content);
        }

        public void setName(String value) {
            this.name = Optional.ofNullable(value).orElseThrow(() -> new IllegalArgumentException("processor's name cannot be null!"));
        }

        public MarkdownProcessor init() {
            if (this.processor != null) {
                throw new IllegalStateException("processor's is already initialized!");
            }
            this.processor = MarkdownProcessor.load(this.getName());
            return this.processor;
        }
    }
}

