/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.bsc.confluence.model.ChildListProxy;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@XmlRootElement(name="site", namespace="https://github.com/bsorrentino/maven-confluence-plugin")
public class Site {
    public static final String NAMESPACE = "https://github.com/bsorrentino/maven-confluence-plugin";
    protected static final Stack<Site> _SITE = new Stack();
    private String spaceKey;
    private transient Optional<Path> _basedir = Optional.empty();
    @XmlAttribute(name="label")
    public List<String> labels = new ArrayList<String>();
    Home home;

    public Site() {
        _SITE.push(this);
    }

    @XmlAttribute(name="space-key")
    public final String getSpaceKey() {
        return this.spaceKey;
    }

    public final Optional<String> optSpaceKey() {
        return Optional.ofNullable(this.spaceKey);
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @XmlTransient
    public void setBasedir(Path basedir) {
        this._basedir = Optional.ofNullable(basedir).map(p -> Files.isDirectory(p, new LinkOption[0]) ? Paths.get(p.toString(), new String[0]) : Paths.get(p.getParent().toString(), new String[0]));
    }

    public Path getBasedir() {
        return this._basedir.orElseThrow(() -> new IllegalStateException("basedir is not set!"));
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabel(String label) {
        this.labels.add(label);
    }

    @XmlElement(name="home", required=true)
    public Home getHome() {
        return this.home;
    }

    public void setHome(Home home) {
        this.home = home;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @XmlType(name="home", namespace="https://github.com/bsorrentino/maven-confluence-plugin")
    public static class Home
    extends Page {
        private String parentPageTitle;
        private String parentPageId;

        public String getParentPageTitle() {
            return this.parentPageTitle;
        }

        @Deprecated
        @XmlAttribute(name="parent-page")
        public void setParentPageTitleDeperecated(String parentPageTitle) {
            this.parentPageTitle = parentPageTitle;
        }

        @XmlAttribute(name="parentPage")
        public void setParentPageTitle(String parentPageTitle) {
            this.parentPageTitle = parentPageTitle;
        }

        public final Optional<String> optParentPageTitle() {
            return Optional.ofNullable(this.parentPageTitle);
        }

        public String getParentPageId() {
            return this.parentPageId;
        }

        @XmlAttribute(name="parent-page-id")
        public void setParentPageIdDeprecated(String parentPageId) {
            this.parentPageId = parentPageId;
        }

        @XmlAttribute(name="parentPageId")
        public void setParentPageId(String parentPageId) {
            this.parentPageId = parentPageId;
        }

        public final Optional<String> optParentPageId() {
            return Optional.ofNullable(this.parentPageId);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @XmlType(name="page", namespace="https://github.com/bsorrentino/maven-confluence-plugin")
    public static class Page
    extends Source {
        private Page parent;
        @XmlAttribute(name="label")
        public List<String> labels = new ArrayList<String>();
        @XmlAttribute(name="child")
        public List<Page> children = ChildListProxy.newInstance(this);
        @XmlAttribute(name="attachment")
        public List<Attachment> attachments = new ArrayList<Attachment>();
        boolean ignoreVariables = false;
        @XmlElement(name="generated")
        protected List<Generated> generateds;

        @XmlTransient
        public final void setParent(Page p) {
            this.parent = p;
        }

        public final Page getParent() {
            return this.parent;
        }

        @XmlTransient
        public final List<String> getComputedLabels() {
            List<String> _labels;
            if (this.site != null && (_labels = this.site.getLabels()) != null && !_labels.isEmpty()) {
                _labels = new ArrayList<String>(_labels);
                _labels.addAll(this.getLabels());
                return _labels;
            }
            return this.getLabels();
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public void setLabel(String label) {
            this.labels.add(label);
        }

        public List<Page> getChildren() {
            return this.children;
        }

        public void setChild(Page child) {
            this.children.add(child);
        }

        public List<Attachment> getAttachments() {
            return this.attachments;
        }

        public void setAttachment(Attachment attachment) {
            this.attachments.add(attachment);
        }

        public URI getUri(String ext) {
            if (this.getUri() == null) {
                if (this.getName() == null) {
                    throw new IllegalStateException("name is null");
                }
                this.setUri(this.site.getBasedir().toUri().resolve(this.getName().concat(ext)));
            }
            return this.getUri();
        }

        public Boolean isIgnoreVariables() {
            return this.ignoreVariables;
        }

        @XmlAttribute(name="ignore-variables")
        @Deprecated
        public void setIgnoreVariablesDeprecated(Boolean value) {
            this.ignoreVariables = Optional.ofNullable(value).orElse(false);
        }

        @XmlAttribute(name="ignoreVariables")
        public void setIgnoreVariables(Boolean value) {
            this.ignoreVariables = Optional.ofNullable(value).orElse(false);
        }

        public List<Generated> getGenerateds() {
            if (this.generateds == null) {
                this.generateds = new ArrayList<Generated>();
            }
            return this.generateds;
        }

        public Optional<Page> findPage(Predicate<Page> criteria) {
            if (criteria.test(this)) {
                return Optional.of(this);
            }
            for (Page child : this.getChildren()) {
                Optional<Page> result = child.findPage(criteria);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Generated {
            @XmlAttribute(name="ref")
            protected String ref;

            public String getRef() {
                return this.ref;
            }

            public void setRef(String value) {
                this.ref = value;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @XmlType(name="attachment", namespace="https://github.com/bsorrentino/maven-confluence-plugin")
    public static class Attachment
    extends Source {
        public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
        public static final String DEFAULT_VERSION = "0";
        String contentType = "application/octet-stream";
        String comment;
        String version = "0";

        @XmlAttribute
        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @XmlAttribute
        public String getComment() {
            if (this.comment == null) {
                if (this.getName() == null) {
                    this.setComment("attached by maven-confluence-plugin");
                } else {
                    this.setComment(String.format("%s - attached by maven-confluence-plugin", this.getName()));
                }
            }
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        @XmlAttribute
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @XmlType(namespace="https://github.com/bsorrentino/maven-confluence-plugin")
    protected static class Source {
        private static final Pattern lead_trail_spaces = Pattern.compile("^(.*)\\s+$|^\\s+(.*)");
        protected final transient Site site = _SITE.peek();
        private URI uri;
        String name;

        @XmlAttribute
        public final URI getUri() {
            if (this.uri != null && !this.uri.isAbsolute()) {
                return this.site.getBasedir().toUri().resolve(this.uri);
            }
            return this.uri;
        }

        public final void setUri(URI value) {
            if (null == value) {
                throw new IllegalArgumentException("uri is null");
            }
            this.uri = value;
        }

        public URI getRelativeUri() {
            return this.site.getBasedir().toUri().relativize(this.getUri());
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        public final Optional<String> optName() {
            return Optional.ofNullable(this.name);
        }

        public void setName(String name) {
            if (lead_trail_spaces.matcher(name).matches()) {
                throw new IllegalArgumentException(String.format("name [%s] is not valid!", name));
            }
            this.name = name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.getName() + " - " + String.valueOf(this.getUri());
        }
    }
}

