/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.preprocessor.SitePocessorService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface SiteFactory {

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Model {
        public Site createSiteFromModel(Map<String, Object> var1);

        default public Site createFrom(File siteDescriptor, Map<String, Object> variables) throws Exception {
            if (variables == null) {
                throw new IllegalArgumentException("variables is null!");
            }
            String ext = Optional.ofNullable(FilenameUtils.getExtension((String)siteDescriptor.getName())).map(v -> v.toLowerCase()).orElse("");
            Function<String, CompletableFuture> _createSite = preprocessedDescriptor -> {
                CompletableFuture<Site> result = new CompletableFuture<Site>();
                switch (ext) {
                    case "xml": {
                        try {
                            ObjectMapper mapper = new ObjectMapper((JsonFactory)new XmlFactory());
                            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                            result.complete((Site)mapper.readValue(preprocessedDescriptor, Site.class));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                        break;
                    }
                    case "yml": 
                    case "yaml": {
                        try {
                            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                            result.complete((Site)mapper.readValue(preprocessedDescriptor, Site.class));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                        break;
                    }
                    default: {
                        result.completeExceptionally(new IllegalArgumentException(String.format("file extension [%s] not supported! Currently only '.xml' and '.yaml' are valid", ext)));
                    }
                }
                return result;
            };
            String content = new String(Files.readAllBytes(siteDescriptor.toPath()), StandardCharsets.UTF_8);
            Optional<SitePocessorService> siteProcessor = SitePocessorService.getDefaultPreprocessorService();
            return (Site)siteProcessor.map(p -> p.process(content, variables).thenCompose(_createSite)).orElseGet(() -> {
                LogHolder.log.debug((Object)String.format("a Preprocessor service is not configurated", new Object[0]));
                return (CompletableFuture)_createSite.apply(content);
            }).get();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Folder {
        public Site createSiteFromFolder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class LogHolder {
        private static final Log log = LogFactory.getLog(LogHolder.class);
    }
}

