/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DeployStateManager {
    private static final Logger log = Logger.getLogger(DeployStateManager.class.getName());
    public static final String STORAGE_NAME = ".confluence-maven-plugin-storage.json";
    private Map<String, Map<String, Data>> storage = new HashMap<String, Map<String, Data>>();
    private final String endpoint;
    private final Path outdir;
    private final JsonWriterFactory writerFactory;

    private static void debug(String msg, Object ... args) {
        log.fine(() -> String.format(msg, args));
    }

    private static void warn(String msg, Throwable ex) {
        log.log(Level.WARNING, msg, ex);
    }

    private static boolean isFileSchema(URI uri) {
        return Optional.ofNullable(uri).map(u -> "file".equalsIgnoreCase(u.getScheme())).orElse(false);
    }

    public static JsonString createValue(String value) {
        return Json.createArrayBuilder().add(value).build().getJsonString(0);
    }

    public static DeployStateManager load(String endpoint, Path outdir) {
        DeployStateManager result = new DeployStateManager(endpoint, outdir);
        result.load();
        return result;
    }

    private DeployStateManager(String endpoint, Path outdir) {
        Objects.requireNonNull(endpoint, "endpoint is null!");
        Objects.requireNonNull(outdir, "outdir is null!");
        if (!Files.exists(outdir, new LinkOption[0])) {
            try {
                Files.createDirectories(outdir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Impossible create path [%s]", outdir));
            }
        } else if (!Files.isDirectory(outdir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path [%s] is not a directory", outdir));
        }
        this.endpoint = endpoint;
        this.outdir = outdir;
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        this.writerFactory = Json.createWriterFactory(config);
    }

    private void load() {
        Path file = Paths.get(this.outdir.toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e2) {
                DeployStateManager.warn(String.format("error creating file '%s'", file), e2);
            }
        } else {
            try (JsonReader r = Json.createReader((Reader)Files.newBufferedReader(file));){
                r.readObject().entrySet().forEach(e -> {
                    HashMap ss = new HashMap();
                    ((JsonObject)e.getValue()).entrySet().forEach(ee -> ss.put((String)ee.getKey(), Data.of((JsonValue)ee.getValue())));
                    this.storage.put((String)e.getKey(), ss);
                });
            }
            catch (Exception ex) {
                DeployStateManager.warn(String.format("error reading file '%s'", file), ex);
            }
        }
        if (!this.storage.containsKey(this.endpoint)) {
            this.storage.put(this.endpoint, new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        DeployStateManager deployStateManager = this;
        synchronized (deployStateManager) {
            Path file = Paths.get(this.outdir.toString(), STORAGE_NAME);
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            JsonObjectBuilder b = Json.createObjectBuilder();
            this.storage.entrySet().forEach(e -> {
                JsonObjectBuilder b1 = Json.createObjectBuilder();
                ((Map)e.getValue()).entrySet().forEach(ee -> b1.add((String)ee.getKey(), ((Data)ee.getValue()).toJson()));
                b.add((String)e.getKey(), b1);
            });
            try (JsonWriter w = this.writerFactory.createWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
                w.writeObject(b.build());
            }
            catch (Exception ex) {
                DeployStateManager.warn(String.format("error saving file '%s'", file), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> CompletableFuture<U> isUpdated(URI uri, Optional<JsonValue> extraAttribute, Supplier<CompletableFuture<U>> yes, Supplier<CompletableFuture<U>> no) {
        DeployStateManager deployStateManager = this;
        synchronized (deployStateManager) {
            return this.isUpdated(uri, extraAttribute) ? yes.get() : no.get();
        }
    }

    private boolean isUpdated(URI uri, Optional<JsonValue> extraAttribute) {
        if (uri == null) {
            return false;
        }
        return !DeployStateManager.isFileSchema(uri) || this.isUpdated(Paths.get(uri), extraAttribute);
    }

    private Optional<String> getKeyFormUri(URI uri) {
        return uri != null && "file".equalsIgnoreCase(uri.getScheme()) ? Optional.ofNullable(Paths.get(uri)).flatMap(file -> Optional.ofNullable(String.valueOf(this.outdir.relativize(file.toAbsolutePath())))) : Optional.empty();
    }

    public Optional<JsonValue> getOptExtraAttribute(URI uri) {
        if (!DeployStateManager.isFileSchema(uri)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.storage.get(this.endpoint)).flatMap(s -> this.getKeyFormUri(uri).flatMap(key -> Optional.ofNullable((Data)s.get(key)).flatMap(data -> data.getOptExtraAttribute())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraAttribute(URI uri, JsonValue value) {
        DeployStateManager.debug("DeployStateManager.setExtraAttribute( '%s', '%s' )", String.valueOf(uri), String.valueOf(value));
        DeployStateManager deployStateManager = this;
        synchronized (deployStateManager) {
            this.isUpdated(uri, Optional.ofNullable(value));
        }
    }

    boolean isUpdated(Path file, Optional<JsonValue> extraAttribute) {
        DeployStateManager.debug("isUpdated( %s )", file);
        if (file == null) {
            return false;
        }
        return Optional.ofNullable(this.storage.get(this.endpoint)).map(s -> {
            String key = String.valueOf(this.outdir.relativize(file.toAbsolutePath()));
            String fileMd5Hash = this.md5Hash(file);
            boolean updated = Optional.ofNullable((Data)s.get(key)).map(data -> {
                String lastStoredFileMd5Hash = data.getHash().getString();
                if (!Objects.equals(fileMd5Hash, lastStoredFileMd5Hash)) {
                    DeployStateManager.debug("%s - data.setHash( %s )", key, fileMd5Hash);
                    data.setHash(DeployStateManager.createValue(fileMd5Hash));
                    return true;
                }
                return false;
            }).orElseGet(() -> {
                DeployStateManager.debug("%s - data.setHash( %s )", key, fileMd5Hash);
                s.put(key, Data.of((JsonValue)DeployStateManager.createValue(fileMd5Hash)));
                return true;
            });
            extraAttribute.ifPresent(extra -> ((Data)s.get(key)).setExtraAttribute((JsonValue)extra));
            return updated;
        }).orElse(true);
    }

    private String md5Hash(Path file) {
        String string;
        FileInputStream fis = new FileInputStream(file.toFile());
        Throwable throwable = null;
        try {
            string = DigestUtils.md5Hex((InputStream)fis);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    DeployStateManager.$closeResource(throwable, fis);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                DeployStateManager.warn(String.format("error generating md5Hash for file '%s'", file), e);
                return null;
            }
        }
        DeployStateManager.$closeResource(throwable, fis);
        return string;
    }

    public boolean removeState(URI uri) {
        return DeployStateManager.isFileSchema(uri) && this.removeState(Paths.get(uri));
    }

    boolean removeState(Path file) {
        if (file == null) {
            return false;
        }
        return Optional.ofNullable(this.storage.get(this.endpoint)).map(s -> {
            String key = String.valueOf(this.outdir.relativize(file.toAbsolutePath()));
            s.remove(key);
            return true;
        }).orElse(false);
    }

    public String toString() {
        return "DeployStateManager" + "\n\t" + "endopint=" + this.endpoint + "\n\t" + "outdir=" + this.outdir + "\n";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Data {
        private Optional<JsonValue> optExtraAttribute;
        private JsonString hash;

        public static Data of(JsonValue entry) {
            Objects.requireNonNull(entry, "entry is null!");
            switch (entry.getValueType()) {
                case STRING: {
                    return new Data((JsonString)entry);
                }
                case OBJECT: {
                    return new Data((JsonObject)entry);
                }
                case NULL: {
                    return new Data(DeployStateManager.createValue(""));
                }
            }
            throw new IllegalArgumentException(String.format("value [%s] is not valid type!", entry.toString()));
        }

        public static Data empty() {
            return Data.of((JsonValue)DeployStateManager.createValue(""));
        }

        private Data(JsonString hash) {
            this.optExtraAttribute = Optional.empty();
            this.hash = hash;
        }

        private Data(JsonObject entry) {
            this.optExtraAttribute = Optional.ofNullable((JsonValue)entry.get((Object)"extra"));
            this.hash = entry.getJsonString("hash");
        }

        public JsonString getHash() {
            return this.hash;
        }

        public void setHash(JsonString hash) {
            this.hash = hash;
        }

        public Optional<JsonValue> getOptExtraAttribute() {
            return this.optExtraAttribute;
        }

        public void setExtraAttribute(JsonValue value) {
            DeployStateManager.debug("Data.setExtraAttribute( %s )", new Object[]{String.valueOf(value)});
            this.optExtraAttribute = Optional.ofNullable(value);
        }

        final JsonValue toJson() {
            JsonObjectBuilder b = Json.createObjectBuilder();
            this.optExtraAttribute.ifPresent(extra -> b.add("extra", extra));
            return b.add("hash", (JsonValue)this.hash).build();
        }
    }
}

