/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.ssl;

import java.lang.reflect.InvocationTargetException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.bsc.ssl.SSLFactories;
import org.bsc.ssl.YesHostnameVerifier;
import org.bsc.ssl.YesTrustManager;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SSLCertificateInfo {
    boolean ignore = false;
    String hostnameVerifierClass;
    String trustManagerClass;

    protected static <T> T newClass(String clazz, Class<T> type) {
        try {
            Class<?> loadedClass = Thread.currentThread().getContextClassLoader().loadClass(clazz);
            Object initClass = loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return type.cast(initClass);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Could not found Class with name %s", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Could create Instance of Class with name %s. Class must be concrete.", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Could create Instance of Class with name %s. Class must have a no-arg constructor.", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public final boolean isIgnore() {
        return this.ignore;
    }

    public X509TrustManager getTrustManager() {
        YesTrustManager trustManager = this.trustManagerClass != null ? SSLCertificateInfo.newClass(this.trustManagerClass, X509TrustManager.class) : new YesTrustManager();
        return trustManager;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLSocketFactory sslSocketFactory = SSLFactories.newInstance(this.getTrustManager());
            return sslSocketFactory;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        YesHostnameVerifier hostnameVerifier = this.hostnameVerifierClass != null ? SSLCertificateInfo.newClass(this.hostnameVerifierClass, HostnameVerifier.class) : new YesHostnameVerifier();
        return hostnameVerifier;
    }

    public String toString() {
        return "SSLCertificate" + '{' + "ignore:" + this.ignore + ',' + "hostnameVerifierClass:'" + this.hostnameVerifierClass + "'," + "trustManagerClass:'" + this.trustManagerClass + ',' + '}';
    }
}

