/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.FileExtension;
import org.bsc.confluence.model.Site;
import org.bsc.markdown.MarkdownParserContext;
import org.bsc.markdown.MarkdownProcessor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SiteProcessor {
    private static Optional<InputStream> getResourceAsStream(String source) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(source);
        if (is == null) {
            cl = Site.class.getClassLoader();
            is = cl.getResourceAsStream(source);
        }
        return Optional.ofNullable(is);
    }

    public static <T> T processUri(URI uri, BiFunction<Optional<Exception>, Optional<InputStream>, T> callback) {
        Optional<InputStream> result;
        Objects.requireNonNull(uri, "uri is null!");
        Objects.requireNonNull(callback, "callback is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        if ("classpath".equalsIgnoreCase(scheme)) {
            result = SiteProcessor.getResourceAsStream(source);
            if (!result.isPresent()) {
                Exception ex = new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        } else {
            try {
                URL url = uri.toURL();
                result = Optional.ofNullable(url.openStream());
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening url [%s]!", source), e);
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        }
        return callback.apply(Optional.empty(), result);
    }

    public static <P extends Site.Page> CompletableFuture<PageContent> processPageUri(Site site, P child, Optional<ConfluenceService.Model.Page> page, URI uri, Optional<String> pagePrefixToApply) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        CompletableFuture<PageContent> result = new CompletableFuture<PageContent>();
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        String content = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            Optional<InputStream> is = SiteProcessor.getResourceAsStream(source);
            if (!is.isPresent()) {
                result.completeExceptionally(new Exception(String.format("page [%s] doesn't exist in classloader", source)));
                return result;
            }
            try {
                String candidateContent = IOUtils.toString((InputStream)is.get());
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, page, candidateContent, pagePrefixToApply) : candidateContent;
            }
            catch (IOException e) {
                result.completeExceptionally(new Exception(String.format("error processing markdown for page [%s] ", source)));
                return result;
            }
        }
        try {
            URL url = uri.toURL();
            InputStream is = url.openStream();
            String candidateContent = IOUtils.toString((InputStream)is);
            content = isMarkdown ? SiteProcessor.processMarkdown(site, child, page, candidateContent, pagePrefixToApply) : candidateContent;
        }
        catch (IOException e) {
            result.completeExceptionally(new Exception(String.format("error opening/processing page [%s]!", source), e));
            return result;
        }
        result.complete(PageContent.of(content, representation));
        return result;
    }

    public static <P extends Site.Page> CompletableFuture<PageContent> processUriContent(Site site, P child, URI uri, Optional<String> homePageTitle) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", uri));
        CompletableFuture<PageContent> result = new CompletableFuture<PageContent>();
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        String content = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            Optional<InputStream> is = SiteProcessor.getResourceAsStream(source);
            if (!is.isPresent()) {
                result.completeExceptionally(new Exception(String.format("resource [%s] doesn't exist in classloader", source)));
                return result;
            }
            try {
                String candidateContent = IOUtils.toString((InputStream)is.get());
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, Optional.empty(), candidateContent, homePageTitle) : candidateContent;
            }
            catch (IOException e) {
                result.completeExceptionally(new Exception(String.format("error processing page [%s] ", source)));
                return result;
            }
        }
        try {
            URL url = uri.toURL();
            InputStream is = url.openStream();
            String candidateContent = IOUtils.toString((InputStream)is);
            content = isMarkdown ? SiteProcessor.processMarkdown(site, child, Optional.empty(), candidateContent, homePageTitle) : candidateContent;
        }
        catch (IOException e) {
            result.completeExceptionally(new Exception(String.format("error opening url [%s]!", source), e));
            return result;
        }
        result.complete(PageContent.of(content, representation));
        return result;
    }

    public static String processMarkdown(final Site site, final Site.Page child, final Optional<ConfluenceService.Model.Page> page, String content, final Optional<String> pagePrefixToApply) throws IOException {
        return MarkdownProcessor.shared.processMarkdown(new MarkdownParserContext(){

            @Override
            public Optional<Site> getSite() {
                return Optional.of(site);
            }

            @Override
            public Optional<Site.Page> getPage() {
                return Optional.of(child);
            }

            @Override
            public Optional<String> getPagePrefixToApply() {
                return pagePrefixToApply;
            }

            @Override
            public boolean isLinkPrefixEnabled() {
                if (child.isIgnoreVariables().booleanValue()) {
                    return false;
                }
                return page.map(p -> !p.getTitle().contains("[")).orElse(true);
            }
        }, content);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class PageContent {
        @NonNull
        private final String content;
        @NonNull
        private final ConfluenceService.Storage.Representation type;

        public InputStream getInputStream() {
            return IOUtils.toInputStream((String)this.content);
        }

        public InputStream getInputStream(Charset charset) throws IOException {
            return IOUtils.toInputStream((String)this.content, (String)charset.toString());
        }

        public String getContent(Charset charset) {
            if (charset != Charset.defaultCharset()) {
                return new String(this.content.getBytes(Charset.defaultCharset()), charset);
            }
            return this.content;
        }

        private PageContent(@NonNull String content, @NonNull ConfluenceService.Storage.Representation type) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.content = content;
            this.type = type;
        }

        public static PageContent of(@NonNull String content, @NonNull ConfluenceService.Storage.Representation type) {
            return new PageContent(content, type);
        }

        @NonNull
        public String getContent() {
            return this.content;
        }

        @NonNull
        public ConfluenceService.Storage.Representation getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageContent)) {
                return false;
            }
            PageContent other = (PageContent)o;
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            ConfluenceService.Storage.Representation this$type = this.getType();
            ConfluenceService.Storage.Representation other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            ConfluenceService.Storage.Representation $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "SiteProcessor.PageContent(content=" + this.getContent() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }
}

