/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DeployStateManager {
    private static final Logger log = Logger.getLogger(DeployStateManager.class.getName());
    public static final String STORAGE_NAME = ".confluence-maven-plugin-storage.json";
    private Map<String, Map<String, Data>> storage = new HashMap<String, Map<String, Data>>();
    private final String endpoint;
    private final Path outdir;
    private final JsonWriterFactory writerFactory;

    private static void debug(String msg, Object ... args) {
        log.fine(() -> String.format(msg, args));
    }

    private static void info(String msg, Object ... args) {
        log.info(() -> String.format(msg, args));
    }

    private static void warn(String msg, Throwable ex) {
        log.log(Level.WARNING, msg, ex);
    }

    private static boolean isFileSchema(URI uri) {
        return Optional.ofNullable(uri).map(u -> "file".equalsIgnoreCase(u.getScheme())).orElse(false);
    }

    public static JsonString createValue(String value) {
        return Json.createArrayBuilder().add(value).build().getJsonString(0);
    }

    public static JsonNumber createValue(int value) {
        return Json.createArrayBuilder().add(value).build().getJsonNumber(0);
    }

    public static DeployStateManager load(String endpoint, Path outdir) {
        DeployStateManager result = new DeployStateManager(endpoint, outdir);
        result.load();
        return result;
    }

    private DeployStateManager(String endpoint, Path outdir) {
        Objects.requireNonNull(endpoint, "endpoint is null!");
        Objects.requireNonNull(outdir, "outdir is null!");
        if (!Files.exists(outdir, new LinkOption[0])) {
            try {
                Files.createDirectories(outdir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Impossible create path [%s]", outdir));
            }
        } else if (!Files.isDirectory(outdir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path [%s] is not a directory", outdir));
        }
        this.endpoint = endpoint;
        this.outdir = outdir;
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        this.writerFactory = Json.createWriterFactory(config);
    }

    private void load() {
        Path file = Paths.get(this.outdir.toString(), STORAGE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
                this.save();
            }
            catch (IOException e2) {
                DeployStateManager.warn(String.format("error creating file '%s'", file), e2);
            }
        } else {
            try (JsonReader r = Json.createReader((Reader)Files.newBufferedReader(file));){
                r.readObject().entrySet().forEach(e -> {
                    HashMap ss = new HashMap();
                    ((JsonObject)e.getValue()).entrySet().forEach(ee -> ss.put((String)ee.getKey(), Data.of((JsonValue)ee.getValue())));
                    this.storage.put((String)e.getKey(), ss);
                });
            }
            catch (Exception ex) {
                DeployStateManager.warn(String.format("error reading file '%s'", file), ex);
            }
        }
        this.storage.computeIfAbsent(this.endpoint, key -> new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployStateManager save() {
        DeployStateManager deployStateManager = this;
        synchronized (deployStateManager) {
            Path file = Paths.get(this.outdir.toString(), STORAGE_NAME);
            if (!Files.exists(file, new LinkOption[0])) {
                return this;
            }
            JsonObjectBuilder b = Json.createObjectBuilder();
            this.storage.entrySet().forEach(e -> {
                JsonObjectBuilder b1 = Json.createObjectBuilder();
                ((Map)e.getValue()).entrySet().forEach(ee -> b1.add((String)ee.getKey(), ((Data)ee.getValue()).toJson()));
                b.add((String)e.getKey(), b1);
            });
            try (JsonWriter w = this.writerFactory.createWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
                w.writeObject(b.build());
            }
            catch (Exception ex) {
                DeployStateManager.warn(String.format("error saving file '%s'", file), ex);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> CompletableFuture<U> isUpdated(URI uri, Data attributes, Supplier<CompletableFuture<U>> yes, Supplier<CompletableFuture<U>> no) {
        DeployStateManager deployStateManager = this;
        synchronized (deployStateManager) {
            return this.isUpdated(uri, attributes) ? yes.get() : no.get();
        }
    }

    private boolean isUpdated(URI uri, Data attributes) {
        if (uri == null) {
            return false;
        }
        return !DeployStateManager.isFileSchema(uri) || this.isUpdated(Paths.get(uri), attributes);
    }

    private Optional<String> getKeyFormUri(URI uri) {
        return uri != null && "file".equalsIgnoreCase(uri.getScheme()) ? Optional.ofNullable(Paths.get(uri)).flatMap(file -> Optional.ofNullable(String.valueOf(this.outdir.relativize(file.toAbsolutePath())))) : Optional.empty();
    }

    public Optional<Data> getAttributes(URI uri) {
        if (!DeployStateManager.isFileSchema(uri)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.storage.get(this.endpoint)).flatMap(s -> this.getKeyFormUri(uri).flatMap(key -> Optional.ofNullable((Data)s.get(key))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(URI uri, Data attributes) {
        DeployStateManager.debug("DeployStateManager.setAttributes( '%s', '%s' )", String.valueOf(uri), String.valueOf(attributes));
        DeployStateManager deployStateManager = this;
        synchronized (deployStateManager) {
            this.isUpdated(uri, attributes);
        }
    }

    boolean isUpdated(Path file, Data attributes) {
        DeployStateManager.debug("isUpdated( %s, %s )", file, attributes);
        if (file == null) {
            return false;
        }
        return Optional.ofNullable(this.storage.get(this.endpoint)).map(s -> {
            String key = String.valueOf(this.outdir.relativize(file.toAbsolutePath()));
            String fileMd5Hash = this.md5Hash(file);
            return Optional.ofNullable((Data)s.get(key)).map(data -> data.copyAttributes(attributes, true)).map(data -> data.getHash().map(lastStoredFileMd5Hash -> {
                if (!Objects.equals(fileMd5Hash, lastStoredFileMd5Hash)) {
                    DeployStateManager.debug("%s - data.setHash( %s )", key, fileMd5Hash);
                    data.setHash(fileMd5Hash);
                    return true;
                }
                return false;
            }).orElse(false)).orElseGet(() -> {
                DeployStateManager.debug("%s - data.setHash( %s )", key, fileMd5Hash);
                Data attrs = Data.of(attributes).setHash(fileMd5Hash);
                s.put(key, attrs);
                return true;
            });
        }).orElse(true);
    }

    private String md5Hash(Path file) {
        String string;
        FileInputStream fis = new FileInputStream(file.toFile());
        Throwable throwable = null;
        try {
            string = DigestUtils.md5Hex((InputStream)fis);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    DeployStateManager.$closeResource(throwable, fis);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                DeployStateManager.warn(String.format("error generating md5Hash for file '%s'", file), e);
                return null;
            }
        }
        DeployStateManager.$closeResource(throwable, fis);
        return string;
    }

    public DeployStateManager clear() {
        this.storage.computeIfPresent(this.endpoint, (key, prev) -> {
            DeployStateManager.info("cleared [%d] entries in deploy state manager!", prev.size());
            return new HashMap();
        });
        return this;
    }

    public boolean removeState(URI uri) {
        return DeployStateManager.isFileSchema(uri) && this.removeState(Paths.get(uri));
    }

    boolean removeState(Path file) {
        if (file == null) {
            return false;
        }
        return Optional.ofNullable(this.storage.get(this.endpoint)).map(s -> {
            String key = String.valueOf(this.outdir.relativize(file.toAbsolutePath()));
            s.remove(key);
            return true;
        }).orElse(false);
    }

    public String toString() {
        return "DeployStateManager" + "\n\t" + "endopint=" + this.endpoint + "\n\t" + "outdir=" + this.outdir + "\n";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Data {
        static final String HASH = "hash";
        private Map<String, JsonValue> attributes = new HashMap<String, JsonValue>();

        public static Data of(JsonValue entry) {
            Objects.requireNonNull(entry, "entry is null!");
            switch (entry.getValueType()) {
                case STRING: {
                    return Data.create().setHash(((JsonString)entry).getString());
                }
                case OBJECT: {
                    return new Data((Map<String, JsonValue>)((JsonObject)entry));
                }
                case NULL: {
                    return new Data();
                }
            }
            throw new IllegalArgumentException(String.format("value [%s] is not valid type!", entry.toString()));
        }

        public static Data of(Data data) {
            return data == null ? new Data() : new Data(data.attributes);
        }

        public static Data create() {
            return new Data();
        }

        private Data() {
        }

        private Data(Map<String, JsonValue> attributes) {
            this.attributes.putAll(attributes);
        }

        public Optional<String> getHash() {
            return this.getAttributeString(HASH);
        }

        public Data setHash(String hash) {
            this.setAttributeString(HASH, hash);
            return this;
        }

        public Optional<String> getAttributeString(String name) {
            DeployStateManager.debug("Data.getAttributeString( %s )", new Object[]{name});
            return Optional.ofNullable(this.attributes.get(name.toLowerCase())).flatMap(v -> {
                if (v.getValueType() == JsonValue.ValueType.STRING) {
                    return Optional.ofNullable(((JsonString)v).getString());
                }
                return Optional.empty();
            });
        }

        public Optional<Integer> getAttributeInt(String name) {
            DeployStateManager.debug("Data.getAttributeInt( %s )", new Object[]{name});
            return Optional.ofNullable(this.attributes.get(name.toLowerCase())).flatMap(v -> {
                if (v.getValueType() == JsonValue.ValueType.NUMBER) {
                    return Optional.ofNullable(((JsonNumber)v).intValue());
                }
                return Optional.empty();
            });
        }

        public Data setAttributeString(String name, String value) {
            DeployStateManager.debug("Data.setAttributeString( %s, %s )", new Object[]{name, value});
            this.attributes.put(name.toLowerCase(), (JsonValue)DeployStateManager.createValue(value));
            return this;
        }

        public Data setAttributeInt(String name, Integer value) {
            DeployStateManager.debug("Data.setAttributeInt( %s, %d )", new Object[]{name, value});
            this.attributes.put(name.toLowerCase(), (JsonValue)DeployStateManager.createValue(value));
            return this;
        }

        public final Data copyAttributes(Data data, boolean excludeHash) {
            if (data == null) {
                return this;
            }
            if (excludeHash) {
                data.attributes.entrySet().stream().filter(attr -> HASH.compareTo((String)attr.getKey()) != 0).forEach(attr -> this.attributes.put((String)attr.getKey(), (JsonValue)attr.getValue()));
            } else {
                this.attributes.putAll(data.attributes);
            }
            return this;
        }

        final JsonValue toJson() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            this.attributes.entrySet().forEach(e -> builder.add((String)e.getKey(), (JsonValue)e.getValue()));
            return builder.build();
        }

        public String toString() {
            return this.attributes.entrySet().stream().map(e -> String.format("[%s,%s]", e.getKey(), e.getValue())).collect(Collectors.joining(","));
        }
    }
}

