/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.model.Site;
import org.bsc.preprocessor.SiteProcessorService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface SiteFactory {

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Model {
        public Site createSiteFromModel(Map<String, Object> var1);

        default public Site createFrom(File siteDescriptor, Map<String, Object> variables) throws Exception {
            byte[] siteDescriptorBytes;
            if (variables == null) {
                throw new IllegalArgumentException("variables is null!");
            }
            String ext = Optional.ofNullable(FilenameUtils.getExtension((String)siteDescriptor.getName())).map(v -> v.toLowerCase()).orElse("");
            Function<String, CompletableFuture> _createSite = preprocessedDescriptor -> {
                CompletableFuture<Site> result = new CompletableFuture<Site>();
                switch (ext) {
                    case "xml": {
                        try {
                            ObjectMapper mapper = new ObjectMapper((JsonFactory)new XmlFactory());
                            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                            result.complete((Site)mapper.readValue(preprocessedDescriptor, Site.class));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                        break;
                    }
                    case "yml": 
                    case "yaml": {
                        try {
                            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                            result.complete((Site)mapper.readValue(preprocessedDescriptor, Site.class));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                        break;
                    }
                    case "json": {
                        try {
                            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
                            result.complete((Site)mapper.readValue(preprocessedDescriptor, Site.class));
                        }
                        catch (Exception e) {
                            result.completeExceptionally(e);
                        }
                    }
                    default: {
                        result.completeExceptionally(new IllegalArgumentException(String.format("file extension [%s] not supported! Currently only '.xml', '.yaml' and '.json'are valid", ext)));
                    }
                }
                return result;
            };
            try (FileInputStream is = new FileInputStream(siteDescriptor.toPath().toFile());){
                siteDescriptorBytes = IOUtils.toByteArray((InputStream)is);
            }
            String content = new String(siteDescriptorBytes, StandardCharsets.UTF_8);
            Optional<SiteProcessorService> siteProcessor = SiteProcessorService.getDefaultPreprocessorService();
            CompletableFuture future = siteProcessor.map(p -> p.process(content, variables).thenCompose(_createSite)).orElseGet(() -> {
                LogHolder.log.fine(String.format("a Preprocessor service is not configurated", new Object[0]));
                return (CompletableFuture)_createSite.apply(content);
            });
            return (Site)future.join();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Folder {
        public Site createSiteFromFolder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class LogHolder {
        private static final Logger log = Logger.getLogger(LogHolder.class.getName());
    }
}

